/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public interface IConfigurableWidget
extends IConfigurable {
    public static final Function<String, AnnotationDetector.Wrapper<LDLRegister, IConfigurableWidget>> CACHE = class_156.method_34866(type -> {
        for (AnnotationDetector.Wrapper<LDLRegister, IConfigurableWidget> wrapper : AnnotationDetector.REGISTER_WIDGETS) {
            if (!wrapper.annotation().name().equals(type)) continue;
            return wrapper;
        }
        return null;
    });

    default public Widget widget() {
        return (Widget)((Object)this);
    }

    default public void initTemplate() {
    }

    default public boolean canDragIn(Object dragging) {
        if (dragging instanceof IGuiTexture) {
            return true;
        }
        if (dragging instanceof String) {
            return true;
        }
        if (dragging instanceof IIdProvider) {
            return true;
        }
        return dragging instanceof Integer;
    }

    default public boolean handleDragging(Object dragging) {
        if (dragging instanceof IGuiTexture) {
            IGuiTexture guiTexture = (IGuiTexture)dragging;
            this.widget().setBackground(guiTexture);
            return true;
        }
        if (dragging instanceof String) {
            String string = (String)dragging;
            this.widget().setHoverTooltips(string);
            return true;
        }
        if (dragging instanceof IIdProvider) {
            IIdProvider idProvider = (IIdProvider)dragging;
            this.widget().setId((String)idProvider.get());
            return true;
        }
        if (dragging instanceof Integer) {
            Integer color = (Integer)dragging;
            this.widget().setBackground(new ColorRectTexture(color));
            return true;
        }
        return false;
    }

    public static class_2487 serializeNBT(IConfigurableWidget widget, Resources resources, boolean isProject) {
        UIResourceTexture.setCurrentResource(resources.resources.get("ldlib.gui.editor.group.textures"), isProject);
        class_2487 tag = widget.serializeInnerNBT();
        UIResourceTexture.clearCurrentResource();
        return tag;
    }

    public static void deserializeNBT(IConfigurableWidget widget, class_2487 tag, Resources resources, boolean isProject) {
        UIResourceTexture.setCurrentResource(resources.resources.get("ldlib.gui.editor.group.textures"), isProject);
        widget.deserializeInnerNBT(tag);
        UIResourceTexture.clearCurrentResource();
    }

    default public class_2487 serializeInnerNBT() {
        class_2487 tag = new class_2487();
        PersistedParser.serializeNBT(tag, this.getClass(), this);
        return tag;
    }

    default public void deserializeInnerNBT(class_2487 nbt) {
        PersistedParser.deserializeNBT(nbt, new HashMap<String, Method>(), this.getClass(), this);
    }

    default public class_2487 serializeWrapper() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", this.name());
        tag.method_10566("data", (class_2520)this.serializeInnerNBT());
        return tag;
    }

    @Nullable
    public static IConfigurableWidget deserializeWrapper(class_2487 tag) {
        String type = tag.method_10558("type");
        AnnotationDetector.Wrapper<LDLRegister, IConfigurableWidget> wrapper = CACHE.apply(type);
        if (wrapper != null) {
            IConfigurableWidget child = wrapper.creator().get();
            child.deserializeInnerNBT(tag.method_10562("data"));
            return child;
        }
        return null;
    }

    @FunctionalInterface
    public static interface IIdProvider
    extends Supplier<String> {
    }
}

