/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class ConfiguratorGroup
extends Configurator {
    protected boolean canCollapse = true;
    protected boolean isCollapse;
    protected List<Configurator> configurators = new ArrayList<Configurator>();

    public ConfiguratorGroup(String name) {
        this(name, true);
    }

    public ConfiguratorGroup(String name, boolean isCollapse) {
        super(name);
        this.isCollapse = isCollapse;
    }

    @Override
    public void setConfigPanel(ConfigPanel configPanel, ConfigPanel.Tab tab) {
        super.setConfigPanel(configPanel, tab);
        for (Configurator configurator : this.configurators) {
            configurator.setConfigPanel(configPanel, tab);
        }
    }

    protected void clickName(ClickData clickData) {
        if (!this.canCollapse) {
            return;
        }
        this.setCollapse(!this.isCollapse);
    }

    public void setCollapse(boolean collapse) {
        this.isCollapse = collapse;
        for (Configurator configurator : this.configurators) {
            configurator.setActive(!this.isCollapse);
            configurator.setVisible(!this.isCollapse);
        }
        this.computeLayout();
    }

    public void addConfigurator(int index, Configurator configurator) {
        configurator.setConfigPanel(this.configPanel, this.tab);
        configurator.setActive(!this.isCollapse);
        configurator.setVisible(!this.isCollapse);
        this.configurators.add(index, configurator);
        this.addWidget(index, configurator);
        if (this.isInit()) {
            configurator.init(Math.max(0, this.width - 5));
            this.computeLayout();
        }
    }

    public void removeConfigurator(Configurator configurator) {
        if (this.configurators.remove(configurator)) {
            this.removeWidget(configurator);
        }
    }

    public void removeAllConfigurators() {
        for (Configurator configurator : this.configurators) {
            this.removeWidget(configurator);
        }
        this.configurators.clear();
    }

    public void addConfigurators(Configurator ... configurators) {
        for (Configurator configurator : configurators) {
            configurator.setConfigPanel(this.configPanel, this.tab);
            configurator.setActive(!this.isCollapse);
            configurator.setVisible(!this.isCollapse);
            this.configurators.add(configurator);
            this.addWidget(configurator);
        }
        if (this.isInit()) {
            for (Configurator configurator : configurators) {
                configurator.init(Math.max(0, this.width - 5));
            }
            this.computeLayout();
        }
    }

    @Override
    public void computeHeight() {
        int height = 15;
        if (!this.isCollapse) {
            for (Configurator configurator : this.configurators) {
                configurator.computeHeight();
                configurator.setSelfPosition(new Position(5, height));
                height += configurator.getSize().height;
            }
        }
        this.setSize(new Size(this.getSize().width, height));
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.addWidget(new ButtonWidget(0, 0, this.leftWidth + 9, 15, IGuiTexture.EMPTY, this::clickName));
        for (Configurator configurator : this.configurators) {
            configurator.init(Math.max(0, width - 5));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull @NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.isCollapse) {
            Icons.RIGHT.setColor(-1).draw(graphics, mouseX, mouseY, pos.x + this.leftWidth, pos.y + 3, 9, 9);
        } else {
            Icons.DOWN.setColor(-1).draw(graphics, mouseX, mouseY, pos.x + this.leftWidth, pos.y + 3, 9, 9);
            if (this.configurators.size() > 0) {
                DrawerHelper.drawSolidRect(graphics, pos.x + 2, pos.y + 17, 1, size.height - 19, ColorPattern.T_WHITE.color);
            }
        }
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    public void setCanCollapse(boolean canCollapse) {
        this.canCollapse = canCollapse;
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    public List<Configurator> getConfigurators() {
        return this.configurators;
    }
}

