/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class Configurator
extends WidgetGroup {
    protected ConfigPanel configPanel;
    protected ConfigPanel.Tab tab;
    protected String[] tips = new String[0];
    protected String name;
    protected int leftWidth;
    protected int rightWidth;
    protected int width = -1;
    @Nullable
    protected LabelWidget nameWidget;

    public Configurator(String name) {
        super(0, 0, 200, 15);
        this.name = name;
        this.setClientSideWidget();
        if (!name.isEmpty()) {
            this.nameWidget = new LabelWidget(3, 3, name);
            this.addWidget(this.nameWidget);
            this.leftWidth = class_310.method_1551().field_1772.method_1727(LocalizationUtils.format(name, new Object[0])) + 6;
        } else {
            this.leftWidth = 3;
        }
    }

    public Configurator() {
        this("");
    }

    public void setConfigPanel(ConfigPanel configPanel, ConfigPanel.Tab tab) {
        this.configPanel = configPanel;
        this.tab = tab;
    }

    public void computeLayout() {
        if (this.configPanel != null) {
            this.configPanel.computeLayout(this.tab);
        }
    }

    public void setTips(String ... tips) {
        this.tips = tips;
        this.rightWidth = tips.length > 0 ? 13 : 0;
    }

    public boolean isInit() {
        return this.width > -1;
    }

    public void computeHeight() {
    }

    public void init(int width) {
        this.width = width;
        this.setSize(new Size(width, this.getSize().height));
        if (this.tips.length > 0) {
            this.addWidget(new ImageWidget(width - 12, 2, 9, 9, Icons.HELP).setHoverTooltips(this.tips));
        }
    }

    public ConfigPanel getConfigPanel() {
        return this.configPanel;
    }

    public ConfigPanel.Tab getTab() {
        return this.tab;
    }

    public String getName() {
        return this.name;
    }

    public int getLeftWidth() {
        return this.leftWidth;
    }

    public int getRightWidth() {
        return this.rightWidth;
    }

    public int getWidth() {
        return this.width;
    }

    @Nullable
    public LabelWidget getNameWidget() {
        return this.nameWidget;
    }
}

