/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.BlockAnima;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.EntityInfo;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SceneAction
extends Action {
    private final List<class_3545<BlockAnima, BlockInfo>> addedBlocks = new ArrayList<class_3545<BlockAnima, BlockInfo>>();
    private final List<BlockAnima> removedBlocks = new ArrayList<BlockAnima>();
    private final Map<class_2338, BlockInfo> modifiedTags = new HashMap<class_2338, BlockInfo>();
    private final Map<BlockPosFace, Integer> highlightedBlocks = new HashMap<BlockPosFace, Integer>();
    private final List<class_3545<EntityInfo, class_243>> addedEntities = new ArrayList<class_3545<EntityInfo, class_243>>();
    private final List<class_3545<EntityInfo, class_243>> modifiedEntities = new ArrayList<class_3545<EntityInfo, class_243>>();
    private final List<class_3545<EntityInfo, Boolean>> removedEntities = new ArrayList<class_3545<EntityInfo, Boolean>>();
    private final Map<class_243, MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>> tooltipBlocks = new HashMap<class_243, MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>>();
    private Float rotation;
    private int duration = -1;

    public SceneAction() {
    }

    public SceneAction(Element element) {
        super(element);
        NodeList nodes = element.getChildNodes();
        block22: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element data = (Element)node;
            String nodeName = data.getNodeName();
            class_2338 blockPos = XmlUtils.getAsBlockPos(data, "pos", class_2338.field_10980);
            class_243 pos = XmlUtils.getAsVec3(data, "pos", class_243.field_1353);
            switch (nodeName) {
                case "add": {
                    this.addedBlocks.add((class_3545<BlockAnima, BlockInfo>)new class_3545((Object)new BlockAnima(blockPos, XmlUtils.getAsVec3(data, "offset", new class_243(0.0, 0.7, 0.0)), XmlUtils.getAsInt(data, "duration", 15)), (Object)XmlUtils.getBlockInfo(data)));
                    continue block22;
                }
                case "remove": {
                    this.removedBlocks.add(new BlockAnima(blockPos, XmlUtils.getAsVec3(data, "offset", new class_243(0.0, 0.7, 0.0)), XmlUtils.getAsInt(data, "duration", 15)));
                    continue block22;
                }
                case "modify": {
                    this.modifiedTags.put(blockPos, XmlUtils.getBlockInfo(data));
                    continue block22;
                }
                case "add-entity": {
                    this.addedEntities.add((class_3545<EntityInfo, class_243>)new class_3545((Object)XmlUtils.getEntityInfo(data), (Object)pos));
                    continue block22;
                }
                case "modify-entity": {
                    this.modifiedEntities.add((class_3545<EntityInfo, class_243>)new class_3545((Object)XmlUtils.getEntityInfo(data), (Object)XmlUtils.getAsVec3(data, "pos", null)));
                    continue block22;
                }
                case "remove-entity": {
                    this.removedEntities.add((class_3545<EntityInfo, Boolean>)new class_3545((Object)XmlUtils.getEntityInfo(data), (Object)XmlUtils.getAsBoolean(data, "force", false)));
                    continue block22;
                }
                case "rotation": {
                    this.rotation = Float.valueOf(XmlUtils.getAsFloat(data, "degree", 0.0f));
                    continue block22;
                }
                case "highlight": {
                    this.highlightedBlocks.put(new BlockPosFace(blockPos, XmlUtils.getAsEnum(data, "face", class_2350.class, null)), XmlUtils.getAsInt(data, "duration", 40));
                    continue block22;
                }
                case "tooltip": {
                    this.tooltipBlocks.put(XmlUtils.getAsVec3(data, "pos", new class_243(0.0, 0.0, 0.0)), (MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>)MutableTriple.of((Object)new class_3545((Object)XmlUtils.getIngredient(data), new ArrayList<class_5250>(XmlUtils.getComponents(data, class_2583.field_24360))), (Object)XmlUtils.getAsVec2(data, "screen-offset", new class_241(0.3f, 0.3f)), (Object)XmlUtils.getAsInt(data, "duration", 40)));
                }
            }
        }
    }

    public SceneAction rotation(Float rotation) {
        this.rotation = rotation;
        return this;
    }

    public SceneAction addedBlock(class_2338 pos, BlockInfo blockInfo, class_243 offset, int duration) {
        this.addedBlocks.add((class_3545<BlockAnima, BlockInfo>)new class_3545((Object)new BlockAnima(pos, offset, duration), (Object)blockInfo));
        return this;
    }

    public SceneAction removedBlock(class_2338 pos, class_243 offset, int duration) {
        this.removedBlocks.add(new BlockAnima(pos, offset, duration));
        return this;
    }

    public SceneAction modifiedTag(class_2338 pos, BlockInfo blockInfo) {
        this.modifiedTags.put(pos, blockInfo);
        return this;
    }

    public SceneAction highlightedBlock(class_2338 pos, class_2350 face, int duration) {
        this.highlightedBlocks.put(new BlockPosFace(pos, face), duration);
        return this;
    }

    public SceneAction addedEntity(EntityInfo entityInfo, class_243 pos) {
        this.addedEntities.add((class_3545<EntityInfo, class_243>)new class_3545((Object)entityInfo, (Object)pos));
        return this;
    }

    public SceneAction modifiedEntity(EntityInfo entityInfo, class_243 pos) {
        this.modifiedEntities.add((class_3545<EntityInfo, class_243>)new class_3545((Object)entityInfo, (Object)pos));
        return this;
    }

    public SceneAction removedEntity(EntityInfo entityInfo, boolean force) {
        this.removedEntities.add((class_3545<EntityInfo, Boolean>)new class_3545((Object)entityInfo, (Object)force));
        return this;
    }

    public SceneAction tooltip(class_243 pos, class_3545<XmlUtils.SizedIngredient, List<class_2561>> tooltip, class_241 screenOffset, int duration) {
        this.tooltipBlocks.put(pos, (MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>)MutableTriple.of(tooltip, (Object)screenOffset, (Object)duration));
        return this;
    }

    @Override
    public int getDuration() {
        if (this.duration == -1) {
            this.duration = 0;
            for (class_3545<BlockAnima, BlockInfo> class_35452 : this.addedBlocks) {
                this.duration = Math.max(this.duration, ((BlockAnima)class_35452.method_15442()).duration());
            }
            for (BlockAnima blockAnima : this.removedBlocks) {
                this.duration = Math.max(this.duration, blockAnima.duration());
            }
            for (Map.Entry entry : this.highlightedBlocks.entrySet()) {
                this.duration = Math.max(this.duration, (Integer)entry.getValue());
            }
            for (Map.Entry entry : this.tooltipBlocks.entrySet()) {
                this.duration = Math.max(this.duration, (Integer)((MutableTriple)entry.getValue()).getRight());
            }
        }
        return this.duration + 5;
    }

    @Override
    public void performAction(AnimationFrame frame, CompassScene scene, boolean anima) {
        class_243 pos;
        for (class_3545<BlockAnima, BlockInfo> class_35452 : this.addedBlocks) {
            BlockInfo blockInfo = (BlockInfo)class_35452.method_15441();
            blockInfo.clearBlockEntityCache();
            scene.addBlock(((BlockAnima)class_35452.method_15442()).pos(), blockInfo, anima ? (BlockAnima)class_35452.method_15442() : null);
        }
        for (BlockInfo blockInfo : this.modifiedTags.values()) {
            blockInfo.clearBlockEntityCache();
        }
        for (BlockAnima blockAnima : this.removedBlocks) {
            scene.removeBlock(blockAnima.pos(), anima ? blockAnima : null);
        }
        for (Map.Entry entry : this.modifiedTags.entrySet()) {
            scene.addBlock((class_2338)entry.getKey(), (BlockInfo)entry.getValue(), null);
        }
        for (class_3545 class_35453 : this.addedEntities) {
            pos = (class_243)class_35453.method_15441();
            scene.addEntity((EntityInfo)class_35453.method_15442(), pos, false);
        }
        for (class_3545 class_35454 : this.modifiedEntities) {
            pos = (class_243)class_35454.method_15441();
            scene.addEntity((EntityInfo)class_35454.method_15442(), pos, true);
        }
        for (class_3545 class_35455 : this.removedEntities) {
            scene.removeEntity((EntityInfo)class_35455.method_15442(), (Boolean)class_35455.method_15441());
        }
        if (anima) {
            for (Map.Entry entry : this.highlightedBlocks.entrySet()) {
                scene.highlightBlock((BlockPosFace)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (anima) {
            for (Map.Entry entry : this.tooltipBlocks.entrySet()) {
                scene.addTooltip((class_243)entry.getKey(), (class_3545<XmlUtils.SizedIngredient, List<class_2561>>)((class_3545)((MutableTriple)entry.getValue()).getLeft()), (class_241)((MutableTriple)entry.getValue()).getMiddle(), (Integer)((MutableTriple)entry.getValue()).getRight());
            }
        }
        if (this.rotation != null) {
            scene.rotate(this.rotation.floatValue(), anima);
        }
    }
}

