/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.TooltipBGTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.w3c.dom.Element;

public class InformationAction
extends Action {
    private final IGuiTexture guiTexture;
    private final List<class_2561> text = new ArrayList<class_2561>();

    public InformationAction(IGuiTexture guiTexture, List<class_2561> text) {
        this.guiTexture = guiTexture;
        this.text.addAll(text);
    }

    public InformationAction(Element element) {
        super(element);
        float u0 = XmlUtils.getAsFloat(element, "u0", 0.0f);
        float v0 = XmlUtils.getAsFloat(element, "v0", 0.0f);
        float u1 = XmlUtils.getAsFloat(element, "u1", 1.0f);
        float v1 = XmlUtils.getAsFloat(element, "v1", 1.0f);
        String type = XmlUtils.getAsString(element, "type", "");
        String url = XmlUtils.getAsString(element, "url", "");
        this.guiTexture = switch (type) {
            case "resource" -> new ResourceTexture(url).getSubTexture(u0, v0, u1, v1);
            case "item" -> new ItemStackTexture((class_1792)class_7923.field_41178.method_10223(new class_2960(url)));
            case "shader" -> ShaderTexture.createShader(new class_2960(url));
            default -> IGuiTexture.EMPTY;
        };
        this.text.addAll(XmlUtils.getComponents(element, class_2583.field_24360));
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public void performAction(AnimationFrame frame, CompassScene scene, boolean anima) {
        int size = Math.min(scene.getHeaderGroup().getSize().width, scene.getHeaderGroup().getSize().height);
        if (this.text.isEmpty() && this.guiTexture == IGuiTexture.EMPTY) {
            return;
        }
        if (this.text.isEmpty()) {
            scene.addInformation(new ImageWidget(0, 0, size, size, this.guiTexture), anima);
        } else if (this.guiTexture == IGuiTexture.EMPTY) {
            ComponentPanelWidget componentPanelWidget = new ComponentPanelWidget(0, 0, this.text).clickHandler(CompassManager::onComponentClick);
            componentPanelWidget.setBackground(TooltipBGTexture.INSTANCE);
            int maxWidth = 0;
            while (maxWidth < scene.getHeaderGroup().getSize().width && (componentPanelWidget.getSize().height == 0 || componentPanelWidget.getSize().height > size)) {
                componentPanelWidget.setMaxWidthLimit(maxWidth += 50);
            }
            scene.addInformation(componentPanelWidget, anima);
        } else {
            ComponentPanelWidget componentPanelWidget = new ComponentPanelWidget(0, 0, this.text).clickHandler(CompassManager::onComponentClick);
            componentPanelWidget.setBackground(TooltipBGTexture.INSTANCE);
            int maxWidth = 0;
            while (maxWidth < scene.getHeaderGroup().getSize().width && (componentPanelWidget.getSize().height == 0 || componentPanelWidget.getSize().height > size)) {
                componentPanelWidget.setMaxWidthLimit(maxWidth += 50);
            }
            WidgetGroup container = new WidgetGroup(0, 0, size + maxWidth, size);
            container.addWidget(new ImageWidget(2, 2, size - 4, size - 4, this.guiTexture));
            componentPanelWidget.addSelfPosition(size, (size - componentPanelWidget.getSize().height) / 2);
            container.addWidget(componentPanelWidget);
            scene.addInformation(container, anima);
        }
    }
}

