/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ISceneEntityRenderHook;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.component.CompassComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.BlockAnima;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.TooltipBGTexture;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.EntityInfo;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_745;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CompassScene
extends WidgetGroup
implements ISceneBlockRenderHook,
ISceneEntityRenderHook {
    protected final SceneWidget sceneWidget;
    protected final WidgetGroup headerGroup;
    protected final int minX;
    protected final int minY = 0;
    protected final int minZ;
    protected final int maxX;
    protected final int maxY = 0;
    protected final int maxZ;
    protected final List<AnimationFrame> frames;
    protected final boolean useScene;
    protected final boolean tickScene;
    protected TrackedDummyWorld world;
    private final Map<class_2338, class_3545<BlockAnima, Integer>> addedBlocks = new HashMap<class_2338, class_3545<BlockAnima, Integer>>();
    private final Map<class_2338, class_3545<BlockAnima, Integer>> removedBlocks = new HashMap<class_2338, class_3545<BlockAnima, Integer>>();
    private final Map<BlockPosFace, Integer> highlightBlocks = new HashMap<BlockPosFace, Integer>();
    private final Map<class_243, MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>> tooltipBlocks = new HashMap<class_243, MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>>();
    private final Map<class_243, class_241> tooltipPos = new HashMap<class_243, class_241>();
    private int currentFrame = -1;
    private int frameTick = 0;
    private boolean isPause;

    public CompassScene(int width, CompassComponent component) {
        super(0, 0, width, component.getHeight());
        this.frames = component.getFrames();
        this.useScene = component.isUseScene();
        this.tickScene = component.isTickScene();
        this.minX = -component.getRange();
        this.minZ = -component.getRange();
        this.maxX = component.getRange();
        this.maxZ = component.getRange();
        int height = component.getHeight();
        int headerHeight = 80;
        int sceneHeight = height - headerHeight;
        if (this.useScene) {
            int sw = sceneHeight * 4;
            this.world = new TrackedDummyWorld();
            this.sceneWidget = new SceneWidget((width - sw) / 2, headerHeight, sw, sceneHeight, this.world);
            this.sceneWidget.setHoverTips(true).useOrtho(component.isOrtho()).setOrthoRange(0.5f).setScalable(component.isScalable()).setDraggable(false).setRenderFacing(false).setRenderSelect(false);
            this.sceneWidget.getRenderer().setFov(30.0f);
            this.sceneWidget.setRenderedCore(List.of(class_2338.field_10980), this);
            this.sceneWidget.getRenderer().setSceneEntityRenderHook(this);
            if (component.getZoom() > 0.0f) {
                this.sceneWidget.setZoom(component.getZoom());
            } else {
                this.sceneWidget.setZoom(9.0f * class_3532.method_15355((float)(this.maxX - this.minX)));
            }
            this.sceneWidget.setBeforeWorldRender(this::renderBeforeWorld);
            this.sceneWidget.setAfterWorldRender(this::renderAfterWorld);
            this.sceneWidget.setCameraYawAndPitch(component.getYaw(), this.sceneWidget.getRotationPitch());
            this.addWidget(this.sceneWidget);
        } else {
            this.sceneWidget = null;
        }
        this.headerGroup = new WidgetGroup(0, 0, width, this.useScene ? headerHeight : height - 25);
        this.addWidget(this.headerGroup);
        this.addWidget(new ButtonWidget((width - 12) / 2 + 20, height - 20, 12, 12, Icons.REPLAY, this::replay).setHoverTexture(Icons.REPLAY.copy().setColor(ColorPattern.GREEN.color)));
        this.addWidget(new ButtonWidget((width - 12) / 2, height - 20, 12, 12, Icons.ROTATION, this::rotation).setHoverTexture(Icons.ROTATION.copy().setColor(ColorPattern.GREEN.color)));
        this.addWidget(new ButtonWidget((width - 12) / 2 + 40, height - 20, 12, 12, Icons.borderText(0, "+", -1), cd -> this.zoom(-1)).setHoverTexture(Icons.borderText(0, "+", ColorPattern.GREEN.color)));
        this.addWidget(new ButtonWidget((width - 12) / 2 - 40, height - 20, 12, 12, Icons.borderText(0, "-", -1), cd -> this.zoom(1)).setHoverTexture(Icons.borderText(0, "-", ColorPattern.GREEN.color)));
        this.addWidget(new SwitchWidget((width - 12) / 2 - 20, height - 20, 12, 12, this::playPause).setSupplier(() -> this.isPause).setTexture(Icons.PLAY_PAUSE, Icons.PLAY_PAUSE.copy().setColor(ColorPattern.GREEN.color)).setClientSideWidget());
        if (!this.frames.isEmpty()) {
            int progressWidth = (width - 2) / this.frames.size();
            for (int i = 0; i < this.frames.size(); ++i) {
                AnimationFrame frame = this.frames.get(i);
                int frameIndex = i;
                this.addWidget(new ProgressWidget(() -> {
                    if (this.currentFrame < 0) {
                        return 0.0;
                    }
                    if (frameIndex < this.currentFrame) {
                        return 1.0;
                    }
                    if (this.frameTick > 0 && frameIndex == this.currentFrame) {
                        int duration = frame.getDuration();
                        return ((float)this.frameTick + (this.isPause ? 0.0f : class_310.method_1551().method_1534())) / (float)Math.max(duration, 1);
                    }
                    return 0.0;
                }, progressWidth * i + 1 + 1, height - 6 + 1, progressWidth - 4, 4, new ProgressTexture(IGuiTexture.EMPTY, ColorPattern.WHITE.rectTexture())));
                this.addWidget(new ButtonWidget(progressWidth * i + 1, height - 6, progressWidth - 2, 6, ColorPattern.WHITE.borderTexture(1), cd -> this.jumpFrame(frame)).setHoverTooltips(frame.tooltips()).setHoverTexture(ColorPattern.GREEN.borderTexture(1)));
            }
        }
    }

    private void zoom(int value) {
        if (!this.useScene) {
            return;
        }
        float zoom = (float)class_3532.method_15350((double)(this.sceneWidget.getZoom() + (float)value), (double)0.1, (double)999.0);
        this.sceneWidget.setZoom(zoom);
    }

    private void renderBeforeWorld(SceneWidget sceneWidget) {
        class_332 graphics = new class_332(class_310.method_1551(), class_4597.method_22991((class_287)class_289.method_1348().method_1349()));
        graphics.method_51448().method_22903();
        RenderUtils.moveToFace(graphics.method_51448(), (float)(this.minX + this.maxX) / 2.0f, 0.0, (float)(this.minZ + this.maxZ) / 2.0f, class_2350.field_11033);
        RenderUtils.rotateToFace(graphics.method_51448(), class_2350.field_11036, null);
        int w = this.maxX - this.minX + 3;
        int h = this.maxZ - this.minZ + 3;
        new ResourceTexture("ldlib:textures/gui/darkened_slot.png").draw(graphics, 0, 0, (float)w / -2.0f, (float)h / -2.0f, w, h);
        graphics.method_51448().method_22909();
    }

    private void renderAfterWorld(SceneWidget sceneWidget) {
        class_4587 matrixStack = new class_4587();
        float tick = Math.abs(class_310.method_1551().method_1534() + (float)(this.gui.getTickCount() % 40L) - 20.0f) / 20.0f;
        for (Map.Entry<BlockPosFace, Integer> entry : this.highlightBlocks.entrySet()) {
            if (entry.getValue() <= 0) continue;
            if (entry.getKey().facing == null) {
                RenderUtils.renderBlockOverLay(matrixStack, entry.getKey().pos, 0.6f * tick, 0.0f, 0.0f, 1.01f);
                continue;
            }
            sceneWidget.drawFacingBorder(matrixStack, entry.getKey(), ColorUtils.color(1.0f * tick, 0.0f, 0.6f, 0.0f));
        }
        class_1041 window = class_310.method_1551().method_22683();
        for (class_243 pos : this.tooltipBlocks.keySet()) {
            Vector3f result = sceneWidget.getRenderer().project(new Vector3f((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350));
            float x = result.x() * (float)window.method_4486() / (float)window.method_4489();
            float y = ((float)window.method_4506() - result.y()) * (float)window.method_4502() / (float)window.method_4506();
            this.tooltipPos.put(pos, new class_241(x, y));
        }
    }

    @Override
    public void drawInForeground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        for (Map.Entry<class_243, MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>> entry : this.tooltipBlocks.entrySet()) {
            int maxWidth;
            class_241 screenPos = this.tooltipPos.get(entry.getKey());
            if (screenPos == null) continue;
            class_3545 tuple = (class_3545)entry.getValue().getLeft();
            XmlUtils.SizedIngredient ingredient = (XmlUtils.SizedIngredient)tuple.method_15442();
            class_1799[] items = (class_1799[])Arrays.stream(ingredient.ingredient().method_8105()).map(i -> {
                class_1799 copied = i.method_7972();
                copied.method_7939(ingredient.count());
                return copied;
            }).toArray(class_1799[]::new);
            List tooltips = (List)tuple.method_15441();
            mouseX = (int)((float)position.x + (float)size.width * ((class_241)entry.getValue().getMiddle()).field_1343);
            mouseY = (int)((float)position.y + (float)size.height * ((class_241)entry.getValue().getMiddle()).field_1342);
            DrawerHelper.drawLines(graphics, List.of(screenPos, new class_241((float)mouseX, (float)mouseY)), -1, -1, 0.75f);
            ComponentPanelWidget componentPanelWidget = new ComponentPanelWidget(0, 0, tooltips).clickHandler(CompassManager::onComponentClick);
            componentPanelWidget.setBackground(TooltipBGTexture.INSTANCE);
            for (maxWidth = 200; maxWidth < size.width && (componentPanelWidget.getSize().height == 0 || (float)(componentPanelWidget.getSize().height + mouseY) < (float)size.height * (1.0f - ((class_241)entry.getValue().getMiddle()).field_1342)); maxWidth += 50) {
                componentPanelWidget.setMaxWidthLimit(maxWidth);
            }
            componentPanelWidget.addSelfPosition(mouseX, mouseY);
            maxWidth = componentPanelWidget.getSize().width;
            int maxHeight = componentPanelWidget.getSize().height;
            int rightSpace = this.getGui().getScreenWidth() - mouseX;
            int bottomSpace = this.getGui().getScreenHeight() - mouseY;
            if (rightSpace < maxWidth) {
                componentPanelWidget.addSelfPosition(rightSpace - maxWidth, 0);
            }
            if (bottomSpace < maxHeight) {
                componentPanelWidget.addSelfPosition(0, bottomSpace - maxHeight);
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            componentPanelWidget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            if (items.length > 0) {
                new ItemStackTexture(items).draw(graphics, mouseX, mouseY, componentPanelWidget.getPosition().x + 2, componentPanelWidget.getPosition().y - 20, 16, 16);
            }
            graphics.method_51448().method_22909();
        }
    }

    private void playPause(ClickData clickData, boolean isPressed) {
        this.isPause = isPressed;
    }

    private void rotation(ClickData clickData) {
        if (!this.useScene) {
            return;
        }
        float current = this.sceneWidget.getRotationPitch();
        this.sceneWidget.setCameraYawAndPitchAnima(this.sceneWidget.getRotationYaw(), current + 90.0f, 20);
    }

    private void resetScene() {
        this.world.clear();
        this.sceneWidget.setCameraYawAndPitch(this.sceneWidget.getRotationYaw(), -135.0f);
        this.sceneWidget.getCore().clear();
        this.sceneWidget.getCore().add(class_2338.field_10980);
        this.headerGroup.clearAllWidgets();
        this.addedBlocks.clear();
        this.removedBlocks.clear();
        this.highlightBlocks.clear();
        this.tooltipBlocks.clear();
        this.currentFrame = -1;
    }

    private void jumpFrame(AnimationFrame frame) {
        this.resetScene();
        this.currentFrame = 0;
        for (AnimationFrame animationFrame : this.frames) {
            if (animationFrame != frame) {
                animationFrame.performFrameResult(this);
                ++this.currentFrame;
                continue;
            }
            this.frameTick = 0;
            break;
        }
    }

    private void replay(ClickData clickData) {
        this.resetScene();
        this.isPause = false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.frames.isEmpty()) {
            return;
        }
        if (!this.isPause) {
            this.addedBlocks.forEach((p, v) -> v.method_34965((Object)((Integer)v.method_15441() - 1)));
            this.removedBlocks.forEach((p, v) -> v.method_34965((Object)((Integer)v.method_15441() - 1)));
            this.highlightBlocks.replaceAll((p, v) -> v - 1);
            this.tooltipBlocks.forEach((p, v) -> v.setRight((Object)((Integer)v.getRight() - 1)));
            this.addedBlocks.entrySet().removeIf(e -> (Integer)((class_3545)e.getValue()).method_15441() <= 0);
            this.highlightBlocks.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
            this.tooltipBlocks.entrySet().removeIf(e -> (Integer)((MutableTriple)e.getValue()).getRight() <= 0);
            Iterator<Map.Entry<class_2338, class_3545<BlockAnima, Integer>>> iterator = this.removedBlocks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_2338, class_3545<BlockAnima, Integer>> entry = iterator.next();
                if ((Integer)entry.getValue().method_15441() > 0) continue;
                this.world.removeBlock(entry.getKey());
                this.sceneWidget.getCore().remove(entry.getKey());
                iterator.remove();
            }
            if (this.currentFrame < 0) {
                this.nextFrame();
            }
            if (this.currentFrame >= 0 && this.currentFrame < this.frames.size() && this.frames.get(this.currentFrame).onFrameTick(this, this.frameTick++)) {
                this.nextFrame();
            }
            if (this.tickScene && this.useScene) {
                this.world.tickWorld();
            }
        }
    }

    protected void nextFrame() {
        if (this.currentFrame < 0) {
            this.currentFrame = 0;
        } else {
            ++this.currentFrame;
            if (this.currentFrame >= this.frames.size()) {
                this.currentFrame = -1;
                this.frameTick = 0;
                this.isPause = true;
                return;
            }
        }
        this.frameTick = -this.frames.get(this.currentFrame).delay();
    }

    @Override
    public void applyEntity(class_1937 world, class_1297 entity, class_4587 poseStack, float partialTicks) {
        ISceneEntityRenderHook.super.applyEntity(world, entity, poseStack, partialTicks);
    }

    @Override
    public void applyBESR(class_1937 world, class_2338 pos, class_2586 blockEntity, class_4587 poseStack, float partialTicks) {
        if (this.isPause) {
            partialTicks = 0.0f;
        }
        if (this.removedBlocks.containsKey(pos)) {
            class_3545<BlockAnima, Integer> tuple = this.removedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.method_15442();
            float tick = 1.0f - ((float)((Integer)tuple.method_15441()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                poseStack.method_22904((double)tick * anima.offset().field_1352, (double)tick * anima.offset().field_1351, (double)tick * anima.offset().field_1350);
            }
        } else if (this.addedBlocks.containsKey(pos)) {
            class_3545<BlockAnima, Integer> tuple = this.addedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.method_15442();
            float tick = ((float)((Integer)tuple.method_15441()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                tick = Eases.EaseQuadIn.getInterpolation(tick);
                poseStack.method_22904((double)tick * anima.offset().field_1352, (double)tick * anima.offset().field_1351, (double)tick * anima.offset().field_1350);
            }
        }
    }

    @Override
    public void applyVertexConsumerWrapper(class_1937 world, class_2338 pos, class_2680 state, WorldSceneRenderer.VertexConsumerWrapper wrapperBuffer, class_1921 layer, float partialTicks) {
        if (this.isPause) {
            partialTicks = 0.0f;
        }
        if (this.removedBlocks.containsKey(pos)) {
            class_3545<BlockAnima, Integer> tuple = this.removedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.method_15442();
            float tick = 1.0f - ((float)((Integer)tuple.method_15441()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                wrapperBuffer.addOffset((double)tick * anima.offset().field_1352, (double)tick * anima.offset().field_1351, (double)tick * anima.offset().field_1350);
            }
        } else if (this.addedBlocks.containsKey(pos)) {
            class_3545<BlockAnima, Integer> tuple = this.addedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.method_15442();
            float tick = ((float)((Integer)tuple.method_15441()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                tick = Eases.EaseQuadIn.getInterpolation(tick);
                wrapperBuffer.addOffset((double)tick * anima.offset().field_1352, (double)tick * anima.offset().field_1351, (double)tick * anima.offset().field_1350);
            }
        }
    }

    public void addBlock(class_2338 pos, BlockInfo blockInfo, @Nullable BlockAnima anima) {
        if (!this.useScene) {
            return;
        }
        if (blockInfo.getBlockState().method_26204() == class_2246.field_10124) {
            this.removeBlock(pos, null);
            return;
        }
        this.world.addBlock(pos, blockInfo);
        this.sceneWidget.getCore().add(pos);
        if (anima != null) {
            this.addedBlocks.put(pos, (class_3545<BlockAnima, Integer>)new class_3545((Object)anima, (Object)anima.duration()));
        }
    }

    public void removeBlock(class_2338 pos, @Nullable BlockAnima anima) {
        if (!this.useScene) {
            return;
        }
        if (anima != null) {
            this.removedBlocks.put(pos, (class_3545<BlockAnima, Integer>)new class_3545((Object)anima, (Object)anima.duration()));
        } else {
            this.world.removeBlock(pos);
            this.sceneWidget.getCore().remove(pos);
        }
    }

    public void highlightBlock(BlockPosFace key, int duration) {
        if (!this.useScene) {
            return;
        }
        this.highlightBlocks.put(key, duration);
    }

    public void addEntity(EntityInfo entityInfo, @Nullable class_243 pos, boolean update) {
        class_1297 entity = null;
        if (update) {
            entity = this.world.entities.get(entityInfo.getId());
        }
        class_1297 class_12972 = entity = entity == null && entityInfo.getEntityType() != null ? entityInfo.getEntityType().method_5883((class_1937)this.world) : entity;
        if (entity == null && entityInfo.getEntityType() == class_1299.field_6097) {
            entity = new class_745(this.world.getAsClientWorld().get(), class_310.method_1551().field_1724.method_7334());
        }
        if (entity != null) {
            entity.method_5838(entityInfo.getId());
            if (pos != null) {
                entity.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            }
            if (entityInfo.getTag() != null) {
                entity.method_5651(entity.method_5647(new class_2487()).method_10553().method_10543(entityInfo.getTag()));
            }
            this.world.method_8649(entity);
        }
    }

    public void removeEntity(EntityInfo entityInfo, boolean force) {
        if (force) {
            this.world.entities.remove(entityInfo.getId());
        } else {
            Optional.ofNullable(this.world.entities.get(entityInfo.getId())).ifPresent(class_1297::method_31472);
        }
    }

    public void addTooltip(class_243 pos, class_3545<XmlUtils.SizedIngredient, List<class_2561>> tuple, class_241 middle, Integer time) {
        this.tooltipBlocks.put(pos, (MutableTriple<class_3545<XmlUtils.SizedIngredient, List<class_2561>>, class_241, Integer>)MutableTriple.of(tuple, (Object)middle, (Object)time));
    }

    public void rotate(float rotation, boolean anima) {
        if (!this.useScene) {
            return;
        }
        float current = this.sceneWidget.getRotationPitch();
        current += (rotation - 135.0f - current) % 360.0f;
        if (anima) {
            this.sceneWidget.setCameraYawAndPitchAnima(this.sceneWidget.getRotationYaw(), current, 20);
        } else {
            this.sceneWidget.setCameraYawAndPitch(this.sceneWidget.getRotationYaw(), current);
        }
    }

    public void addInformation(Widget widget, boolean anima) {
        if (anima) {
            for (Widget child : this.headerGroup.widgets) {
                this.headerGroup.removeWidgetAnima(child, new Transform().duration(500L).offset(-child.getSelfPosition().x - child.getSize().width, 0));
            }
        } else {
            this.headerGroup.clearAllWidgets();
        }
        Size size = this.headerGroup.getSize();
        widget.setSelfPosition(new Position((size.width - widget.getSize().width) / 2, (size.height - widget.getSize().height) / 2));
        if (anima) {
            this.headerGroup.addWidgetAnima(widget, new Transform().ease(Eases.EaseQuadOut).duration(500L).offset(size.width - widget.getSelfPosition().x, 0));
        } else {
            this.headerGroup.addWidget(widget);
        }
    }

    public SceneWidget getSceneWidget() {
        return this.sceneWidget;
    }

    public WidgetGroup getHeaderGroup() {
        return this.headerGroup;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        Objects.requireNonNull(this);
        return 0;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        Objects.requireNonNull(this);
        return 0;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public List<AnimationFrame> getFrames() {
        return this.frames;
    }
}

