/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.compass.component.AbstractComponent;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import org.joml.Vector3f;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SceneComponent
extends AbstractComponent {
    protected final List<Map<class_2338, BlockInfo>> pages = new ArrayList<Map<class_2338, BlockInfo>>();
    protected final List<Map<class_2338, String>> hoverInfos = new ArrayList<Map<class_2338, String>>();
    private boolean draggable = false;
    private boolean scalable = false;
    private boolean ortho = false;
    private float zoom = -1.0f;
    private float yaw = 25.0f;
    private int height = 150;
    int minX = Integer.MAX_VALUE;
    int minY = Integer.MAX_VALUE;
    int minZ = Integer.MAX_VALUE;
    int maxX = Integer.MIN_VALUE;
    int maxY = Integer.MIN_VALUE;
    int maxZ = Integer.MIN_VALUE;

    @Override
    public ILayoutComponent fromXml(Element element) {
        super.fromXml(element);
        this.draggable = XmlUtils.getAsBoolean(element, "draggable", this.draggable);
        this.scalable = XmlUtils.getAsBoolean(element, "scalable", this.scalable);
        this.ortho = !XmlUtils.getAsString(element, "camera", "ortho").equals("perspective");
        this.zoom = XmlUtils.getAsFloat(element, "zoom", this.zoom);
        this.yaw = XmlUtils.getAsFloat(element, "yaw", this.yaw);
        this.height = XmlUtils.getAsInt(element, "height", this.height);
        NodeList nodeList = element.getChildNodes();
        class_2338 offset = class_2338.field_10980;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element page;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(page = (Element)node).getNodeName().equals("page")) continue;
            this.addPage(page, offset);
            offset = offset.method_10069(500, 0, 500);
        }
        return this;
    }

    private void addPage(Element element, class_2338 offset) {
        HashMap<class_2338, BlockInfo> blocks = new HashMap<class_2338, BlockInfo>();
        HashMap<class_2338, String> contents = new HashMap<class_2338, String>();
        Object2BooleanOpenHashMap items = new Object2BooleanOpenHashMap();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element block;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(block = (Element)node).getNodeName().equals("block")) continue;
            class_2338 pos = XmlUtils.getAsBlockPos(block, "pos", class_2338.field_10980).method_10081((class_2382)offset);
            BlockInfo blockInfo = XmlUtils.getBlockInfo(block);
            boolean itemTips = XmlUtils.getAsBoolean(block, "item-tips", false);
            String content = XmlUtils.getContent(block, true);
            blocks.put(pos, blockInfo);
            contents.put(pos, content);
            items.put((Object)pos, itemTips);
        }
        this.pages.add(blocks);
        this.hoverInfos.add(contents);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected LayoutPageWidget addWidgets(LayoutPageWidget currentPage) {
        if (this.pages.isEmpty()) {
            return currentPage;
        }
        AtomicInteger pageNum = new AtomicInteger(0);
        WidgetGroup group = new WidgetGroup(0, 0, currentPage.getSize().width - this.leftMargin - this.rightMargin, this.height);
        TrackedDummyWorld world = new TrackedDummyWorld();
        for (Map<class_2338, BlockInfo> blocks : this.pages) {
            world.addBlocks(blocks);
        }
        SceneWidget sceneWidget = new SceneWidget((currentPage.getSize().width - this.leftMargin - this.rightMargin) / 2 - 2 * this.height, 0, 4 * this.height, this.height, world);
        sceneWidget.setOnAddedTooltips((scene, list) -> {
            BlockPosFace hoverPosFace = scene.getHoverPosFace();
            if (hoverPosFace == null) {
                return;
            }
            String hover = this.hoverInfos.get(pageNum.get()).getOrDefault(hoverPosFace.pos, "");
            if (!hover.isEmpty()) {
                list.add(class_2561.method_43470((String)hover));
            }
        }).setHoverTips(true).useOrtho(this.ortho).setOrthoRange(0.5f).setScalable(this.scalable).setDraggable(this.draggable).setRenderFacing(false).setRenderSelect(false);
        sceneWidget.getRenderer().setFov(30.0f);
        group.addWidget(sceneWidget);
        sceneWidget.setRenderedCore(this.pages.stream().flatMap(page -> page.keySet().stream()).toList(), null);
        sceneWidget.setBeforeWorldRender(scene -> {
            class_332 graphics = new class_332(class_310.method_1551(), class_4597.method_22991((class_287)class_289.method_1348().method_1349()));
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22903();
            RenderUtils.moveToFace(graphics.method_51448(), (float)(this.minX + this.maxX) / 2.0f, this.minY, (float)(this.minZ + this.maxZ) / 2.0f, class_2350.field_11033);
            RenderUtils.rotateToFace(graphics.method_51448(), class_2350.field_11036, null);
            int width = this.maxX - this.minX + 3;
            int height = this.maxZ - this.minZ + 3;
            new ResourceTexture("ldlib:textures/gui/darkened_slot.png").draw(graphics, 0, 0, (float)width / -2.0f, (float)height / -2.0f, width, height);
            graphics.method_51448().method_22909();
        });
        this.setPage(this.pages.get(0), sceneWidget);
        ButtonWidget left = (ButtonWidget)new ButtonWidget(20, this.height - 16, 12, 7, Icons.LEFT, null).setClientSideWidget();
        group.addWidget(left);
        ButtonWidget right = (ButtonWidget)new ButtonWidget(currentPage.getSize().width - this.leftMargin - this.rightMargin - 20 - 12, this.height - 16, 12, 7, Icons.RIGHT, null).setClientSideWidget();
        group.addWidget(right);
        left.setVisible(pageNum.get() - 1 >= 0);
        right.setVisible(pageNum.get() + 1 < this.pages.size());
        left.setOnPressCallback(cd -> {
            if (pageNum.get() - 1 >= 0) {
                this.setPage(this.pages.get(pageNum.addAndGet(-1)), sceneWidget);
            }
            left.setVisible(pageNum.get() - 1 >= 0);
            right.setVisible(pageNum.get() + 1 < this.pages.size());
        });
        right.setOnPressCallback(cd -> {
            if (pageNum.get() + 1 < this.pages.size()) {
                this.setPage(this.pages.get(pageNum.addAndGet(1)), sceneWidget);
            }
            left.setVisible(pageNum.get() - 1 >= 0);
            right.setVisible(pageNum.get() + 1 < this.pages.size());
        });
        group.addWidget(new ButtonWidget((currentPage.getSize().width - this.leftMargin - this.rightMargin - 24) / 2 + 6, this.height - 19, 12, 12, Icons.ROTATION, cd -> {
            float current = sceneWidget.getRotationPitch();
            sceneWidget.setCameraYawAndPitchAnima(sceneWidget.getRotationYaw(), current + 90.0f, 20);
        }).setClientSideWidget());
        if (this.hoverInfo != null) {
            group.setHoverTooltips(this.hoverInfo);
        }
        return currentPage.addStreamWidget(this.wrapper(group));
    }

    private void setPage(Map<class_2338, BlockInfo> blocks, SceneWidget sceneWidget) {
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        for (class_2338 vPos : blocks.keySet()) {
            this.minX = Math.min(this.minX, vPos.method_10263());
            this.minY = Math.min(this.minY, vPos.method_10264());
            this.minZ = Math.min(this.minZ, vPos.method_10260());
            this.maxX = Math.max(this.maxX, vPos.method_10263());
            this.maxY = Math.max(this.maxY, vPos.method_10264());
            this.maxY = Math.max(this.maxY, vPos.method_10264());
            this.maxZ = Math.max(this.maxZ, vPos.method_10260());
        }
        Vector3f center = new Vector3f((float)(this.minX + this.maxX) / 2.0f + 0.5f, (float)(this.minY + this.maxY) / 2.0f + 0.5f, (float)(this.minZ + this.maxZ) / 2.0f + 0.5f);
        if (this.zoom > 0.0f) {
            sceneWidget.setZoom(this.zoom);
        } else {
            sceneWidget.setZoom((float)(15.0 * Math.sqrt(Math.max(Math.max(Math.max(this.maxX - this.minX + 1, this.maxY - this.minY + 1), this.maxZ - this.minZ + 1), 1))));
        }
        sceneWidget.setCenter(center);
        sceneWidget.setCameraYawAndPitch(this.yaw, sceneWidget.getRotationPitch());
    }
}

