/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.compass.component.AbstractComponent;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.w3c.dom.Element;

public class RecipeComponent
extends AbstractComponent {
    public static final ResourceTexture PROGRESS_BAR_ARROW = new ResourceTexture("ldlib:textures/gui/progress_bar_arrow.png");
    private static final List<RecipeViewCreator> RECIPE_VIEW_CREATORS = new ArrayList<RecipeViewCreator>();
    @Nullable
    protected class_1860<?> recipe;

    public static void registerRecipeViewCreator(RecipeViewCreator recipeViewCreator) {
        RECIPE_VIEW_CREATORS.add(recipeViewCreator);
    }

    @Override
    public ILayoutComponent fromXml(Element element) {
        super.fromXml(element);
        if (element.hasAttribute("id")) {
            class_2960 recipeID = new class_2960(element.getAttribute("id"));
            for (class_1860 recipe : class_310.method_1551().method_1562().method_2877().method_8126()) {
                if (!recipe.method_8114().equals((Object)recipeID)) continue;
                this.recipe = recipe;
                return this;
            }
        }
        return this;
    }

    @Override
    protected LayoutPageWidget addWidgets(LayoutPageWidget currentPage) {
        if (this.recipe == null) {
            return currentPage;
        }
        Int2ObjectArrayMap inputs = new Int2ObjectArrayMap();
        class_1799 output = this.recipe.method_8110((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167));
        class_2371 ingredients = this.recipe.method_8117();
        class_1860<?> class_18602 = this.recipe;
        if (class_18602 instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)class_18602;
            int w = shapedRecipe.method_8150();
            int h = shapedRecipe.method_8158();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    inputs.put(i + j * w, (Object)((class_1856)ingredients.get(i + j * w)));
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.put(i, (Object)((class_1856)ingredients.get(i)));
            }
        }
        Widget recipeGroup = null;
        class_1799 workstation = class_1799.field_8037;
        for (RecipeViewCreator creator : RECIPE_VIEW_CREATORS) {
            if (!creator.test(this.recipe)) continue;
            recipeGroup = creator.getViewWidget(this.recipe);
            workstation = creator.getWorkstation(this.recipe);
            break;
        }
        if (recipeGroup == null) {
            if (this.recipe instanceof class_3955) {
                recipeGroup = this.createCraftingRecipeWidget((Int2ObjectMap<class_1856>)inputs, output);
                workstation = new class_1799((class_1935)class_1802.field_8465);
            } else if (this.recipe instanceof class_1874) {
                recipeGroup = this.createSmeltingRecipeWidget((Int2ObjectMap<class_1856>)inputs, output);
                workstation = new class_1799((class_1935)class_1802.field_8732);
            } else {
                recipeGroup = this.createCraftingRecipeWidget((Int2ObjectMap<class_1856>)inputs, output);
            }
        }
        ((WidgetGroup)recipeGroup).addWidget(new ImageWidget(-40, recipeGroup.getSize().height / 2 - 15, 30, 30, new ItemStackTexture(workstation)));
        return currentPage.addStreamWidget(this.wrapper(recipeGroup));
    }

    protected WidgetGroup createSmeltingRecipeWidget(Int2ObjectMap<class_1856> input, class_1799 output) {
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 150, 30);
        widgetGroup.setBackground(ResourceBorderTexture.BORDERED_BACKGROUND);
        CycleItemStackHandler itemStackHandler = new CycleItemStackHandler(List.of(Arrays.stream(((class_1856)input.getOrDefault(0, (Object)class_1856.field_9017)).method_8105()).toList()));
        widgetGroup.addWidget(new SlotWidget(itemStackHandler, 0, 20, 6, false, false));
        ItemStackTransfer handler = new ItemStackTransfer();
        handler.setStackInSlot(0, output);
        widgetGroup.addWidget(new ProgressWidget(ProgressWidget.JEIProgress, 65, 5, 20, 20, new ProgressTexture()));
        widgetGroup.addWidget(new SlotWidget(handler, 0, 120, 6, false, false));
        return widgetGroup;
    }

    protected WidgetGroup createCraftingRecipeWidget(Int2ObjectMap<class_1856> input, class_1799 output) {
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 150, 66);
        widgetGroup.setBackground(ResourceBorderTexture.BORDERED_BACKGROUND);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                CycleItemStackHandler itemStackHandler = new CycleItemStackHandler(List.of(Arrays.stream(((class_1856)input.getOrDefault(x + y * 3, (Object)class_1856.field_9017)).method_8105()).toList()));
                widgetGroup.addWidget(new SlotWidget(itemStackHandler, 0, x * 18 + 20, y * 18 + 6, false, false));
            }
        }
        ItemStackTransfer handler = new ItemStackTransfer();
        handler.setStackInSlot(0, output);
        widgetGroup.addWidget(new ProgressWidget(ProgressWidget.JEIProgress, 87, 23, 20, 20, PROGRESS_BAR_ARROW));
        widgetGroup.addWidget(new SlotWidget(handler, 0, 120, 24, false, false));
        return widgetGroup;
    }

    public static interface RecipeViewCreator
    extends Predicate<class_1860<?>> {
        public class_1799 getWorkstation(class_1860<?> var1);

        public WidgetGroup getViewWidget(class_1860<?> var1);
    }
}

