/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.w3c.dom.Element;

public abstract class AbstractComponent
implements ILayoutComponent {
    protected int topMargin = 0;
    protected int bottomMargin = 0;
    protected int leftMargin = 0;
    protected int rightMargin = 0;
    protected String hoverInfo;

    @Override
    public ILayoutComponent fromXml(Element element) {
        this.topMargin = XmlUtils.getAsInt(element, "top-margin", this.topMargin);
        this.bottomMargin = XmlUtils.getAsInt(element, "bottom-margin", this.bottomMargin);
        this.leftMargin = XmlUtils.getAsInt(element, "left-margin", this.leftMargin);
        this.rightMargin = XmlUtils.getAsInt(element, "right-margin", this.rightMargin);
        this.hoverInfo = XmlUtils.getAsString(element, "hover-info", null);
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public final LayoutPageWidget createWidgets(LayoutPageWidget currentPage) {
        if (this.topMargin > 0) {
            currentPage = currentPage.addOffsetSpace(this.topMargin);
        }
        currentPage = this.addWidgets(currentPage);
        if (this.bottomMargin > 0) {
            currentPage = currentPage.addOffsetSpace(this.bottomMargin);
        }
        return currentPage;
    }

    protected int width(LayoutPageWidget currentPage) {
        return currentPage.getPageWidth() - this.leftMargin - this.rightMargin;
    }

    protected Widget wrapper(Widget widget) {
        if (this.leftMargin != 0 || this.rightMargin != 0) {
            WidgetGroup group = new WidgetGroup();
            group.addWidget(widget);
            widget.setSelfPosition(new Position(this.leftMargin, 0));
            group.setSize(new Size(widget.getSize().width + this.leftMargin + this.rightMargin, widget.getSize().height));
            return group;
        }
        return widget;
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract LayoutPageWidget addWidgets(LayoutPageWidget var1);
}

