/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4431;

public class CompassSection {
    private final JsonObject config;
    public class_2960 sectionName;
    public int priority;
    public final Map<class_2960, CompassNode> nodes;
    protected IGuiTexture buttonTexture;
    protected IGuiTexture backgroundTexture;

    public CompassSection(class_2960 sectionName, JsonObject config) {
        this.config = config;
        this.sectionName = sectionName;
        this.nodes = new HashMap<class_2960, CompassNode>();
        this.priority = class_4431.method_21545((String)"priority", (JsonObject)config, (int)0);
        this.setButtonTexture(SimpleIGuiTextureJsonUtils.fromJson(config.get("button_texture").getAsJsonObject()));
        this.setBackgroundTexture(config.has("background_texture") ? SimpleIGuiTextureJsonUtils.fromJson(config.get("background_texture").getAsJsonObject()) : null);
    }

    public JsonObject updateJson() {
        this.config.addProperty("priority", (Number)this.priority);
        this.config.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.buttonTexture));
        if (this.backgroundTexture != null) {
            this.config.add("background_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.backgroundTexture));
        }
        return this.config;
    }

    public void addNode(CompassNode compassNode) {
        this.nodes.put(compassNode.getNodeName(), compassNode);
    }

    public final String toString() {
        return this.sectionName.toString();
    }

    public CompassNode getNode(class_2960 nodeName) {
        return this.nodes.get(nodeName);
    }

    public class_2561 getChatComponent() {
        return class_2561.method_43471((String)this.sectionName.method_42093("compass.section"));
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public class_2960 getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(class_2960 sectionName) {
        this.sectionName = sectionName;
    }

    public IGuiTexture getButtonTexture() {
        return this.buttonTexture;
    }

    public void setButtonTexture(IGuiTexture buttonTexture) {
        this.buttonTexture = buttonTexture;
    }

    public IGuiTexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTexture(IGuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
    }
}

