/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.CompassSection;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CompassNode {
    protected final JsonObject config;
    protected class_2960 nodeName;
    protected CompassSection section;
    protected Position position;
    protected int size;
    @Nullable
    protected IGuiTexture background;
    @Nullable
    protected IGuiTexture hoverBackground;
    protected IGuiTexture buttonTexture;
    protected Set<CompassNode> preNodes = new HashSet<CompassNode>();
    protected Set<CompassNode> childNodes = new HashSet<CompassNode>();
    protected List<class_1792> items;

    public CompassNode(class_2960 nodeName, JsonObject config) {
        this.config = config;
        this.nodeName = nodeName;
        this.background = config.has("background") ? SimpleIGuiTextureJsonUtils.fromJson(config.get("background").getAsJsonObject()) : null;
        this.hoverBackground = config.has("hover_background") ? SimpleIGuiTextureJsonUtils.fromJson(config.get("hover_background").getAsJsonObject()) : null;
        this.buttonTexture = SimpleIGuiTextureJsonUtils.fromJson(config.get("button_texture").getAsJsonObject());
        JsonArray position = config.get("position").getAsJsonArray();
        this.position = new Position(position.get(0).getAsInt(), position.get(1).getAsInt());
        this.size = class_3518.method_15282((JsonObject)config, (String)"size", (int)24);
    }

    public JsonObject updateJson() {
        JsonArray pos = new JsonArray();
        pos.add((Number)this.position.x);
        pos.add((Number)this.position.y);
        this.config.add("position", (JsonElement)pos);
        this.config.addProperty("section", this.section.sectionName.toString());
        if (this.size != 24) {
            this.config.addProperty("size", (Number)this.size);
        } else {
            this.config.remove("size");
        }
        if (this.background != null) {
            this.config.add("background", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.background));
        } else {
            this.config.remove("background");
        }
        if (this.hoverBackground != null) {
            this.config.add("hover_background", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.hoverBackground));
        } else {
            this.config.remove("hover_background");
        }
        this.config.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson(this.buttonTexture));
        if (this.preNodes.isEmpty()) {
            this.config.remove("pre_nodes");
        } else {
            JsonArray pre = new JsonArray();
            for (CompassNode node : this.preNodes) {
                pre.add(node.getNodeName().toString());
            }
            this.config.add("pre_nodes", (JsonElement)pre);
        }
        return this.config;
    }

    public void setSection(CompassSection section) {
        this.section = section;
        this.section.addNode(this);
    }

    public void initRelation() {
        if (this.config.has("pre_nodes")) {
            JsonArray pre = this.config.get("pre_nodes").getAsJsonArray();
            for (JsonElement element : pre) {
                class_2960 nodeName = new class_2960(element.getAsString());
                CompassNode node = CompassManager.INSTANCE.getNodeByName(nodeName);
                if (node == null) continue;
                this.preNodes.add(node);
                node.childNodes.add(this);
            }
        }
    }

    public final String toString() {
        return this.nodeName.toString();
    }

    public class_2960 getPage() {
        return new class_2960(class_3518.method_15253((JsonObject)this.config, (String)"page", (String)"ldlib:missing"));
    }

    public List<class_1792> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<class_1792>();
            JsonArray items = class_3518.method_15292((JsonObject)this.config, (String)"items", (JsonArray)new JsonArray());
            for (JsonElement element : items) {
                String data = element.getAsString();
                if (class_2960.method_20207((String)data)) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(data));
                    if (item == class_1802.field_8162) continue;
                    this.items.add(item);
                    continue;
                }
                if (!data.startsWith("#") || !class_2960.method_20207((String)data.substring(1))) continue;
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(data.substring(1)));
                Optional tagCollection = class_7923.field_41178.method_40266(tag);
                tagCollection.ifPresent(named -> named.forEach(holder -> this.items.add((class_1792)holder.comp_349())));
            }
        }
        return this.items;
    }

    public class_2561 getChatComponent() {
        return class_2561.method_43471((String)this.nodeName.method_42093("compass.node"));
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public class_2960 getNodeName() {
        return this.nodeName;
    }

    public CompassNode setNodeName(class_2960 nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public CompassSection getSection() {
        return this.section;
    }

    public Position getPosition() {
        return this.position;
    }

    public CompassNode setPosition(Position position) {
        this.position = position;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public IGuiTexture getBackground() {
        return this.background;
    }

    @Nullable
    public IGuiTexture getHoverBackground() {
        return this.hoverBackground;
    }

    public CompassNode setBackground(@Nullable IGuiTexture background) {
        this.background = background;
        return this;
    }

    public CompassNode setHoverBackground(@Nullable IGuiTexture hoverBackground) {
        this.hoverBackground = hoverBackground;
        return this;
    }

    public IGuiTexture getButtonTexture() {
        return this.buttonTexture;
    }

    public CompassNode setButtonTexture(IGuiTexture buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public Set<CompassNode> getPreNodes() {
        return this.preNodes;
    }

    public Set<CompassNode> getChildNodes() {
        return this.childNodes;
    }
}

