/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.compass.CompassSection;
import com.lowdragmc.lowdraglib.gui.compass.CompassSelectorWidget;
import com.lowdragmc.lowdraglib.gui.compass.CompassView;
import com.lowdragmc.lowdraglib.gui.compass.ICompassUIConfig;
import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.BlankComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.CompassComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.HeaderComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.ImageComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.IngredientComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.RecipeComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.SceneComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.TextBoxComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.InformationAction;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.SceneAction;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_437;
import net.minecraft.class_4431;
import net.minecraft.class_746;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Environment(value=EnvType.CLIENT)
public final class CompassManager
implements class_4013 {
    public static final CompassManager INSTANCE = new CompassManager();
    public static final int MAX_HOBER_TICK = 20;
    private int cHoverTick = 0;
    private long startedTick = Long.MAX_VALUE;
    private class_1799 lastStack = class_1799.field_8037;
    public boolean devMode = Platform.isDevEnv();
    private final Map<String, Supplier<ILayoutComponent>> COMPONENTS = new HashMap<String, Supplier<ILayoutComponent>>();
    private final Map<String, Function<Element, Action>> ACTION_CREATORS = new HashMap<String, Function<Element, Action>>();
    private final Map<String, ICompassUIConfig> CONFIGS = new HashMap<String, ICompassUIConfig>();
    private final Map<class_1792, Set<class_2960>> itemLookup = new HashMap<class_1792, Set<class_2960>>();
    public final Map<String, Map<class_2960, CompassSection>> sections = new HashMap<String, Map<class_2960, CompassSection>>();
    public final Map<String, Map<class_2960, CompassNode>> nodes = new HashMap<String, Map<class_2960, CompassNode>>();
    public final Map<class_2960, Map<String, Document>> nodePages = new HashMap<class_2960, Map<String, Document>>();

    private CompassManager() {
    }

    public void registerAction(String name, Function<Element, Action> creator) {
        this.ACTION_CREATORS.put(name, creator);
    }

    public void registerComponent(String name, Supplier<ILayoutComponent> clazz) {
        this.COMPONENTS.put(name, clazz);
    }

    public void registerUIConfig(String modID, ICompassUIConfig config) {
        this.CONFIGS.put(modID, config);
    }

    public void registerItemLookup(class_1792 item, class_2960 nodeName) {
        this.itemLookup.computeIfAbsent(item, k -> new HashSet()).add(nodeName);
    }

    @Nullable
    public ILayoutComponent createComponent(String name, Element element) {
        Supplier<ILayoutComponent> creator = this.COMPONENTS.get(name);
        return creator == null ? null : creator.get().fromXml(element);
    }

    @Nullable
    public Action createAction(Element element) {
        Function<Element, Action> creator = this.ACTION_CREATORS.get(element.getTagName());
        return creator == null ? null : creator.apply(element);
    }

    public ICompassUIConfig getUIConfig(String modID) {
        return this.CONFIGS.getOrDefault(modID, ICompassUIConfig.getDefault());
    }

    public void init() {
        this.registerComponent("text", TextBoxComponent::new);
        this.registerComponent("image", ImageComponent::new);
        for (HeaderComponent.Header header : HeaderComponent.Header.values()) {
            this.registerComponent(header.name(), HeaderComponent::new);
            this.registerComponent(header.name(), HeaderComponent::new);
            this.registerComponent(header.name(), HeaderComponent::new);
        }
        this.registerComponent("br", BlankComponent::new);
        this.registerComponent("recipe", RecipeComponent::new);
        this.registerComponent("scene", SceneComponent::new);
        this.registerComponent("ingredient", IngredientComponent::new);
        this.registerComponent("compass", CompassComponent::new);
        this.registerAction("scene", SceneAction::new);
        this.registerAction("information", InformationAction::new);
    }

    public void method_14491(@Nonnull class_3300 resourceManager) {
        String path;
        InputStreamReader reader;
        class_3298 resource;
        class_2960 key;
        this.sections.clear();
        this.nodes.clear();
        this.nodePages.clear();
        for (Map.Entry entry : resourceManager.method_14488("compass/sections", rl -> rl.method_12832().endsWith(".json")).entrySet()) {
            key = (class_2960)entry.getKey();
            resource = (class_3298)entry.getValue();
            try {
                reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);
                try {
                    path = key.method_12832().replace("compass/sections/", "");
                    path = path.substring(0, path.length() - 5);
                    CompassSection section = new CompassSection(new class_2960(key.method_12836(), path), JsonParser.parseReader((Reader)reader).getAsJsonObject());
                    this.sections.computeIfAbsent(key.method_12836(), k -> new HashMap()).put(section.sectionName, section);
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                LDLib.LOGGER.error("loading compass section {} failed", entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry entry : resourceManager.method_14488("compass/nodes", rl -> rl.method_12832().endsWith(".json")).entrySet()) {
            key = (class_2960)entry.getKey();
            resource = (class_3298)entry.getValue();
            try {
                reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);
                try {
                    path = key.method_12832().replace("compass/nodes/", "");
                    path = path.substring(0, path.length() - 5);
                    CompassNode node = new CompassNode(new class_2960(key.method_12836(), path), JsonParser.parseReader((Reader)reader).getAsJsonObject());
                    this.nodes.computeIfAbsent(key.method_12836(), k -> new HashMap()).put(node.nodeName, node);
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                LDLib.LOGGER.error("loading compass node {} failed", entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.nodes.entrySet()) {
            Iterator iterator = ((Map)entry.getValue()).entrySet().iterator();
            while (iterator.hasNext()) {
                CompassNode node = (CompassNode)iterator.next().getValue();
                class_2960 sectionName = new class_2960(class_4431.method_21547((String)"section", (JsonObject)node.getConfig(), (String)"default"));
                CompassSection section = (CompassSection)this.sections.getOrDefault(entry.getKey(), Collections.emptyMap()).get(sectionName);
                if (section != null) {
                    node.setSection(section);
                    node.getItems().forEach(item -> this.itemLookup.computeIfAbsent((class_1792)item, k -> new HashSet()).add(node.nodeName));
                    continue;
                }
                LDLib.LOGGER.error("node {}'s section {} not found", (Object)node.getNodeName(), (Object)sectionName);
                iterator.remove();
            }
        }
        for (Map map : this.nodes.values()) {
            map.values().forEach(CompassNode::initRelation);
        }
    }

    public static void onComponentClick(String link, ClickData cd) {
        if (class_2960.method_20207((String)link)) {
            INSTANCE.openCompass(new class_2960(link));
        }
    }

    public void onCPressed(class_1799 itemStack) {
        long tick = class_310.method_1551().field_1687.method_8510();
        if (!class_1799.method_31577((class_1799)this.lastStack, (class_1799)itemStack)) {
            this.lastStack = itemStack;
            this.cHoverTick = 0;
            this.startedTick = tick;
        } else {
            this.cHoverTick = (int)(tick - this.startedTick);
        }
        if (this.cHoverTick < 0 || this.cHoverTick > 20) {
            this.lastStack = class_1799.field_8037;
            this.cHoverTick = 0;
            this.startedTick = tick;
        }
        if (this.cHoverTick == 20) {
            this.openCompass(this.getNodesByItem(itemStack.method_7909()).toArray(new CompassNode[0]));
        }
    }

    public float getCHoverProgress() {
        return (float)this.cHoverTick * 1.0f / 20.0f;
    }

    public void clearCPressed() {
        this.cHoverTick = 0;
        this.startedTick = Long.MAX_VALUE;
        this.lastStack = class_1799.field_8037;
    }

    public void openCompass(class_2960 nodeLocation) {
        CompassNode node = this.nodes.getOrDefault(nodeLocation.method_12836(), Collections.emptyMap()).getOrDefault(nodeLocation, null);
        if (node != null) {
            this.openCompass(node);
        }
    }

    public void openCompass(CompassNode ... compassNodes) {
        ModularUI uiTemplate;
        IUIHolder holder = new IUIHolder(){

            @Override
            public ModularUI createUI(class_1657 entityPlayer) {
                return null;
            }

            @Override
            public boolean isInvalid() {
                return true;
            }

            @Override
            public boolean isRemote() {
                return true;
            }

            @Override
            public void markAsDirty() {
            }
        };
        class_310 minecraft = class_310.method_1551();
        class_746 entityPlayer = minecraft.field_1724;
        if (compassNodes.length == 1) {
            uiTemplate = new ModularUI(holder, (class_1657)entityPlayer).widget(new CompassView(compassNodes[0]));
        } else if (compassNodes.length > 1) {
            uiTemplate = new ModularUI(210, 100, holder, (class_1657)entityPlayer).widget(new CompassSelectorWidget(Arrays.asList(compassNodes)));
        } else {
            return;
        }
        uiTemplate.initWidgets();
        ModularUIGuiContainer ModularUIGuiContainer2 = new ModularUIGuiContainer(uiTemplate, entityPlayer.field_7512.field_7763);
        minecraft.method_1507((class_437)ModularUIGuiContainer2);
        entityPlayer.field_7512 = ModularUIGuiContainer2.method_17577();
    }

    public boolean hasCompass(class_1792 item) {
        return !this.getNodesByItem(item).isEmpty();
    }

    public List<CompassNode> getNodesByItem(class_1792 item) {
        return this.itemLookup.getOrDefault(item, Collections.emptySet()).stream().map(nodeName -> (CompassNode)this.nodes.getOrDefault(nodeName.method_12836(), Collections.emptyMap()).get(nodeName)).toList();
    }

    @Nullable
    public CompassNode getNodeByName(class_2960 nodeName) {
        return (CompassNode)this.nodes.getOrDefault(nodeName.method_12836(), Collections.emptyMap()).get(nodeName);
    }

    @Nullable
    public CompassSection getSectionByName(class_2960 sectionName) {
        return (CompassSection)this.sections.getOrDefault(sectionName.method_12836(), Collections.emptyMap()).get(sectionName);
    }
}

