/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.animation;

import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.lowdragmc.lowdraglib.utils.interpolate.IEase;
import com.lowdragmc.lowdraglib.utils.interpolate.Interpolator;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

public class Animation {
    protected Widget widget;
    protected Interpolator interpolator;
    protected float time = 0.0f;
    protected boolean isFinish;
    protected long startTick = -1L;
    protected boolean init = false;
    protected long duration = 250L;
    protected long delay = 0L;
    protected IEase ease = Eases.EaseLinear;
    protected FloatConsumer onUpdate;
    protected Runnable onFinish;
    @Nullable
    protected Size size;
    @Nullable
    protected Position position;
    protected Size initialSize;
    protected Position initialPosition;

    public Animation setWidget(Widget widget) {
        this.widget = widget;
        return this;
    }

    public Widget getWidget() {
        return this.widget;
    }

    protected void onInterpolatorUpdate(Number number) {
        this.time = number.floatValue();
    }

    protected float getTime() {
        return this.time;
    }

    protected void onInterpolatorFinish(Number number) {
        this.widget.setActive(true);
        this.interpolator = null;
        this.isFinish = true;
        if (this.onFinish != null) {
            this.onFinish.run();
        }
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public Animation appendOnFinish(Runnable onFinish) {
        if (this.onFinish != null) {
            Runnable last = this.onFinish;
            this.onFinish = () -> {
                last.run();
                onFinish.run();
            };
        } else {
            this.onFinish = onFinish;
        }
        return this;
    }

    public Runnable getOnFinish() {
        return this.onFinish;
    }

    protected float getTick() {
        if (!this.init) {
            this.init();
        }
        return System.currentTimeMillis() - this.startTick;
    }

    protected void init() {
        this.init = true;
        this.interpolator = new Interpolator(0.0f, 1.0f, this.duration, this.ease, this::onInterpolatorUpdate, this::onInterpolatorFinish);
        this.startTick = System.currentTimeMillis();
        this.widget.setActive(false);
        this.initialSize = this.widget.getSize();
        this.initialPosition = this.widget.getSelfPosition();
    }

    protected void updateWidget(float t) {
        if (this.onUpdate != null) {
            this.onUpdate.accept(t);
        }
        if (this.size != null) {
            this.widget.setSize(new Size((int)((float)this.size.width * t + (float)this.initialSize.width * (1.0f - t)), (int)((float)this.size.height * t + (float)this.initialSize.height * (1.0f - t))));
        }
        if (this.position != null) {
            this.widget.setSelfPosition(new Position((int)((float)this.position.x * t + (float)this.initialPosition.x * (1.0f - t)), (int)((float)this.position.y * t + (float)this.initialPosition.y * (1.0f - t))));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float tickTime = this.getTick();
        if (tickTime >= (float)this.delay && this.interpolator != null) {
            this.interpolator.update(tickTime);
            this.updateWidget(this.getTime());
        }
        this.widget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float tickTime = this.getTick();
        if (tickTime >= (float)this.delay && this.interpolator != null) {
            this.interpolator.update(tickTime);
        }
        this.widget.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    public Animation duration(long duration) {
        this.duration = duration;
        return this;
    }

    public Animation delay(long delay) {
        this.delay = delay;
        return this;
    }

    public Animation ease(IEase ease) {
        this.ease = ease;
        return this;
    }

    public Animation onUpdate(FloatConsumer onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public Animation onFinish(Runnable onFinish) {
        this.onFinish = onFinish;
        return this;
    }

    public Animation size(@Nullable Size size) {
        this.size = size;
        return this;
    }

    public Animation position(@Nullable Position position) {
        this.position = position;
        return this;
    }
}

