/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.emi;

import com.lowdragmc.lowdraglib.emi.ModularSlotWidget;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ModularWrapperWidget
extends dev.emi.emi.api.widget.Widget
implements class_4069 {
    @Nullable
    private class_364 focused;
    private boolean isDragging;
    public final ModularWrapper<?> modular;
    public final List<dev.emi.emi.api.widget.Widget> slots;
    private int lastX;
    private int lastY;

    public ModularWrapperWidget(ModularWrapper<?> modular, List<dev.emi.emi.api.widget.Widget> slots) {
        this.modular = modular;
        this.slots = slots;
    }

    public Bounds getBounds() {
        return new Bounds(0, 0, ((Widget)this.modular.getWidget()).getSize().width, ((Widget)this.modular.getWidget()).getSize().height);
    }

    public void method_25394(@Nonnull class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.lastX = pMouseX;
        this.lastY = pMouseY;
        this.modular.draw(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public List<class_5684> getTooltip(int mouseX, int mouseY) {
        if (this.modular.tooltipTexts != null && !this.modular.tooltipTexts.isEmpty()) {
            List<class_5684> tooltips = this.modular.tooltipTexts.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
            if (this.modular.tooltipComponent != null) {
                tooltips.add(DrawerHelper.getClientTooltipComponent(this.modular.tooltipComponent));
            }
            return tooltips;
        }
        return super.getTooltip(mouseX, mouseY);
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        return this.modular.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.modular.method_25402(mouseX + this.modular.getLeft(), mouseY + this.modular.getTop(), button)) {
            return true;
        }
        for (dev.emi.emi.api.widget.Widget slot : this.slots) {
            if (!slot.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        return this.modular.method_25406(pMouseX, pMouseY, pButton);
    }

    public void method_16014(double pMouseX, double pMouseY) {
        this.modular.method_16014(pMouseX, pMouseY);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.modular.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        return this.modular.method_25401(pMouseX, pMouseY, pDelta);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        this.modular.focused = false;
        if (this.modular.modularUI.mainGroup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        for (dev.emi.emi.api.widget.Widget slot : this.slots) {
            ModularSlotWidget slotWidget;
            if (!(slot instanceof ModularSlotWidget) || !(slotWidget = (ModularSlotWidget)slot).getBounds().contains(this.lastX, this.lastY)) continue;
            if (slotWidget.slotInteraction(bind -> bind.matchesKey(pKeyCode, pScanCode))) {
                return true;
            }
            Object object = slotWidget.getSlot().getXEIIngredientOverMouse(this.lastX + this.modular.getLeft(), this.lastY + this.modular.getTop());
            if (!(object instanceof EmiIngredient)) continue;
            EmiIngredient ingredient = (EmiIngredient)object;
            return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction(ingredient, slotWidget.getRecipe(), true), bind -> bind.matchesKey(pKeyCode, pScanCode));
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        return this.modular.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        return this.modular.method_25400(pCodePoint, pModifiers);
    }

    public boolean method_25397() {
        return this.isDragging;
    }

    public void method_25398(boolean isDragging) {
        this.isDragging = isDragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 focused) {
        this.focused = focused;
    }
}

