/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.emi;

import com.lowdragmc.lowdraglib.emi.ModularSlotWidget;
import com.lowdragmc.lowdraglib.emi.ModularWrapperWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class ModularEmiRecipe<T extends Widget>
implements EmiRecipe {
    public static final List<ModularWrapper<?>> CACHE_OPENED = new ArrayList();
    protected Supplier<T> widget;
    protected List<EmiIngredient> inputs;
    protected List<EmiStack> outputs;
    protected List<EmiIngredient> catalysts;
    protected int width;
    protected int height;
    public static ModularWrapper<?> TEMP_CACHE = null;

    public ModularEmiRecipe(Supplier<T> widget) {
        this.widget = widget;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.catalysts = new ArrayList<EmiIngredient>();
        Widget widgetT = (Widget)widget.get();
        this.width = widgetT.getSize().width;
        this.height = widgetT.getSize().height;
        List<Widget> flatVisibleWidgetCollection = this.getFlatWidgetCollection(widgetT);
        for (Widget w : flatVisibleWidgetCollection) {
            if (!(w instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)w);
            IngredientIO io = slot.getIngredientIO();
            for (Object ingredient : slot.getXEIIngredients()) {
                if (!(ingredient instanceof EmiIngredient)) continue;
                EmiIngredient emiIngredient = (EmiIngredient)ingredient;
                if (io == IngredientIO.INPUT || io == IngredientIO.BOTH) {
                    this.inputs.add(emiIngredient);
                }
                if (io == IngredientIO.OUTPUT || io == IngredientIO.BOTH) {
                    this.outputs.addAll(emiIngredient.getEmiStacks());
                }
                if (io != IngredientIO.CATALYST) continue;
                this.catalysts.add(emiIngredient);
            }
        }
    }

    public List<Widget> getFlatWidgetCollection(T widgetIn) {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        if (widgetIn instanceof WidgetGroup) {
            WidgetGroup group = (WidgetGroup)widgetIn;
            for (Widget widget : group.widgets) {
                widgetList.add(widget);
                if (!(widget instanceof WidgetGroup)) continue;
                widgetList.addAll(((WidgetGroup)widget).getContainedWidgets(true));
            }
        } else {
            widgetList.add((Widget)widgetIn);
        }
        return widgetList;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWidgets(WidgetHolder widgets) {
        Widget widget = (Widget)this.widget.get();
        ModularWrapper<Widget> modular = new ModularWrapper<Widget>(widget);
        modular.setRecipeWidget(0, 0);
        List<ModularWrapper<?>> list = CACHE_OPENED;
        synchronized (list) {
            CACHE_OPENED.add(modular);
        }
        ArrayList<dev.emi.emi.api.widget.Widget> slots = new ArrayList<dev.emi.emi.api.widget.Widget>();
        for (Widget w : this.getFlatWidgetCollection(widget)) {
            IRecipeIngredientSlot slot;
            IngredientIO io;
            if (!(w instanceof IRecipeIngredientSlot) || (io = (slot = (IRecipeIngredientSlot)((Object)w)).getIngredientIO()) != IngredientIO.BOTH && io != IngredientIO.INPUT && io != IngredientIO.OUTPUT && io != IngredientIO.CATALYST) continue;
            slots.add(new ModularSlotWidget(slot, new Bounds(w.getPosition().x, w.getPosition().y, w.getSize().width, w.getSize().height), this));
        }
        widgets.add((dev.emi.emi.api.widget.Widget)new ModularWrapperWidget(modular, slots));
        slots.forEach(arg_0 -> ((WidgetHolder)widgets).add(arg_0));
    }

    public void addTempWidgets(WidgetHolder widgets) {
        if (TEMP_CACHE != null) {
            ModularEmiRecipe.TEMP_CACHE.modularUI.triggerCloseListeners();
            TEMP_CACHE = null;
        }
        Widget widget = (Widget)this.widget.get();
        ModularWrapper<Widget> modular = new ModularWrapper<Widget>(widget);
        modular.setRecipeWidget(0, 0);
        widgets.add((dev.emi.emi.api.widget.Widget)new ModularWrapperWidget(modular, new ArrayList<dev.emi.emi.api.widget.Widget>()));
        TEMP_CACHE = modular;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }
}

