/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class RenderUtils {
    private static final Stack<int[]> scissorFrameStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void useScissor(int x, int y, int width, int height, Runnable codeBlock) {
        RenderUtils.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtils.popScissorFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void useScissor(@Nonnull class_4587 poseStack, int x, int y, int width, int height, Runnable codeBlock) {
        Matrix4f pose = poseStack.method_23760().method_23761();
        Vector4f pos = pose.transform(new Vector4f((float)x, (float)y, 0.0f, 1.0f));
        Vector4f size = pose.transform(new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f));
        x = (int)pos.x();
        y = (int)pos.y();
        width = (int)(size.x() - (float)x);
        height = (int)(size.y() - (float)y);
        RenderUtils.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtils.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            class_1041 window = class_310.method_1551().method_22683();
            return new int[]{0, 0, window.method_4489(), window.method_4506()};
        }
        return currentTopFrame;
    }

    private static void pushScissorFrame(int x, int y, int width, int height) {
        int[] parentScissor = RenderUtils.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = Math.max(x, parentX);
            int newY = Math.max(y, parentY);
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = Math.min(maxWidth, newWidth);
                newHeight = Math.min(maxHeight, newHeight);
                RenderUtils.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    private static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = RenderUtils.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        RenderUtils.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        class_1041 window = class_310.method_1551().method_22683();
        double s = window.method_4495();
        int translatedY = window.method_4502() - y - h;
        GL11.glScissor((int)((int)((double)x * s)), (int)((int)((double)translatedY * s)), (int)((int)((double)w * s)), (int)((int)((double)h * s)));
    }

    public static void useStencil(Runnable mask, Runnable renderInMask, boolean shouldRenderMask) {
        GL11.glStencilMask((int)255);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        if (!shouldRenderMask) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GL11.glDepthMask((boolean)false);
        }
        mask.run();
        if (!shouldRenderMask) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        renderInMask.run();
        GL11.glDisable((int)2960);
    }

    public static void renderBlockOverLay(@Nonnull class_4587 poseStack, class_2338 pos, float r, float g, float b, float scale) {
        if (pos == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        poseStack.method_22903();
        poseStack.method_22904((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        poseStack.method_22905(scale, scale, scale);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtils.renderCubeFace(poseStack, buffer, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, r, g, b, 1.0f);
        tessellator.method_1350();
        poseStack.method_22909();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderCubeFace(class_4587 poseStack, class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float r, float g, float b, float a) {
        Matrix4f mat = poseStack.method_23760().method_23761();
        buffer.method_22918(mat, minX, minY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, minY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, maxY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, maxY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, minY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, maxY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, maxY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, minY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, minY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, minY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, minY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, minY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, maxY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, maxY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, maxY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, maxY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, minY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, maxY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, maxY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, minY, minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, minY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, minY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, maxX, maxY, maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(mat, minX, maxY, maxZ).method_22915(r, g, b, a).method_1344();
    }

    public static void moveToFace(class_4587 poseStack, double x, double y, double z, class_2350 face) {
        poseStack.method_22904(x + 0.5 + (double)face.method_10148() * 0.5, y + 0.5 + (double)face.method_10164() * 0.5, z + 0.5 + (double)face.method_10165() * 0.5);
    }

    public static void rotateToFace(class_4587 poseStack, class_2350 face, @Nullable class_2350 spin) {
        float angle = spin == class_2350.field_11034 ? 1.5707964f : (spin == class_2350.field_11035 ? (float)Math.PI : (spin == class_2350.field_11039 ? -1.5707964f : 0.0f));
        switch (face) {
            case field_11036: {
                poseStack.method_22905(1.0f, -1.0f, 1.0f);
                poseStack.method_22907(new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
                poseStack.method_22907(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case field_11033: {
                poseStack.method_22905(1.0f, -1.0f, 1.0f);
                poseStack.method_22907(new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
                poseStack.method_22907(new Quaternionf().rotateAxis(spin == class_2350.field_11034 ? 1.5707964f : (spin == class_2350.field_11043 ? (float)Math.PI : (spin == class_2350.field_11039 ? -1.5707964f : 0.0f)), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case field_11034: {
                poseStack.method_22905(-1.0f, -1.0f, -1.0f);
                poseStack.method_22907(new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
                poseStack.method_22907(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case field_11039: {
                poseStack.method_22905(-1.0f, -1.0f, -1.0f);
                poseStack.method_22907(new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
                poseStack.method_22907(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case field_11043: {
                poseStack.method_22905(-1.0f, -1.0f, -1.0f);
                poseStack.method_22907(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
            case field_11035: {
                poseStack.method_22905(-1.0f, -1.0f, -1.0f);
                poseStack.method_22907(new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
                poseStack.method_22907(new Quaternionf().rotateAxis(angle, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                break;
            }
        }
    }
}

