/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader.management;

import com.lowdragmc.lowdraglib.client.shader.management.Shader;
import com.lowdragmc.lowdraglib.client.shader.uniform.IUniformCallback;
import com.lowdragmc.lowdraglib.client.shader.uniform.UniformCache;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL20;

@Environment(value=EnvType.CLIENT)
public class ShaderProgram {
    public final int programId = GL20.glCreateProgram();
    public final Set<Shader> shaders = new ReferenceOpenHashSet();
    public final UniformCache uniformCache;
    public final LinkedHashMap<String, Integer> samplers = new LinkedHashMap();
    private boolean unLinked;
    private IUniformCallback globalUniform;

    public ShaderProgram() {
        if (this.programId == 0) {
            throw new IllegalStateException("Unable to create ShaderProgram.");
        }
        this.uniformCache = new UniformCache(this.programId);
    }

    public ShaderProgram attach(Shader loader) {
        if (loader == null) {
            return this;
        }
        if (this.shaders.contains(loader)) {
            throw new IllegalStateException(String.format("Unable to attach Shader as it is already attached:\n%s", loader.source));
        }
        this.shaders.add(loader);
        loader.attachShader(this);
        this.unLinked = true;
        return this;
    }

    public void use(IUniformCallback callback) {
        this.use();
        callback.apply(this.uniformCache);
    }

    public void setGlobalUniform(IUniformCallback globalUniform) {
        this.globalUniform = globalUniform;
    }

    public void bindTexture(String samplerName, int textureId) {
        if (textureId > 0) {
            this.samplers.put(samplerName, textureId);
        } else {
            this.samplers.remove(samplerName);
        }
    }

    public void bindTexture(String samplerName, class_2960 resourceLocation) {
        if (resourceLocation == null) {
            this.bindTexture(samplerName, 0);
            return;
        }
        class_1044 abstracttexture = class_310.method_1551().method_1531().method_4619(resourceLocation);
        int textureId = abstracttexture.method_4624();
        this.bindTexture(samplerName, textureId);
    }

    public void use() {
        if (this.unLinked) {
            this.uniformCache.invalidate();
            GL20.glLinkProgram((int)this.programId);
            if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
                throw new RuntimeException(String.format("ShaderProgram validation has failed!\n%s", GL20.glGetProgramInfoLog((int)this.programId, (int)GL20.glGetProgrami((int)this.programId, (int)35716))));
            }
            this.unLinked = false;
        }
        GL20.glUseProgram((int)this.programId);
        if (!this.samplers.isEmpty()) {
            int i = 0;
            for (Map.Entry<String, Integer> entry : this.samplers.entrySet()) {
                RenderSystem.activeTexture((int)(33984 + i));
                RenderSystem.bindTexture((int)entry.getValue());
                this.uniformCache.glUniform1I(entry.getKey(), i);
                ++i;
            }
        }
        if (this.globalUniform != null) {
            this.globalUniform.apply(this.uniformCache);
        }
    }

    public void release() {
        if (!this.samplers.isEmpty()) {
            for (int i = 0; i < this.samplers.size(); ++i) {
                RenderSystem.activeTexture((int)(33984 + i));
                RenderSystem.bindTexture((int)0);
            }
        }
        GL20.glUseProgram((int)0);
    }

    public void delete() {
        if (this.programId != 0) {
            GL20.glDeleteProgram((int)this.programId);
        }
    }
}

