/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader.management;

import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.Shader;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.lowdragmc.lowdraglib.client.shader.uniform.IUniformCallback;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_6367;

@Environment(value=EnvType.CLIENT)
public class ShaderManager {
    private static final ShaderManager INSTANCE = new ShaderManager();
    private final Reference2ReferenceMap<Shader, ShaderProgram> programs = new Reference2ReferenceOpenHashMap();
    private static class_6367 TEMP_TARGET;
    private PositionedRect viewPort;

    public static ShaderManager getInstance() {
        return INSTANCE;
    }

    public static boolean allowedShader() {
        return true;
    }

    private ShaderManager() {
    }

    public static class_6367 getTempTarget() {
        if (TEMP_TARGET == null) {
            TEMP_TARGET = new class_6367(1024, 1024, false, class_310.field_1703);
            TEMP_TARGET.method_1232(9729);
            TEMP_TARGET.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return TEMP_TARGET;
    }

    public void reload() {
        this.programs.forEach((shader, shaderProgram) -> {
            shader.deleteShader();
            shaderProgram.delete();
        });
        this.programs.clear();
    }

    public void setViewPort(PositionedRect viewPort) {
        this.viewPort = viewPort;
    }

    public boolean hasViewPort() {
        return this.viewPort != null;
    }

    public void clearViewPort() {
        this.viewPort = null;
    }

    public class_276 renderFullImageInFramebuffer(class_276 fbo, Shader frag, IUniformCallback consumeCache, Consumer<ShaderProgram> programCreated) {
        if (fbo == null || frag == null || !ShaderManager.allowedShader() || frag.shaderType != Shader.ShaderType.FRAGMENT) {
            return fbo;
        }
        fbo.method_1235(true);
        ShaderProgram program = (ShaderProgram)this.programs.get((Object)frag);
        if (program == null) {
            program = new ShaderProgram();
            this.programs.put((Object)frag, (Object)program);
            program.attach(Shaders.IMAGE_V).attach(frag);
            if (programCreated != null) {
                programCreated.accept(program);
            }
        }
        program.use(cache -> {
            class_310 mc = class_310.method_1551();
            float time = mc.field_1724 != null ? ((float)mc.field_1724.field_6012 + mc.method_1488()) / 20.0f : (float)System.currentTimeMillis() / 1000.0f;
            cache.glUniform1F("iTime", time);
            cache.glUniform2F("iResolution", fbo.field_1482, fbo.field_1481);
            if (consumeCache != null) {
                consumeCache.apply(cache);
            }
        });
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22912(-1.0, 1.0, 0.0).method_1344();
        buffer.method_22912(-1.0, -1.0, 0.0).method_1344();
        buffer.method_22912(1.0, -1.0, 0.0).method_1344();
        buffer.method_22912(1.0, 1.0, 0.0).method_1344();
        buffer.method_1326();
        class_286.method_43437((class_287.class_7433)buffer.method_1326());
        program.release();
        if (this.viewPort != null) {
            RenderSystem.viewport((int)this.viewPort.position.x, (int)this.viewPort.position.y, (int)this.viewPort.size.width, (int)this.viewPort.size.height);
        }
        return fbo;
    }
}

