/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader.management;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

@Environment(value=EnvType.CLIENT)
public class Shader {
    public final ShaderType shaderType;
    public final String source;
    private int shaderId;
    private boolean isCompiled;

    public Shader(ShaderType type, String source) {
        this.shaderType = type;
        this.source = source;
        this.shaderId = GL20.glCreateShader((int)this.shaderType.shaderMode);
        if (this.shaderId == 0) {
            LDLib.LOGGER.error("GL Shader Allocation Fail!");
            throw new RuntimeException("GL Shader Allocation Fail!");
        }
    }

    public void attachShader(ShaderProgram program) {
        if (!this.isCompiled) {
            this.compileShader();
        }
        GlStateManager.glAttachShader((int)program.programId, (int)this.shaderId);
    }

    public void deleteShader() {
        if (this.shaderId == 0) {
            return;
        }
        GlStateManager.glDeleteShader((int)this.shaderId);
        this.shaderId = 0;
    }

    public Shader compileShader() {
        if (!this.isCompiled && this.shaderId != 0) {
            GL20.glShaderSource((int)this.shaderId, (CharSequence)this.source);
            GL20.glCompileShader((int)this.shaderId);
            if (GL20.glGetShaderi((int)this.shaderId, (int)35713) == 0) {
                int maxLength = GL20.glGetShaderi((int)this.shaderId, (int)35716);
                String error = String.format("Unable to compile %s shader object:\n%s", this.shaderType.name(), GL20.glGetShaderInfoLog((int)this.shaderId, (int)maxLength));
                LDLib.LOGGER.error(error);
            }
            this.isCompiled = true;
        }
        return this;
    }

    public static Shader loadShader(ShaderType type, String rawShader) {
        return new Shader(type, rawShader).compileShader();
    }

    public static Shader loadShader(ShaderType type, class_2960 resourceLocation) throws IOException {
        Optional resource = class_310.method_1551().method_1478().method_14486(resourceLocation);
        if (resource.isPresent()) {
            String line;
            class_3298 iresource = (class_3298)resource.get();
            InputStream stream = iresource.method_14482();
            StringBuilder sb = new StringBuilder();
            BufferedReader bin = new BufferedReader(new InputStreamReader(stream));
            while ((line = bin.readLine()) != null) {
                sb.append(line).append('\n');
            }
            stream.close();
            IOUtils.closeQuietly((InputStream)stream);
            return Shader.loadShader(type, sb.toString());
        }
        throw new IOException("find no resource " + resourceLocation);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Shader) {
            Shader shader = (Shader)obj;
            return Objects.equals(shader.source, this.source) && shader.shaderType == this.shaderType;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shaderType, this.source});
    }

    public static enum ShaderType {
        VERTEX("vertex", ".vsh", 35633),
        FRAGMENT("fragment", ".fsh", 35632);

        public final String shaderName;
        public final String shaderExtension;
        public final int shaderMode;

        private ShaderType(String shaderNameIn, String shaderExtensionIn, int shaderModeIn) {
            this.shaderName = shaderNameIn;
            this.shaderExtension = shaderExtensionIn;
            this.shaderMode = shaderModeIn;
        }
    }
}

