/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader;

import com.google.common.collect.ImmutableMap;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.shader.management.Shader;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

@Environment(value=EnvType.CLIENT)
public class Shaders {
    public static Shader IMAGE_F;
    public static Shader IMAGE_V;
    public static Shader GUI_IMAGE_V;
    public static Shader SCREEN_V;
    public static Shader ROUND_F;
    public static Shader PANEL_BG_F;
    public static Shader ROUND_BOX_F;
    public static Shader PROGRESS_ROUND_BOX_F;
    public static Shader FRAME_ROUND_BOX_F;
    public static Shader ROUND_LINE_F;
    public static Map<class_2960, Shader> CACHE;
    private static class_5944 particleShader;
    private static class_5944 blitShader;
    private static class_5944 hsbShader;
    private static class_5944 compassLineShader;
    private static final class_296 HSB_Alpha;
    public static final class_293 HSB_VERTEX_FORMAT;

    public static void init() {
        IMAGE_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "image"));
        IMAGE_V = Shaders.load(Shader.ShaderType.VERTEX, new class_2960("ldlib", "image"));
        GUI_IMAGE_V = Shaders.load(Shader.ShaderType.VERTEX, new class_2960("ldlib", "gui_image"));
        SCREEN_V = Shaders.load(Shader.ShaderType.VERTEX, new class_2960("ldlib", "screen"));
        ROUND_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "round"));
        PANEL_BG_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "panel_bg"));
        ROUND_BOX_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "round_box"));
        PROGRESS_ROUND_BOX_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "progress_round_box"));
        FRAME_ROUND_BOX_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "frame_round_box"));
        ROUND_LINE_F = Shaders.load(Shader.ShaderType.FRAGMENT, new class_2960("ldlib", "round_line"));
    }

    public static void reload() {
        for (Shader shader : CACHE.values()) {
            if (shader == null) continue;
            shader.deleteShader();
        }
        CACHE.clear();
        Shaders.init();
        DrawerHelper.init();
        ShaderTexture.clearCache();
    }

    public static Shader load(Shader.ShaderType shaderType, class_2960 resourceLocation) {
        return CACHE.computeIfAbsent(new class_2960(resourceLocation.method_12836(), "shaders/" + resourceLocation.method_12832() + shaderType.shaderExtension), key -> {
            try {
                Shader shader = Shader.loadShader(shaderType, key);
                LDLib.LOGGER.debug("load shader {} resource {} success", (Object)shaderType, (Object)resourceLocation);
                return shader;
            }
            catch (IOException e) {
                LDLib.LOGGER.error("load shader {} resource {} failed", (Object)shaderType, (Object)resourceLocation);
                LDLib.LOGGER.error("caused by ", (Throwable)e);
                return IMAGE_F;
            }
        });
    }

    public static List<Pair<class_5944, Consumer<class_5944>>> registerShaders(class_5912 resourceProvider) {
        try {
            return List.of(Pair.of((Object)new class_5944(resourceProvider, new class_2960("ldlib", "particle").toString(), class_290.field_1584), shaderInstance -> {
                particleShader = shaderInstance;
            }), Pair.of((Object)new class_5944(resourceProvider, new class_2960("ldlib", "fast_blit").toString(), class_290.field_1592), shaderInstance -> {
                blitShader = shaderInstance;
            }), Pair.of((Object)new class_5944(resourceProvider, new class_2960("ldlib", "hsb_block").toString(), HSB_VERTEX_FORMAT), shaderInstance -> {
                hsbShader = shaderInstance;
            }), Pair.of((Object)new class_5944(resourceProvider, new class_2960("ldlib", "compass_line").toString(), class_290.field_1575), shaderInstance -> {
                compassLineShader = shaderInstance;
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_5944 getParticleShader() {
        return particleShader;
    }

    public static class_5944 getBlitShader() {
        return blitShader;
    }

    public static class_5944 getHsbShader() {
        return hsbShader;
    }

    public static class_5944 getCompassLineShader() {
        return compassLineShader;
    }

    static {
        CACHE = new HashMap<class_2960, Shader>();
        HSB_Alpha = new class_296(0, class_296.class_297.field_1623, class_296.class_298.field_1632, 4);
        HSB_VERTEX_FORMAT = new class_293(ImmutableMap.builder().put((Object)"Position", (Object)class_290.field_1587).put((Object)"HSB_ALPHA", (Object)HSB_Alpha).build());
    }
}

