/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.scene.CameraEntity;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ISceneEntityRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.client.scene.fabric.WorldSceneRendererImpl;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderManager;
import com.lowdragmc.lowdraglib.client.utils.glu.Project;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public abstract class WorldSceneRenderer {
    protected static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final class_1937 world;
    public final Map<Collection<class_2338>, ISceneBlockRenderHook> renderedBlocksMap;
    protected class_291[] vertexBuffers;
    protected Set<class_2338> tileEntities;
    protected boolean useCache;
    protected boolean ortho;
    protected AtomicReference<CacheState> cacheState;
    protected int maxProgress;
    protected int progress;
    protected Thread thread;
    protected ParticleManager particleManager;
    protected class_4184 camera;
    protected CameraEntity cameraEntity;
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> afterRender;
    private Consumer<class_3965> onLookingAt;
    @Nullable
    private ISceneEntityRenderHook sceneEntityRenderHook;
    protected int clearColor;
    private class_3965 lastTraceResult;
    private Set<class_2338> blocked;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, 10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private float fov = 60.0f;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    public WorldSceneRenderer(class_1937 world) {
        this.world = world;
        this.renderedBlocksMap = new LinkedHashMap<Collection<class_2338>, ISceneBlockRenderHook>();
        this.cacheState = new AtomicReference<CacheState>(CacheState.UNUSED);
    }

    public WorldSceneRenderer setParticleManager(ParticleManager particleManager) {
        if (particleManager == null) {
            this.particleManager = null;
            this.camera = null;
            this.cameraEntity = null;
            return this;
        }
        this.particleManager = particleManager;
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)class_19372;
            dummyWorld.setParticleManager(particleManager);
        }
        this.particleManager.setLevel(this.world);
        this.camera = new class_4184();
        this.cameraEntity = new CameraEntity(this.world);
        this.setCameraLookAt(this.eyePos, this.lookAt, this.worldUp);
        return this;
    }

    public ParticleManager getParticleManager() {
        return this.particleManager;
    }

    public WorldSceneRenderer useCacheBuffer(boolean useCache) {
        if (this.useCache || !class_310.method_1551().method_18854()) {
            return this;
        }
        this.deleteCacheBuffer();
        if (useCache) {
            List layers = class_1921.method_22720();
            this.vertexBuffers = new class_291[layers.size()];
            for (int j = 0; j < layers.size(); ++j) {
                this.vertexBuffers[j] = new class_291(class_291.class_8555.field_44793);
            }
            if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            this.cacheState.set(CacheState.NEED);
        }
        this.useCache = useCache;
        return this;
    }

    public WorldSceneRenderer useOrtho(boolean ortho) {
        this.ortho = ortho;
        return this;
    }

    public WorldSceneRenderer deleteCacheBuffer() {
        if (this.useCache) {
            for (int i = 0; i < class_1921.method_22720().size(); ++i) {
                if (this.vertexBuffers[i] == null) continue;
                this.vertexBuffers[i].close();
            }
            if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
        this.tileEntities = null;
        this.useCache = false;
        this.cacheState.set(CacheState.UNUSED);
        return this;
    }

    public WorldSceneRenderer needCompileCache() {
        if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.cacheState.set(CacheState.NEED);
        return this;
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setAfterWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.afterRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<class_2338> blocks, ISceneBlockRenderHook renderHook) {
        if (blocks != null) {
            this.renderedBlocksMap.put(blocks, renderHook);
        }
        return this;
    }

    public WorldSceneRenderer setBlocked(Set<class_2338> blocked) {
        this.blocked = blocked;
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<class_3965> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public class_3965 getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void render(@Nonnull class_4587 poseStack, float x, float y, float width, float height, int mouseX, int mouseY) {
        Vector3f hitPos;
        class_3965 result;
        Matrix4f pose = poseStack.method_23760().method_23761();
        Vector4f pos = new Vector4f(x, y, 0.0f, 1.0f);
        pos = pose.transform(pos);
        Vector4f size = new Vector4f(x + width, y + height, 0.0f, 1.0f);
        size = pose.transform(size);
        x = pos.x();
        y = pos.y();
        width = size.x() - x;
        height = size.y() - y;
        PositionedRect positionedRect = this.getPositionedRect((int)x, (int)y, (int)width, (int)height);
        PositionedRect mouse = this.getPositionedRect(mouseX, mouseY, 0, 0);
        mouseX = mouse.position.x;
        mouseY = mouse.position.y;
        this.setupCamera(positionedRect);
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && mouseX > positionedRect.position.x && mouseX < positionedRect.position.x + positionedRect.size.width && mouseY > positionedRect.position.y && mouseY < positionedRect.position.y + positionedRect.size.height && (result = this.rayTrace(hitPos = this.unProject(mouseX, mouseY))) != null) {
            this.lastTraceResult = null;
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        this.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
        if (this.camera != null) {
            Vector3f xzProduct = new Vector3f(lookAt.x() - eyePos.x(), 0.0f, lookAt.z() - eyePos.z());
            double angleYaw = Math.toDegrees(xzProduct.angle((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
            Vector3f vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
            if ((double)xzProduct.angle((Vector3fc)vector3f) < 1.5707963267948966) {
                angleYaw = -angleYaw;
            }
            double anglePitch = Math.toDegrees(new Vector3f((Vector3fc)lookAt).sub((Vector3fc)new Vector3f((Vector3fc)eyePos)).angle((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f))) - 90.0;
            this.cameraEntity.method_5814(eyePos.x(), eyePos.y() - this.cameraEntity.method_5751(), eyePos.z());
            this.cameraEntity.field_6014 = this.cameraEntity.method_23317();
            this.cameraEntity.field_6036 = this.cameraEntity.method_23318();
            this.cameraEntity.field_5969 = this.cameraEntity.method_23321();
            this.cameraEntity.method_36456((float)angleYaw);
            this.cameraEntity.method_36457((float)anglePitch);
            this.cameraEntity.field_5982 = this.cameraEntity.method_36454();
            this.cameraEntity.field_6004 = this.cameraEntity.method_36455();
        }
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        Vector3f vecX = new Vector3f((float)Math.cos(rotationPitch), 0.0f, (float)Math.sin(rotationPitch));
        Vector3f vecY = new Vector3f(0.0f, (float)(Math.tan(rotationYaw) * (double)vecX.length()), 0.0f);
        Vector3f pos = new Vector3f((Vector3fc)vecX).add((Vector3fc)vecY).normalize().mul((float)radius);
        this.setCameraLookAt(pos.add(lookAt.x(), lookAt.y(), lookAt.z()), lookAt, this.worldUp);
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public void setCameraOrtho(float x, float y, float z) {
        this.minX = -x;
        this.maxX = x;
        this.minY = -y;
        this.maxY = y;
        this.minZ = -z;
        this.maxZ = z;
    }

    public void setCameraOrtho(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
    }

    protected PositionedRect getPositionedRect(int x, int y, int width, int height) {
        return new PositionedRect(new Position(x, y), new Size(width, height));
    }

    protected void setupCamera(PositionedRect positionedRect) {
        int x = positionedRect.getPosition().x;
        int y = positionedRect.getPosition().y;
        int width = positionedRect.getSize().width;
        int height = positionedRect.getSize().height;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
        RenderSystem.depthMask((boolean)true);
        this.clearView(x, y, width, height);
        RenderSystem.backupProjectionMatrix();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        if (this.ortho) {
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(this.minX, this.maxX, this.minY / aspectRatio, this.maxY / aspectRatio, this.minZ, this.maxZ), (class_8251)class_8251.method_49909((Vector3f)this.camera.method_19326().method_46409()));
        } else {
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setPerspective(this.fov * ((float)Math.PI / 180), aspectRatio, 0.1f, 10000.0f), (class_8251)class_8251.method_49909((Vector3f)this.camera.method_19326().method_46409()));
        }
        class_4587 posesStack = RenderSystem.getModelViewStack();
        posesStack.method_22903();
        posesStack.method_34426();
        Project.gluLookAt(posesStack, this.eyePos.x(), this.eyePos.y(), this.eyePos.z(), this.lookAt.x(), this.lookAt.y(), this.lookAt.z(), this.worldUp.x(), this.worldUp.y(), this.worldUp.z());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.activeTexture((int)33984);
        class_310 mc = class_310.method_1551();
        RenderSystem.enableCull();
        if (this.camera != null) {
            this.camera.method_19321((class_1922)this.world, (class_1297)this.cameraEntity, false, false, mc.method_1488());
        }
        ShaderManager.getInstance().setViewPort(positionedRect);
    }

    protected void clearView(int x, int y, int width, int height) {
        int i = (this.clearColor & 0xFF0000) >> 16;
        int j = (this.clearColor & 0xFF00) >> 8;
        int k = this.clearColor & 0xFF;
        RenderSystem.clearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)(this.clearColor >> 24) / 255.0f));
        RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
    }

    protected void resetCamera() {
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        class_310 minecraft = class_310.method_1551();
        RenderSystem.viewport((int)0, (int)0, (int)minecraft.method_22683().method_4489(), (int)minecraft.method_22683().method_4506());
        RenderSystem.restoreProjectionMatrix();
        class_4587 posesStack = RenderSystem.getModelViewStack();
        posesStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        ShaderManager.getInstance().clearViewPort();
    }

    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        class_310 mc = class_310.method_1551();
        float particleTicks = mc.method_1488();
        if (this.useCache) {
            this.renderCacheBuffer(mc, particleTicks);
        } else {
            class_776 blockrendererdispatcher = mc.method_1541();
            this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                for (class_1921 layer : class_1921.method_22720()) {
                    layer.method_23516();
                    Random random = new Random();
                    class_4587 poseStack = new class_4587();
                    if (layer == class_1921.method_23583()) {
                        if (hook != null) {
                            hook.apply(true, layer);
                        } else {
                            WorldSceneRenderer.setDefaultRenderLayerState(layer);
                        }
                        class_4597.class_4598 buffers = mc.method_22940().method_23000();
                        this.renderTESR((Collection<class_2338>)renderedBlocks, poseStack, buffers, (ISceneBlockRenderHook)hook, particleTicks);
                        if (hook != null) {
                            buffers.method_22993();
                        }
                    }
                    if (hook != null) {
                        hook.apply(false, layer);
                    } else {
                        WorldSceneRenderer.setDefaultRenderLayerState(layer);
                    }
                    class_287 buffer = class_289.method_1348().method_1349();
                    buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
                    this.renderBlocks(poseStack, blockrendererdispatcher, layer, new VertexConsumerWrapper((class_4588)buffer), (Collection<class_2338>)renderedBlocks, (ISceneBlockRenderHook)hook, particleTicks);
                    class_289.method_1348().method_1350();
                    layer.method_23518();
                }
            });
        }
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof TrackedDummyWorld) {
            TrackedDummyWorld level = (TrackedDummyWorld)class_19372;
            class_4587 poseStack = new class_4587();
            class_4597.class_4598 buffers = mc.method_22940().method_23000();
            this.renderEntities(level, poseStack, (class_4597)buffers, this.sceneEntityRenderHook, particleTicks);
            buffers.method_22993();
        }
        if (this.particleManager != null) {
            class_4587 poseStack = new class_4587();
            poseStack.method_34426();
            poseStack.method_22904(this.cameraEntity.method_23317(), this.cameraEntity.method_23318(), this.cameraEntity.method_23321());
            this.particleManager.render(poseStack, this.camera, particleTicks);
        }
        if (this.afterRender != null) {
            this.afterRender.accept(this);
        }
    }

    public boolean isCompiling() {
        return this.cacheState.get() == CacheState.COMPILING;
    }

    public double getCompileProgress() {
        if (this.maxProgress > 1000) {
            return (double)this.progress * 1.0 / (double)this.maxProgress;
        }
        return 0.0;
    }

    private void renderCacheBuffer(class_310 mc, float particleTicks) {
        List layers = class_1921.method_22720();
        if (this.cacheState.get() == CacheState.NEED) {
            this.progress = 0;
            this.maxProgress = this.renderedBlocksMap.keySet().stream().map(Collection::size).reduce(0, Integer::sum) * (layers.size() + 1);
            this.thread = new Thread(() -> {
                this.cacheState.set(CacheState.COMPILING);
                class_776 blockrendererdispatcher = mc.method_1541();
                class_778.method_20544();
                class_4587 matrixstack = new class_4587();
                for (int i = 0; i < layers.size(); ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    class_1921 layer = (class_1921)layers.get(i);
                    class_287 buffer = new class_287(layer.method_22722());
                    buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
                    this.renderedBlocksMap.forEach((renderedBlocks, hook) -> this.renderBlocks(matrixstack, blockrendererdispatcher, layer, new VertexConsumerWrapper((class_4588)buffer), (Collection<class_2338>)renderedBlocks, (ISceneBlockRenderHook)hook, 0.0f));
                    class_287.class_7433 builder = buffer.method_1326();
                    class_291 vertexBuffer = this.vertexBuffers[i];
                    Runnable toUpload = () -> {
                        if (!vertexBuffer.method_43444()) {
                            vertexBuffer.method_1353();
                            vertexBuffer.method_1352(builder);
                            class_291.method_1354();
                        }
                    };
                    CompletableFuture.runAsync(toUpload, runnable -> RenderSystem.recordRenderCall(runnable::run));
                }
                class_778.method_20545();
                HashSet<class_2338> poses = new HashSet<class_2338>();
                this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                    for (class_2338 pos : renderedBlocks) {
                        ++this.progress;
                        if (Thread.interrupted()) {
                            return;
                        }
                        class_2586 tile = this.world.method_8321(pos);
                        if (tile == null || mc.method_31975().method_3550(tile) == null) continue;
                        poses.add(pos);
                    }
                });
                if (Thread.interrupted()) {
                    return;
                }
                this.tileEntities = poses;
                this.cacheState.set(CacheState.COMPILED);
                this.thread = null;
                this.maxProgress = -1;
            });
            this.thread.start();
        } else {
            class_4587 matrixstack = new class_4587();
            for (int i = 0; i < layers.size(); ++i) {
                class_291 vertexbuffer = this.vertexBuffers[i];
                if (vertexbuffer.method_43444() || vertexbuffer.method_34435() == null) continue;
                class_1921 layer = (class_1921)layers.get(i);
                if (layer == class_1921.method_23583() && this.tileEntities != null) {
                    class_4597.class_4598 buffers = mc.method_22940().method_23000();
                    class_1937 class_19372 = this.world;
                    if (class_19372 instanceof TrackedDummyWorld) {
                        TrackedDummyWorld level = (TrackedDummyWorld)class_19372;
                        this.renderEntities(level, matrixstack, (class_4597)buffers, this.sceneEntityRenderHook, particleTicks);
                    }
                    this.renderTESR(this.tileEntities, matrixstack, mc.method_22940().method_23000(), null, particleTicks);
                    buffers.method_22993();
                }
                layer.method_23516();
                matrixstack.method_22903();
                class_5944 shaderInstance = RenderSystem.getShader();
                for (int j = 0; j < 12; ++j) {
                    int k = RenderSystem.getShaderTexture((int)j);
                    shaderInstance.method_34583("Sampler" + j, (Object)k);
                }
                if (shaderInstance.field_29470 != null) {
                    shaderInstance.field_29470.method_1250(RenderSystem.getModelViewMatrix());
                }
                if (shaderInstance.field_29471 != null) {
                    shaderInstance.field_29471.method_1250(RenderSystem.getProjectionMatrix());
                }
                if (shaderInstance.field_29474 != null) {
                    shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
                }
                if (shaderInstance.field_29477 != null) {
                    shaderInstance.field_29477.method_1251(RenderSystem.getShaderFogStart());
                }
                if (shaderInstance.field_29478 != null) {
                    shaderInstance.field_29478.method_1251(RenderSystem.getShaderFogEnd());
                }
                if (shaderInstance.field_29479 != null) {
                    shaderInstance.field_29479.method_1253(RenderSystem.getShaderFogColor());
                }
                if (shaderInstance.field_36373 != null) {
                    shaderInstance.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
                }
                if (shaderInstance.field_29472 != null) {
                    shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
                }
                if (shaderInstance.field_29481 != null) {
                    shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
                }
                RenderSystem.setupShaderLights((class_5944)shaderInstance);
                shaderInstance.method_34586();
                WorldSceneRenderer.setDefaultRenderLayerState(layer);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                vertexbuffer.method_1353();
                vertexbuffer.method_35665();
                matrixstack.method_22909();
                shaderInstance.method_34585();
                class_291.method_1354();
                layer.method_23518();
            }
        }
    }

    private void renderBlocks(class_4587 poseStack, class_776 blockrendererdispatcher, class_1921 layer, VertexConsumerWrapper wrapperBuffer, Collection<class_2338> renderedBlocks, @Nullable ISceneBlockRenderHook hook, float partialTicks) {
        for (class_2338 pos : renderedBlocks) {
            if (this.blocked != null && this.blocked.contains(pos)) continue;
            class_2680 state = this.world.method_8320(pos);
            class_3610 fluidState = state.method_26227();
            class_2248 block = state.method_26204();
            class_2586 te = this.world.method_8321(pos);
            if (hook != null) {
                hook.applyVertexConsumerWrapper(this.world, pos, state, wrapperBuffer, layer, partialTicks);
            }
            if (block == class_2246.field_10124) continue;
            if (state.method_26217() != class_2464.field_11455 && WorldSceneRenderer.canRenderInLayer(state, layer)) {
                poseStack.method_22903();
                poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                if (Platform.isForge()) {
                    WorldSceneRenderer.renderBlocksForge((class_776)blockrendererdispatcher, (class_2680)state, (class_2338)pos, (class_1920)this.world, (class_4587)poseStack, (class_4588)wrapperBuffer, (class_5819)this.world.field_9229, (class_1921)layer);
                } else {
                    blockrendererdispatcher.method_3355(state, pos, (class_1920)this.world, poseStack, (class_4588)wrapperBuffer, false, this.world.field_9229);
                }
                poseStack.method_22909();
            }
            if (!fluidState.method_15769() && class_4696.method_23680((class_3610)fluidState) == layer) {
                wrapperBuffer.addOffset(pos.method_10263() - (pos.method_10263() & 0xF), pos.method_10264() - (pos.method_10264() & 0xF), pos.method_10260() - (pos.method_10260() & 0xF));
                blockrendererdispatcher.method_3352(pos, (class_1920)this.world, (class_4588)wrapperBuffer, state, fluidState);
            }
            wrapperBuffer.clerOffset();
            wrapperBuffer.clearColor();
            if (this.maxProgress <= 0) continue;
            ++this.progress;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canRenderInLayer(class_2680 state, class_1921 renderType) {
        void var1_1;
        return WorldSceneRendererImpl.canRenderInLayer(state, (class_1921)var1_1);
    }

    private void renderTESR(Collection<class_2338> poses, class_4587 poseStack, class_4597.class_4598 buffers, @Nullable ISceneBlockRenderHook hook, float partialTicks) {
        for (class_2338 pos : poses) {
            class_2586 tile = this.world.method_8321(pos);
            if (tile == null) continue;
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            class_827 tileentityrenderer = class_310.method_1551().method_31975().method_3550(tile);
            if (tileentityrenderer != null && tile.method_11002() && tile.method_11017().method_20526(tile.method_11010())) {
                class_1937 world = tile.method_10997();
                if (hook != null) {
                    hook.applyBESR(world, pos, tile, poseStack, partialTicks);
                }
                tileentityrenderer.method_3569(tile, partialTicks, poseStack, (class_4597)buffers, 0xF000F0, class_4608.field_21444);
            }
            poseStack.method_22909();
        }
    }

    private void renderEntities(TrackedDummyWorld level, class_4587 poseStack, class_4597 buffer, @Nullable ISceneEntityRenderHook hook, float partialTicks) {
        for (class_1297 entity : level.geAllEntities()) {
            poseStack.method_22903();
            if (entity.field_6012 == 0) {
                entity.field_6038 = entity.method_23317();
                entity.field_5971 = entity.method_23318();
                entity.field_5989 = entity.method_23321();
            }
            double d0 = class_3532.method_16436((double)partialTicks, (double)entity.field_6038, (double)entity.method_23317());
            double d1 = class_3532.method_16436((double)partialTicks, (double)entity.field_5971, (double)entity.method_23318());
            double d2 = class_3532.method_16436((double)partialTicks, (double)entity.field_5989, (double)entity.method_23321());
            float f = class_3532.method_16439((float)partialTicks, (float)entity.field_5982, (float)entity.method_36454());
            class_898 renderManager = class_310.method_1551().method_1561();
            int light = renderManager.method_3953(entity).method_24088(entity, partialTicks);
            if (hook != null) {
                hook.applyEntity(this.world, entity, poseStack, partialTicks);
            }
            renderManager.method_3954(entity, d0, d1, d2, f, partialTicks, poseStack, buffer, light);
            poseStack.method_22909();
        }
    }

    public static void setDefaultRenderLayerState(class_1921 layer) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == class_1921.method_23583()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public class_3965 rayTrace(Vector3f hitPos) {
        class_243 startPos = new class_243((double)this.eyePos.x(), (double)this.eyePos.y(), (double)this.eyePos.z());
        if (this.ortho) {
            startPos = startPos.method_1019(new class_243(startPos.field_1352 - (double)this.lookAt.x(), startPos.field_1351 - (double)this.lookAt.y(), startPos.field_1350 - (double)this.lookAt.z()).method_18805(500.0, 500.0, 500.0));
        }
        hitPos.mul(2.0f);
        class_243 endPos = new class_243((double)hitPos.x() - startPos.field_1352, (double)hitPos.y() - startPos.field_1351, (double)hitPos.z() - startPos.field_1350);
        try {
            return this.world.method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.cameraEntity));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector3f project(Vector3f pos) {
        RenderSystem.getModelViewMatrix().get(MODELVIEW_MATRIX_BUFFER);
        RenderSystem.getProjectionMatrix().get(PROJECTION_MATRIX_BUFFER);
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        Project.gluProject(pos.x(), pos.y(), pos.z(), MODELVIEW_MATRIX_BUFFER, PROJECTION_MATRIX_BUFFER, VIEWPORT_BUFFER, OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float winX = OBJECT_POS_BUFFER.get();
        float winY = OBJECT_POS_BUFFER.get();
        float winZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(winX, winY, winZ);
    }

    public Vector3f unProject(int mouseX, int mouseY) {
        GL11.glReadPixels((int)mouseX, (int)mouseY, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        RenderSystem.getModelViewMatrix().get(MODELVIEW_MATRIX_BUFFER);
        RenderSystem.getProjectionMatrix().get(PROJECTION_MATRIX_BUFFER);
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        Project.gluUnProject(mouseX, mouseY, pixelDepth, MODELVIEW_MATRIX_BUFFER, PROJECTION_MATRIX_BUFFER, VIEWPORT_BUFFER, OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(posX, posY, posZ);
    }

    protected class_3965 screenPos2BlockPosFace(int mouseX, int mouseY, int x, int y, int width, int height) {
        RenderSystem.enableDepthTest();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f hitPos = this.unProject(mouseX, mouseY);
        class_3965 result = this.rayTrace(hitPos);
        this.resetCamera();
        return result;
    }

    protected Vector3f blockPos2ScreenPos(class_2338 pos, boolean depth, int x, int y, int width, int height) {
        RenderSystem.enableDepthTest();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f winPos = this.project(new Vector3f((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f));
        this.resetCamera();
        return winPos;
    }

    public void setSceneEntityRenderHook(@Nullable ISceneEntityRenderHook sceneEntityRenderHook) {
        this.sceneEntityRenderHook = sceneEntityRenderHook;
    }

    static enum CacheState {
        UNUSED,
        NEED,
        COMPILING,
        COMPILED;

    }

    public static class VertexConsumerWrapper
    implements class_4588 {
        final class_4588 builder;
        double offsetX;
        double offsetY;
        double offsetZ;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;

        public VertexConsumerWrapper(class_4588 builder) {
            this.builder = builder;
        }

        public void addOffset(double offsetX, double offsetY, double offsetZ) {
            this.offsetX += offsetX;
            this.offsetY += offsetY;
            this.offsetZ += offsetZ;
        }

        public void setColor(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public void clerOffset() {
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.offsetZ = 0.0;
        }

        public void clearColor() {
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
        }

        public class_4588 method_22912(double x, double y, double z) {
            return this.builder.method_22912(x + this.offsetX, y + this.offsetY, z + this.offsetZ);
        }

        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            return this.builder.method_1336((int)((float)red * this.r), (int)((float)green * this.g), (int)((float)blue * this.b), (int)((float)alpha * this.a));
        }

        public class_4588 method_22913(float u, float v) {
            return this.builder.method_22913(u, v);
        }

        public class_4588 method_22917(int u, int v) {
            return this.builder.method_22917(u, v);
        }

        public class_4588 method_22921(int u, int v) {
            return this.builder.method_22921(u, v);
        }

        public class_4588 method_22914(float x, float y, float z) {
            return this.builder.method_22914(x, y, z);
        }

        public void method_1344() {
            this.builder.method_1344();
        }

        public void method_22901(int defaultR, int defaultG, int defaultB, int defaultA) {
            this.builder.method_22901(defaultR, defaultG, defaultB, defaultA);
        }

        public void method_35666() {
            this.builder.method_35666();
        }

        public void setOffsetX(double offsetX) {
            this.offsetX = offsetX;
        }

        public void setOffsetY(double offsetY) {
            this.offsetY = offsetY;
        }

        public void setOffsetZ(double offsetZ) {
            this.offsetZ = offsetZ;
        }
    }
}

