/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_703;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class ParticleManager {
    private static final List<class_3999> RENDER_ORDER = ImmutableList.of((Object)class_3999.field_17827, (Object)class_3999.field_17828, (Object)class_3999.field_17830, (Object)class_3999.field_17829, (Object)class_3999.field_17831);
    private final Queue<class_703> waitToAdded = Queues.newArrayDeque();
    private final Map<class_3999, Queue<class_703>> particles = Maps.newTreeMap(ParticleManager.makeParticleRenderTypeComparator(RENDER_ORDER));
    private final class_1060 textureManager = class_310.method_1551().method_1531();
    public class_1937 level;

    public void setLevel(class_1937 level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllParticles() {
        Queue<class_703> queue = this.waitToAdded;
        synchronized (queue) {
            this.waitToAdded.clear();
            this.particles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticle(class_703 particle) {
        Queue<class_703> queue = this.waitToAdded;
        synchronized (queue) {
            this.waitToAdded.add(particle);
        }
    }

    public int getParticleAmount() {
        int amount = this.waitToAdded.size();
        return amount += this.particles.values().stream().mapToInt(Collection::size).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.waitToAdded.size() > 0) {
            Queue<class_703> queue = this.waitToAdded;
            synchronized (queue) {
                for (class_703 particle : this.waitToAdded) {
                    this.particles.computeIfAbsent(particle.method_18122(), type -> Queues.newArrayDeque()).add(particle);
                }
                this.waitToAdded.clear();
            }
        }
        this.particles.forEach((particleRenderType, particleQueue) -> this.tickParticleList((Collection<class_703>)particleQueue));
    }

    private void tickParticleList(Collection<class_703> pParticles) {
        if (!pParticles.isEmpty()) {
            Iterator<class_703> iterator = pParticles.iterator();
            while (iterator.hasNext()) {
                class_703 particle = iterator.next();
                particle.method_3070();
                if (particle.method_3086()) continue;
                iterator.remove();
            }
        }
    }

    public void render(class_4587 pMatrixStack, class_4184 pActiveRenderInfo, float pPartialTicks) {
        class_310.method_1551().field_1773.method_22974().method_3316();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_34425(pMatrixStack.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();
        for (class_3999 particlerendertype : this.particles.keySet()) {
            Queue<class_703> iterable;
            if (particlerendertype == class_3999.field_17832 || (iterable = this.particles.get(particlerendertype)) == null) continue;
            RenderSystem.setShader(class_757::method_34546);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            particlerendertype.method_18130(bufferbuilder, this.textureManager);
            for (class_703 particle : iterable) {
                particle.method_3074((class_4588)bufferbuilder, pActiveRenderInfo, pPartialTicks);
            }
            particlerendertype.method_18131(tesselator);
        }
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        class_310.method_1551().field_1773.method_22974().method_3315();
    }

    public static Comparator<class_3999> makeParticleRenderTypeComparator(List<class_3999> renderOrder) {
        Comparator<class_3999> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((class_3999)typeOne, (class_3999)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }
}

