/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_6364;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class FBOWorldSceneRenderer
extends WorldSceneRenderer {
    private int resolutionWidth = 1080;
    private int resolutionHeight = 1080;
    private class_276 fbo;

    public FBOWorldSceneRenderer(class_1937 world, int resolutionWidth, int resolutionHeight) {
        super(world);
        this.setFBOSize(resolutionWidth, resolutionHeight);
    }

    public FBOWorldSceneRenderer(class_1937 world, class_276 fbo) {
        super(world);
        this.fbo = fbo;
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public void setFBOSize(int resolutionWidth, int resolutionHeight) {
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.releaseFBO();
        try {
            this.fbo = new class_6364(resolutionWidth, resolutionHeight);
        }
        catch (Exception e) {
            LDLib.LOGGER.error("set FBO SIZE failed", (Throwable)e);
        }
    }

    public class_3965 screenPos2BlockPosFace(int mouseX, int mouseY) {
        int lastID = this.bindFBO();
        class_3965 looking = super.screenPos2BlockPosFace(mouseX, mouseY, 0, 0, this.resolutionWidth, this.resolutionHeight);
        this.unbindFBO(lastID);
        return looking;
    }

    public Vector3f blockPos2ScreenPos(class_2338 pos, boolean depth) {
        int lastID = this.bindFBO();
        Vector3f winPos = super.blockPos2ScreenPos(pos, depth, 0, 0, this.resolutionWidth, this.resolutionHeight);
        this.unbindFBO(lastID);
        return winPos;
    }

    public void render(@Nonnull class_4587 poseStack, float x, float y, float width, float height, float mouseX, float mouseY) {
        int lastID = this.bindFBO();
        super.render(new class_4587(), 0.0f, 0.0f, this.resolutionWidth, this.resolutionHeight, (int)((float)this.resolutionWidth * (mouseX - x) / width), (int)((float)this.resolutionHeight * (1.0f - (mouseY - y) / height)));
        this.unbindFBO(lastID);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (int)this.fbo.method_30277());
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f pose = poseStack.method_23760().method_23761();
        bufferbuilder.method_22918(pose, x + width, y + height, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferbuilder.method_22918(pose, x + width, y, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferbuilder.method_22918(pose, x, y, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferbuilder.method_22918(pose, x, y + height, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
    }

    @Override
    public void render(@Nonnull class_4587 poseStack, float x, float y, float width, float height, int mouseX, int mouseY) {
        this.render(poseStack, x, y, width, height, (float)mouseX, (float)mouseY);
    }

    private int bindFBO() {
        int lastID = GL11.glGetInteger((int)36006);
        this.fbo.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.fbo.method_1230(class_310.field_1703);
        this.fbo.method_1235(true);
        return lastID;
    }

    private void unbindFBO(int lastID) {
        this.fbo.method_1242();
        GlStateManager._glBindFramebuffer((int)36160, (int)lastID);
    }

    public void releaseFBO() {
        if (this.fbo != null) {
            this.fbo.method_1238();
        }
        this.fbo = null;
    }
}

