/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_811;

public class IModelRenderer
implements IRenderer {
    public final class_2960 modelLocation;
    @Environment(value=EnvType.CLIENT)
    protected class_1087 itemModel;
    @Environment(value=EnvType.CLIENT)
    protected Map<class_2350, class_1087> blockModels;

    protected IModelRenderer() {
        this.modelLocation = null;
    }

    public IModelRenderer(class_2960 modelLocation) {
        this.modelLocation = modelLocation;
        if (LDLib.isClient()) {
            this.blockModels = new ConcurrentHashMap<class_2350, class_1087>();
            this.registerEvent();
        }
    }

    @Override
    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public class_1058 getParticleTexture() {
        class_1087 model = this.getItemBakedModel();
        if (model == null) {
            return IRenderer.super.getParticleTexture();
        }
        return model.method_4711();
    }

    @Environment(value=EnvType.CLIENT)
    protected class_1100 getModel() {
        return ModelFactory.getUnBakedModel(this.modelLocation);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        IItemRendererProvider.disabled.set(true);
        model = this.getItemBakedModel(stack);
        if (model != null) {
            class_310.method_1551().method_1480().method_23179(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
        }
        IItemRendererProvider.disabled.set(false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean useBlockLight(class_1799 stack) {
        class_1087 model = this.getItemBakedModel(stack);
        if (model != null) {
            return model.method_24304();
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean useAO() {
        class_1087 model = this.getItemBakedModel();
        if (model != null) {
            return model.method_4708();
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<class_777> renderModel(@Nullable class_1920 level, @Nullable class_2338 pos, @Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
        class_1087 ibakedmodel = this.getBlockBakedModel(pos, level);
        if (ibakedmodel == null) {
            return Collections.emptyList();
        }
        return ibakedmodel.method_4707(state, side, rand);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    protected class_1087 getItemBakedModel() {
        if (this.itemModel == null) {
            class_793 blockModel;
            class_1100 model = this.getModel();
            if (model instanceof class_793 && (blockModel = (class_793)model).method_3431() == class_1088.field_5400) {
                model = ModelFactory.ITEM_MODEL_GENERATOR.method_3479(this::materialMapping, blockModel);
            }
            this.itemModel = model.method_4753(ModelFactory.getModeBaker(), this::materialMapping, (class_3665)class_1086.field_5350, this.modelLocation);
        }
        return this.itemModel;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    protected class_1087 getItemBakedModel(class_1799 itemStack) {
        return this.getItemBakedModel();
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    protected class_1087 getBlockBakedModel(class_2338 pos, class_1920 blockAccess) {
        return this.getRotatedModel(class_2350.field_11043);
    }

    @Environment(value=EnvType.CLIENT)
    public class_1087 getRotatedModel(class_2350 frontFacing) {
        return this.blockModels.computeIfAbsent(frontFacing, facing -> this.getModel().method_4753(ModelFactory.getModeBaker(), this::materialMapping, ModelFactory.getRotation(facing), this.modelLocation));
    }

    @Environment(value=EnvType.CLIENT)
    protected class_1058 materialMapping(class_4730 material) {
        return material.method_24148();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onPrepareTextureAtlas(class_2960 atlasName, Consumer<class_2960> register) {
        if (atlasName.equals((Object)class_1059.field_5275)) {
            this.itemModel = null;
            this.blockModels.clear();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onAdditionalModel(Consumer<class_2960> registry) {
        registry.accept(this.modelLocation);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean isGui3d() {
        class_1087 model = this.getItemBakedModel();
        if (model == null) {
            return IRenderer.super.isGui3d();
        }
        return model.method_4712();
    }
}

