/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.FacadeBlockWorld;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class BlockStateRenderer
implements IRenderer {
    public final BlockInfo blockInfo;
    @Environment(value=EnvType.CLIENT)
    private class_1087 itemModel;

    protected BlockStateRenderer() {
        this.blockInfo = null;
    }

    public BlockStateRenderer(class_2680 state) {
        this(BlockInfo.fromBlockState(state == null ? class_2246.field_10499.method_9564() : state));
    }

    public BlockStateRenderer(BlockInfo blockInfo) {
        BlockInfo blockInfo2 = this.blockInfo = blockInfo == null ? new BlockInfo(class_2246.field_10499) : blockInfo;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public class_2680 getState(@Nullable class_2680 blockState) {
        class_2680 state = this.getBlockInfo().getBlockState();
        if (blockState == null) {
            return state;
        }
        class_2350 facing = class_2350.field_11043;
        if (blockState.method_28498((class_2769)class_2741.field_12525)) {
            facing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12525);
        } else if (blockState.method_28498((class_2769)class_2741.field_12481)) {
            facing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        }
        try {
            switch (facing) {
                case field_11034: {
                    state = state.method_26186(class_2470.field_11463);
                    break;
                }
                case field_11039: {
                    state = state.method_26186(class_2470.field_11465);
                    break;
                }
                case field_11035: {
                    state = state.method_26186(class_2470.field_11464);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }

    @Environment(value=EnvType.CLIENT)
    protected class_1087 getItemModel(class_1799 renderItem) {
        if (this.itemModel == null) {
            this.itemModel = class_310.method_1551().method_1480().method_4019(renderItem, null, null, 0);
        }
        return this.itemModel;
    }

    @Override
    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public class_1058 getParticleTexture() {
        class_1799 renderItem = this.getBlockInfo().getItemStackForm();
        class_1087 model = this.getItemModel(renderItem);
        if (model == null) {
            return IRenderer.super.getParticleTexture();
        }
        return model.method_4711();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_1799 renderItem = this.getBlockInfo().getItemStackForm();
        itemRenderer.method_23179(renderItem, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, this.getItemModel(renderItem));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean useBlockLight(class_1799 stack) {
        class_1799 renderItem = this.getBlockInfo().getItemStackForm();
        class_1087 model = this.getItemModel(renderItem);
        if (model != null) {
            return model.method_24304();
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<class_777> renderModel(@Nullable class_1920 level, @Nullable class_2338 pos, @Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
        if ((state = this.getState(state)).method_26217() != class_2464.field_11455) {
            class_776 brd = class_310.method_1551().method_1541();
            class_1087 model = brd.method_3349(state);
            return model.method_4707(state, side, rand);
        }
        return Collections.emptyList();
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2586 getBlockEntity(class_1920 world, class_2338 pos) {
        BlockInfo blockInfo = this.getBlockInfo();
        class_2586 tile = blockInfo.getBlockEntity(pos);
        if (tile != null && world instanceof class_1937) {
            try {
                class_2680 state = this.getState(world.method_8320(pos));
                tile.method_31664(state);
                tile.method_31662((class_1937)new FacadeBlockWorld((class_1937)world, pos, state, tile));
            }
            catch (Throwable throwable) {
                blockInfo.setHasBlockEntity(false);
            }
        }
        return tile;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean hasTESR(class_2586 tileEntity) {
        if (!this.getBlockInfo().getBlockState().method_26227().method_15769()) {
            return true;
        }
        if ((tileEntity = this.getBlockEntity((class_1920)tileEntity.method_10997(), tileEntity.method_11016())) == null) {
            return false;
        }
        return class_310.method_1551().method_31975().method_3550(tileEntity) != null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean isGlobalRenderer(class_2586 tileEntity) {
        if ((tileEntity = this.getBlockEntity((class_1920)tileEntity.method_10997(), tileEntity.method_11016())) == null) {
            return false;
        }
        class_827 tesr = class_310.method_1551().method_31975().method_3550(tileEntity);
        if (tesr != null) {
            return tesr.method_3563(tileEntity);
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_2586 tileEntity, float partialTicks, class_4587 stack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        BlockInfo block = this.getBlockInfo();
        class_3610 fluidState = block.getBlockState().method_26227();
        if (!fluidState.method_15769()) {
            class_4588 builder = buffer.getBuffer(class_1921.method_23583());
            class_310.method_1551().method_1541().method_3352(tileEntity.method_11016(), (class_1920)tileEntity.method_10997(), builder, block.getBlockState(), fluidState);
        }
        if ((tileEntity = this.getBlockEntity((class_1920)tileEntity.method_10997(), tileEntity.method_11016())) == null) {
            return;
        }
        class_827 tesr = class_310.method_1551().method_31975().method_3550(tileEntity);
        if (tesr != null) {
            try {
                tesr.method_3569(tileEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
            }
            catch (Exception e) {
                this.getBlockInfo().setHasBlockEntity(false);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onPrepareTextureAtlas(class_2960 atlasName, Consumer<class_2960> register) {
        if (atlasName.equals((Object)class_1059.field_5275)) {
            this.itemModel = null;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean useAO() {
        class_2680 state = this.getBlockInfo().getBlockState();
        if (state.method_26217() != class_2464.field_11455) {
            return class_310.method_1551().method_1541().method_3349(state).method_4708();
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean isGui3d() {
        class_1087 model = this.getItemModel(this.getBlockInfo().getItemStackForm());
        if (model == null) {
            return IRenderer.super.isGui3d();
        }
        return model.method_4712();
    }
}

