/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.custommodel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;

@Environment(value=EnvType.CLIENT)
public class LDLMetadataSection {
    public static final String SECTION_NAME = "ldlib";
    private static final Map<class_2960, LDLMetadataSection> METADATA_CACHE = new ConcurrentHashMap<class_2960, LDLMetadataSection>();
    public static final LDLMetadataSection MISSING = new LDLMetadataSection(false, null);
    public final boolean emissive;
    public final class_2960 connection;

    public LDLMetadataSection(boolean emissive, class_2960 connection) {
        this.emissive = emissive;
        this.connection = connection;
    }

    public static void clearCache() {
        METADATA_CACHE.clear();
    }

    public boolean isMissing() {
        return this == MISSING;
    }

    @Nonnull
    public static LDLMetadataSection getMetadata(class_2960 res) {
        if (METADATA_CACHE.containsKey(res)) {
            return METADATA_CACHE.get(res);
        }
        LDLMetadataSection ret = MISSING;
        Optional resourceOptional = class_310.method_1551().method_1478().method_14486(res);
        if (resourceOptional.isPresent()) {
            class_3298 resource = (class_3298)resourceOptional.get();
            try {
                ret = (LDLMetadataSection)resource.method_14481().method_43041((class_3270)Serializer.INSTANCE).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        METADATA_CACHE.put(res, ret);
        return ret;
    }

    @Nonnull
    public static LDLMetadataSection getMetadata(class_1058 sprite) {
        return LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(sprite.method_45851().method_45816()));
    }

    public static boolean isEmissive(class_1058 sprite) {
        LDLMetadataSection ret = LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(sprite.method_45851().method_45816()));
        return ret.emissive;
    }

    @Nullable
    public static class_1058 getConnection(class_1058 sprite) {
        LDLMetadataSection ret = LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(sprite.method_45851().method_45816()));
        return ret.connection == null ? null : ModelFactory.getBlockSprite(ret.connection);
    }

    public static class_2960 spriteToAbsolute(class_2960 sprite) {
        if (!sprite.method_12832().startsWith("textures/")) {
            sprite = new class_2960(sprite.method_12836(), "textures/" + sprite.method_12832());
        }
        if (!sprite.method_12832().endsWith(".png")) {
            sprite = new class_2960(sprite.method_12836(), sprite.method_12832() + ".png");
        }
        return sprite;
    }

    public static class Serializer
    implements class_3270<LDLMetadataSection> {
        static Serializer INSTANCE = new Serializer();

        @Nonnull
        public String method_14420() {
            return LDLMetadataSection.SECTION_NAME;
        }

        @Nonnull
        public LDLMetadataSection fromJson(@Nonnull JsonObject json) {
            boolean emissive = false;
            class_2960 connection = null;
            if (json.isJsonObject()) {
                JsonElement element;
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("emissive") && (element = obj.get("emissive")).isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
                    emissive = element.getAsBoolean();
                }
                if (obj.has("connection") && (element = obj.get("connection")).isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    connection = new class_2960(element.getAsString());
                }
            }
            return new LDLMetadataSection(emissive, connection);
        }
    }
}

