/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model;

import com.google.gson.JsonParseException;
import com.lowdragmc.lowdraglib.client.model.fabric.ModelFactoryImpl;
import com.mojang.datafixers.util.Either;
import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_6328;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class ModelFactory {
    public static final class_801 ITEM_MODEL_GENERATOR = new class_801();
    public static final class_804 TRANSFORM_BLOCK_GUI = ModelFactory.makeTransform(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    public static final class_804 TRANSFORM_BLOCK_GROUND = ModelFactory.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
    public static final class_804 TRANSFORM_BLOCK_FIXED = ModelFactory.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    public static final class_804 TRANSFORM_BLOCK_3RD_PERSON_RIGHT = ModelFactory.makeTransform(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
    public static final class_804 TRANSFORM_BLOCK_1ST_PERSON_RIGHT = ModelFactory.makeTransform(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final class_804 TRANSFORM_BLOCK_1ST_PERSON_LEFT = ModelFactory.makeTransform(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final class_809 MODEL_TRANSFORM_BLOCK = new class_809(TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_1ST_PERSON_LEFT, TRANSFORM_BLOCK_1ST_PERSON_RIGHT, class_804.field_4284, TRANSFORM_BLOCK_GUI, TRANSFORM_BLOCK_GROUND, TRANSFORM_BLOCK_FIXED);

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_1088 getModeBakery() {
        return ModelFactoryImpl.getModeBakery();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_1100 getLDLibModel(class_1100 vanilla) {
        return ModelFactoryImpl.getLDLibModel(vanilla);
    }

    public static class_7775 getModeBaker() {
        return new class_7775(){

            public class_1100 method_45872(class_2960 location) {
                return ModelFactory.getUnBakedModel(location);
            }

            public class_1087 method_45873(class_2960 location, class_3665 transform) {
                class_793 blockmodel;
                class_1100 unbakedmodel = this.method_45872(location);
                if (unbakedmodel instanceof class_793 && (blockmodel = (class_793)unbakedmodel).method_3431() == class_1088.field_5400) {
                    return ITEM_MODEL_GENERATOR.method_3479(class_4730::method_24148, blockmodel).method_3446((class_7775)this, blockmodel, class_4730::method_24148, transform, location, false);
                }
                return unbakedmodel.method_4753((class_7775)this, class_4730::method_24148, transform, location);
            }
        };
    }

    public static class_1100 getUnBakedModel(class_2960 modelLocation) {
        return ModelFactory.getModeBakery().method_4726(modelLocation);
    }

    public static Quaternionf getQuaternion(class_2350 facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> new Quaternionf().rotateXYZ(1.5707964f, 0.0f, 0.0f);
            case class_2350.field_11033 -> new Quaternionf().rotateXYZ(-1.5707964f, 0.0f, 0.0f);
            case class_2350.field_11034 -> new Quaternionf().rotateXYZ(0.0f, -1.5707964f, 0.0f);
            case class_2350.field_11039 -> new Quaternionf().rotateXYZ(0.0f, 1.5707964f, 0.0f);
            case class_2350.field_11035 -> new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f);
            case class_2350.field_11043 -> new Quaternionf();
        };
    }

    public static class_3665 getRotation(class_2350 facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> class_1086.field_5351;
            case class_2350.field_11036 -> class_1086.field_5353;
            case class_2350.field_11043 -> class_1086.field_5350;
            case class_2350.field_11035 -> class_1086.field_5355;
            case class_2350.field_11039 -> class_1086.field_5347;
            case class_2350.field_11034 -> class_1086.field_5366;
        };
    }

    public static class_2350 modelFacing(class_2350 side, class_2350 frontFacing) {
        if (side == frontFacing) {
            return class_2350.field_11043;
        }
        if (frontFacing == class_2350.field_11043) {
            return side;
        }
        if (frontFacing == class_2350.field_11035) {
            if (side.method_10166() == class_2350.class_2351.field_11052) {
                return side;
            }
            return side.method_10153();
        }
        if (frontFacing == class_2350.field_11034) {
            if (side.method_10166() == class_2350.class_2351.field_11052) {
                return side;
            }
            return side.method_10160();
        }
        if (frontFacing == class_2350.field_11039) {
            if (side.method_10166() == class_2350.class_2351.field_11052) {
                return side;
            }
            return side.method_10170();
        }
        if (frontFacing == class_2350.field_11036) {
            if (side == class_2350.field_11033) {
                return class_2350.field_11035;
            }
            if (side.method_10166() == class_2350.class_2351.field_11048) {
                return side;
            }
            if (side == class_2350.field_11035) {
                return class_2350.field_11036;
            }
            if (side == class_2350.field_11043) {
                return class_2350.field_11033;
            }
        }
        if (frontFacing == class_2350.field_11033) {
            if (side == class_2350.field_11036) {
                return class_2350.field_11035;
            }
            if (side.method_10166() == class_2350.class_2351.field_11048) {
                return side;
            }
            if (side == class_2350.field_11035) {
                return class_2350.field_11033;
            }
            if (side == class_2350.field_11043) {
                return class_2350.field_11036;
            }
        }
        return side;
    }

    public static class_3665 getRotation(class_2350 facing, boolean lockedUV) {
        if (lockedUV) {
            return new ModelStateWrapper(ModelFactory.getRotation(facing), true);
        }
        return ModelFactory.getRotation(facing);
    }

    public static Either<class_4730, String> parseTextureLocationOrReference(class_2960 pLocation, String pName) {
        if (ModelFactory.isTextureReference(pName)) {
            return Either.right((Object)pName.substring(1));
        }
        class_2960 resourcelocation = class_2960.method_12829((String)pName);
        if (resourcelocation == null) {
            throw new JsonParseException(pName + " is not valid resource location");
        }
        return Either.left((Object)new class_4730(pLocation, resourcelocation));
    }

    public static Either<class_4730, String> parseBlockTextureLocationOrReference(String pName) {
        if (ModelFactory.isTextureReference(pName)) {
            return Either.right((Object)pName.substring(1));
        }
        class_2960 resourcelocation = class_2960.method_12829((String)pName);
        if (resourcelocation == null) {
            throw new JsonParseException(pName + " is not valid resource location");
        }
        return Either.left((Object)new class_4730(class_1059.field_5275, resourcelocation));
    }

    private static boolean isTextureReference(String pStr) {
        return pStr.charAt(0) == '#';
    }

    public static class_1058 getBlockSprite(class_2960 location) {
        return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(location);
    }

    public static class_1058 getSprite(class_2960 atlas, class_2960 location) {
        return (class_1058)class_310.method_1551().method_1549(atlas).apply(location);
    }

    public static class_804 makeTransform(float rotationX, float rotationY, float rotationZ, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float scaleZ) {
        Vector3f translation = new Vector3f(translationX, translationY, translationZ);
        translation.mul(0.0625f);
        translation.set(class_3532.method_15363((float)translation.x, (float)-5.0f, (float)5.0f), class_3532.method_15363((float)translation.y, (float)-5.0f, (float)5.0f), class_3532.method_15363((float)translation.z, (float)-5.0f, (float)5.0f));
        return new class_804(new Vector3f(rotationX, rotationY, rotationZ), translation, new Vector3f(scaleX, scaleY, scaleZ));
    }

    private record ModelStateWrapper(class_3665 modelState, boolean lockedUV) implements class_3665
    {
        @Nonnull
        public class_4590 method_3509() {
            return this.modelState.method_3509();
        }

        public boolean method_3512() {
            return this.lockedUV;
        }
    }
}

