/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.client.bakedpipeline.IQuadTransformer;
import java.util.Arrays;
import net.minecraft.class_156;
import net.minecraft.class_765;

public class QuadTransformers {
    private static final IQuadTransformer EMPTY = quad -> {};
    private static final IQuadTransformer[] EMISSIVE_TRANSFORMERS = (IQuadTransformer[])class_156.method_654((Object)new IQuadTransformer[16], array -> Arrays.setAll(array, i -> QuadTransformers.applyingLightmap(class_765.method_23687((int)i, (int)i))));

    public static IQuadTransformer empty() {
        return EMPTY;
    }

    public static IQuadTransformer applyingLightmap(int lightmap) {
        return quad -> {
            int[] vertices = quad.method_3357();
            for (int i = 0; i < 4; ++i) {
                vertices[i * IQuadTransformer.STRIDE + IQuadTransformer.UV2] = lightmap;
            }
        };
    }

    public static IQuadTransformer settingEmissivity(int emissivity) {
        Preconditions.checkArgument((emissivity >= 0 && emissivity < 16 ? 1 : 0) != 0, (Object)"Emissivity must be between 0 and 15.");
        return EMISSIVE_TRANSFORMERS[emissivity];
    }

    public static IQuadTransformer settingMaxEmissivity() {
        return EMISSIVE_TRANSFORMERS[15];
    }

    private QuadTransformers() {
    }
}

