/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.client.bakedpipeline.IQuadTransformer;
import com.lowdragmc.lowdraglib.core.mixins.accessor.VertexFormatAccessor;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_777;

public class QuadBakingVertexConsumer
implements class_4588 {
    private final Map<class_296, Integer> ELEMENT_OFFSETS = (Map)class_156.method_654(new IdentityHashMap(), map -> {
        int i = 0;
        for (class_296 element : class_290.field_1590.method_1357()) {
            map.put(element, ((VertexFormatAccessor)class_290.field_1590).getOffsets().getInt(i++) / 4);
        }
    });
    private static final int QUAD_DATA_SIZE = IQuadTransformer.STRIDE * 4;
    private final Consumer<class_777> quadConsumer;
    int vertexIndex = 0;
    private int[] quadData = new int[QUAD_DATA_SIZE];
    private int tintIndex;
    private class_2350 direction = class_2350.field_11033;
    private class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(class_1047.method_4539());
    private boolean shade;
    private boolean hasAmbientOcclusion;

    public QuadBakingVertexConsumer(Consumer<class_777> quadConsumer) {
        this.quadConsumer = quadConsumer;
    }

    public class_4588 method_22912(double x, double y, double z) {
        int offset = this.vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.POSITION;
        this.quadData[offset] = Float.floatToRawIntBits((float)x);
        this.quadData[offset + 1] = Float.floatToRawIntBits((float)y);
        this.quadData[offset + 2] = Float.floatToRawIntBits((float)z);
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        int offset = this.vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.NORMAL;
        this.quadData[offset] = (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        int offset = this.vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.COLOR;
        this.quadData[offset] = (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF;
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        int offset = this.vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.UV0;
        this.quadData[offset] = Float.floatToRawIntBits(u);
        this.quadData[offset + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public class_4588 method_22917(int u, int v) {
        if (IQuadTransformer.UV1 >= 0) {
            int offset = this.vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.UV1;
            this.quadData[offset] = u & 0xFFFF | (v & 0xFFFF) << 16;
        }
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        int offset = this.vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.UV2;
        this.quadData[offset] = u & 0xFFFF | (v & 0xFFFF) << 16;
        return this;
    }

    public class_4588 misc(class_296 element, int ... rawData) {
        Integer baseOffset = this.ELEMENT_OFFSETS.get(element);
        if (baseOffset != null) {
            int offset = this.vertexIndex * IQuadTransformer.STRIDE + baseOffset;
            System.arraycopy(rawData, 0, this.quadData, offset, rawData.length);
        }
        return this;
    }

    public void method_1344() {
        if (++this.vertexIndex == 4) {
            this.quadConsumer.accept(new class_777(this.quadData, this.tintIndex, this.direction, this.sprite, this.shade));
            this.vertexIndex = 0;
            this.quadData = new int[QUAD_DATA_SIZE];
        }
    }

    public void method_22901(int defaultR, int defaultG, int defaultB, int defaultA) {
    }

    public void method_35666() {
    }

    public void setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
    }

    public void setDirection(class_2350 direction) {
        this.direction = direction;
    }

    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    public void setHasAmbientOcclusion(boolean hasAmbientOcclusion) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
    }

    public static class Buffered
    extends QuadBakingVertexConsumer {
        private final class_777[] output;

        public Buffered() {
            this(new class_777[1]);
        }

        private Buffered(class_777[] output) {
            super(q -> {
                output[0] = q;
            });
            this.output = output;
        }

        public class_777 getQuad() {
            class_777 quad = (class_777)Preconditions.checkNotNull((Object)this.output[0], (Object)("No quad has been emitted. Vertices in buffer: " + this.vertexIndex));
            this.output[0] = null;
            return quad;
        }
    }
}

