/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.lowdragmc.lowdraglib.client.bakedpipeline.IQuadTransformer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.ISubmap;
import com.lowdragmc.lowdraglib.client.bakedpipeline.QuadBakingVertexConsumer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Submap;
import com.lowdragmc.lowdraglib.core.mixins.accessor.VertexFormatAccessor;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_777;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
public class Quad {
    private static final class_1058 BASE = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(class_1047.method_4539());
    private final Vector3f[] vertPos;
    private final class_241[] vertUv;
    private UVs uvs;
    private final Builder builder;
    private final int blocklight;
    private final int skylight;

    private Quad(Vector3f[] verts, class_241[] uvs, Builder builder, class_1058 sprite) {
        this(verts, uvs, builder, sprite, 0, 0);
    }

    private Quad(Vector3f[] verts, class_241[] uvs, Builder builder, class_1058 sprite, int blocklight, int skylight) {
        this.vertPos = verts;
        this.vertUv = uvs;
        this.builder = builder;
        this.uvs = new UVs(sprite, uvs);
        this.blocklight = blocklight;
        this.skylight = skylight;
    }

    private Quad(Vector3f[] verts, UVs uvs, Builder builder, int blocklight, int skylight) {
        this(verts, uvs.vectorize(), builder, uvs.getSprite(), blocklight, skylight);
    }

    public Vector3f getVert(int index) {
        return new Vector3f((Vector3fc)this.vertPos[index % 4]);
    }

    public Quad withVert(int index, Vector3f vert) {
        Vector3f[] newverts = new Vector3f[4];
        System.arraycopy(this.vertPos, 0, newverts, 0, newverts.length);
        newverts[index] = vert;
        return new Quad(newverts, this.getUvs(), this.builder, this.blocklight, this.skylight);
    }

    public class_241 getUv(int index) {
        return new class_241(this.vertUv[index % 4].field_1343, this.vertUv[index % 4].field_1342);
    }

    public Quad withUv(int index, class_241 uv) {
        class_241[] newuvs = new class_241[4];
        System.arraycopy(this.getUvs().vectorize(), 0, newuvs, 0, newuvs.length);
        newuvs[index] = uv;
        return new Quad(this.vertPos, new UVs(newuvs), this.builder, this.blocklight, this.skylight);
    }

    public void compute() {
    }

    public Quad[] subdivide(int count) {
        if (count == 1) {
            return new Quad[]{this};
        }
        if (count != 4) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Quad> rects = new ArrayList<Quad>();
        Pair<Quad, Quad> firstDivide = this.divide(false);
        Pair<Quad, Quad> secondDivide = ((Quad)firstDivide.left()).divide(true);
        rects.add((Quad)secondDivide.left());
        if (firstDivide.right() != null) {
            Pair<Quad, Quad> thirdDivide = ((Quad)firstDivide.right()).divide(true);
            rects.add((Quad)thirdDivide.left());
            rects.add((Quad)thirdDivide.right());
        } else {
            rects.add(null);
            rects.add(null);
        }
        rects.add((Quad)secondDivide.right());
        return (Quad[])rects.toArray(Quad[]::new);
    }

    private Pair<Quad, Quad> divide(boolean vertical) {
        float max;
        float min;
        UVs uvs = this.getUvs().normalize();
        if (vertical) {
            min = uvs.minV;
            max = uvs.maxV;
        } else {
            min = uvs.minU;
            max = uvs.maxU;
        }
        if ((double)min < 0.5 && (double)max > 0.5) {
            UVs first = new UVs(vertical ? uvs.minU : 0.5f, vertical ? 0.5f : uvs.minV, uvs.maxU, uvs.maxV, uvs.getSprite());
            UVs second = new UVs(uvs.minU, uvs.minV, vertical ? uvs.maxU : 0.5f, vertical ? 0.5f : uvs.maxV, uvs.getSprite());
            int firstIndex = 0;
            for (int i = 0; i < this.vertUv.length; ++i) {
                if (this.vertUv[i].field_1342 != this.getUvs().minV || this.vertUv[i].field_1343 != this.getUvs().minU) continue;
                firstIndex = i;
                break;
            }
            float f = (0.5f - min) / (max - min);
            Vector3f[] firstQuad = new Vector3f[4];
            Vector3f[] secondQuad = new Vector3f[4];
            for (int i = 0; i < 4; ++i) {
                int idx = (firstIndex + i) % 4;
                firstQuad[i] = new Vector3f((Vector3fc)this.vertPos[idx]);
                secondQuad[i] = new Vector3f((Vector3fc)this.vertPos[idx]);
            }
            int i1 = 0;
            int i2 = vertical ? 1 : 3;
            int j1 = vertical ? 3 : 1;
            int j2 = 2;
            firstQuad[i1].set(Quad.lerp(firstQuad[i1].x(), firstQuad[i2].x(), f), Quad.lerp(firstQuad[i1].y(), firstQuad[i2].y(), f), Quad.lerp(firstQuad[i1].z(), firstQuad[i2].z(), f));
            firstQuad[j1].set(Quad.lerp(firstQuad[j1].x(), firstQuad[j2].x(), f), Quad.lerp(firstQuad[j1].y(), firstQuad[j2].y(), f), Quad.lerp(firstQuad[j1].z(), firstQuad[j2].z(), f));
            secondQuad[i2].set(Quad.lerp(secondQuad[i1].x(), secondQuad[i2].x(), f), Quad.lerp(secondQuad[i1].y(), secondQuad[i2].y(), f), Quad.lerp(secondQuad[i1].z(), secondQuad[i2].z(), f));
            secondQuad[j2].set(Quad.lerp(secondQuad[j1].x(), secondQuad[j2].x(), f), Quad.lerp(secondQuad[j1].y(), secondQuad[j2].y(), f), Quad.lerp(secondQuad[j1].z(), secondQuad[j2].z(), f));
            Quad q1 = new Quad(firstQuad, first.relativize(), this.builder, this.blocklight, this.skylight);
            Quad q2 = new Quad(secondQuad, second.relativize(), this.builder, this.blocklight, this.skylight);
            return Pair.of((Object)q1, (Object)q2);
        }
        return Pair.of((Object)this, null);
    }

    public static float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }

    public static float normalize(float min, float max, float x) {
        return (x - min) / (max - min);
    }

    public Quad rotate(int amount) {
        int i;
        class_241[] uvs = new class_241[4];
        class_1058 s = this.getUvs().getSprite();
        for (i = 0; i < 4; ++i) {
            class_241 uv;
            class_241 normalized = new class_241(Quad.normalize(s.method_4594(), s.method_4577(), this.vertUv[i].field_1343), Quad.normalize(s.method_4593(), s.method_4575(), this.vertUv[i].field_1342));
            uvs[i] = uv = (switch (amount) {
                case 1 -> new class_241(normalized.field_1342, 1.0f - normalized.field_1343);
                case 2 -> new class_241(1.0f - normalized.field_1343, 1.0f - normalized.field_1342);
                case 3 -> new class_241(1.0f - normalized.field_1342, normalized.field_1343);
                default -> new class_241(normalized.field_1343, normalized.field_1342);
            });
        }
        for (i = 0; i < uvs.length; ++i) {
            uvs[i] = new class_241(Quad.lerp(s.method_4594(), s.method_4577(), uvs[i].field_1343), Quad.lerp(s.method_4593(), s.method_4575(), uvs[i].field_1342));
        }
        return new Quad(this.vertPos, uvs, this.builder, this.getUvs().getSprite(), this.blocklight, this.skylight);
    }

    public Quad derotate() {
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            if (!(this.vertUv[i].field_1343 <= this.getUvs().minU) || !(this.vertUv[i].field_1342 <= this.getUvs().minV)) continue;
            start = i;
            break;
        }
        class_241[] uvs = new class_241[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = this.vertUv[(i + start) % 4];
        }
        return new Quad(this.vertPos, uvs, this.builder, this.getUvs().getSprite(), this.blocklight, this.skylight);
    }

    public Quad setLight(int blocklight, int skylight) {
        return new Quad(this.vertPos, this.uvs, this.builder, Math.max(this.blocklight, blocklight), Math.max(this.skylight, skylight));
    }

    public class_777 rebake() {
        class_777[] quad = new class_777[1];
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        builder.setDirection(this.builder.quadOrientation);
        builder.setTintIndex(this.builder.quadTint);
        builder.setShade(this.builder.applyDiffuseLighting);
        builder.setSprite(this.uvs.getSprite());
        class_293 format = class_290.field_1590;
        for (int v = 0; v < 4; ++v) {
            block5: for (int i = 0; i < format.method_1357().size(); ++i) {
                class_296 ele = (class_296)format.method_1357().get(i);
                switch (ele.method_1382()) {
                    case field_1633: {
                        Vector3f p = this.vertPos[v];
                        builder.method_22912(p.x(), p.y(), p.z());
                        continue block5;
                    }
                    case field_1636: {
                        if (ele.method_1385() == 2) {
                            builder.method_22921(this.blocklight * 16, this.skylight * 16);
                            continue block5;
                        }
                        if (ele.method_1385() == 0) {
                            class_241 uv = this.vertUv[v];
                            builder.method_22913(uv.field_1343, uv.field_1342);
                            continue block5;
                        }
                    }
                    default: {
                        builder.misc(ele, this.builder.packedByElement.get(ele)[v]);
                    }
                }
            }
            builder.method_1344();
        }
        return quad[0];
    }

    public Quad transformUVs(class_1058 sprite) {
        return this.transformUVs(sprite, Submap.FULL_TEXTURE.normalize());
    }

    public Quad transformUVs(class_1058 sprite, ISubmap submap) {
        return new Quad(this.vertPos, this.getUvs().transform(sprite, submap), this.builder, this.blocklight, this.skylight);
    }

    public Quad grow() {
        return new Quad(this.vertPos, this.getUvs().normalizeQuadrant(), this.builder, this.blocklight, this.skylight);
    }

    public static Quad from(class_777 baked) {
        Builder b = new Builder(baked.method_35788());
        b.copyFrom(baked, 0.0f);
        return b.build();
    }

    public static Quad from(class_777 baked, float offset) {
        Builder b = new Builder(baked.method_35788());
        b.copyFrom(baked, offset);
        return b.build();
    }

    public String toString() {
        return "Quad(vertPos=" + Arrays.deepToString(this.vertPos) + ", vertUv=" + Arrays.deepToString(this.vertUv) + ")";
    }

    public UVs getUvs() {
        return this.uvs;
    }

    public static class Builder {
        private final Map<class_296, Integer> ELEMENT_OFFSETS = (Map)class_156.method_654(new IdentityHashMap(), map -> {
            int i = 0;
            for (class_296 element : class_290.field_1590.method_1357()) {
                map.put(element, ((VertexFormatAccessor)class_290.field_1590).getOffsets().getInt(i++) / 4);
            }
        });
        private final class_1058 sprite;
        private int quadTint = -1;
        private class_2350 quadOrientation;
        private boolean applyDiffuseLighting;
        private final float[][] positions = new float[4][];
        private final float[][] uvs = new float[4][];
        private final int[][] uvs2 = new int[4][];
        private final int[][] colors = new int[4][];
        private Map<class_296, int[][]> packedByElement = new HashMap<class_296, int[][]>();

        public void copyFrom(class_777 baked, float directionOffset) {
            this.setQuadTint(baked.method_3359());
            this.setQuadOrientation(baked.method_3358());
            this.setApplyDiffuseLighting(baked.method_24874());
            int[] vertices = baked.method_3357();
            for (int i = 0; i < 4; ++i) {
                int offset = i * IQuadTransformer.STRIDE;
                this.positions[i] = new float[]{Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION]), Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 1]), Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 2]), 0.0f};
                if (this.quadOrientation != null && directionOffset != 0.0f) {
                    float[] fArray = this.positions[i];
                    fArray[0] = fArray[0] + directionOffset * (float)this.quadOrientation.method_10148();
                    float[] fArray2 = this.positions[i];
                    fArray2[1] = fArray2[1] + directionOffset * (float)this.quadOrientation.method_10164();
                    float[] fArray3 = this.positions[i];
                    fArray3[2] = fArray3[2] + directionOffset * (float)this.quadOrientation.method_10165();
                }
                int packedColor = vertices[offset + IQuadTransformer.COLOR];
                this.colors[i] = new int[]{packedColor & 0xFF, packedColor << 8 & 0xFF, packedColor << 16 & 0xFF, packedColor << 24 & 0xFF};
                this.uvs[i] = new float[]{Float.intBitsToFloat(vertices[offset + IQuadTransformer.UV0]), Float.intBitsToFloat(vertices[offset + IQuadTransformer.UV0 + 1])};
                int lightMap = vertices[offset + IQuadTransformer.UV2];
                this.uvs2[i] = new int[]{lightMap & 0xFFFF, lightMap >> 16 & 0xFFFF};
            }
            for (Map.Entry<class_296, Integer> e : this.ELEMENT_OFFSETS.entrySet()) {
                Integer offset = e.getValue();
                int[][] data = new int[4][e.getKey().method_1387() / 4];
                for (int v = 0; v < 4; ++v) {
                    for (int i = 0; i < data[v].length; ++i) {
                        data[v][i] = vertices[v * IQuadTransformer.STRIDE + offset + i];
                    }
                }
                this.packedByElement.put(e.getKey(), data);
            }
        }

        public Quad build() {
            Vector3f[] verts = new Vector3f[4];
            class_241[] uvs = new class_241[4];
            for (int i = 0; i < verts.length; ++i) {
                verts[i] = new Vector3f(this.positions[i][0], this.positions[i][1], this.positions[i][2]);
                uvs[i] = new class_241(this.uvs[i][0], this.uvs[i][1]);
            }
            return new Quad(verts, uvs, this, this.getSprite(), this.uvs2[0][0] >> 4, this.uvs2[0][1] >> 4);
        }

        private <T> T[] fromData(List<float[]> data, int size) {
            class_241[] ret = size == 2 ? new class_241[data.size()] : new Vector3f[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                ret[i] = size == 2 ? new class_241(data.get(i)[0], data.get(i)[1]) : new Vector3f(data.get(i)[0], data.get(i)[1], data.get(i)[2]);
            }
            return ret;
        }

        public void setTexture(@Nullable class_1058 texture) {
        }

        public Builder(class_1058 sprite) {
            this.sprite = sprite;
        }

        public class_1058 getSprite() {
            return this.sprite;
        }

        public void setQuadTint(int quadTint) {
            this.quadTint = quadTint;
        }

        public void setQuadOrientation(class_2350 quadOrientation) {
            this.quadOrientation = quadOrientation;
        }

        public void setApplyDiffuseLighting(boolean applyDiffuseLighting) {
            this.applyDiffuseLighting = applyDiffuseLighting;
        }
    }

    public static class UVs {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private final class_1058 sprite;
        private final class_241[] data;

        private UVs(class_241 ... data) {
            this(BASE, data);
        }

        private UVs(class_1058 sprite, class_241 ... data) {
            this.data = data;
            this.sprite = sprite;
            float minU = Float.MAX_VALUE;
            float minV = Float.MAX_VALUE;
            float maxU = 0.0f;
            float maxV = 0.0f;
            for (class_241 v : data) {
                minU = Math.min(minU, v.field_1343);
                minV = Math.min(minV, v.field_1342);
                maxU = Math.max(maxU, v.field_1343);
                maxV = Math.max(maxV, v.field_1342);
            }
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public UVs(float minU, float minV, float maxU, float maxV, class_1058 sprite) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.sprite = sprite;
            this.data = this.vectorize();
        }

        public UVs transform(class_1058 other, ISubmap submap) {
            UVs normal = this.normalize();
            submap = submap.normalize();
            float width = normal.maxU - normal.minU;
            float height = normal.maxV - normal.minV;
            float minU = submap.getXOffset();
            float minV = submap.getYOffset();
            float maxU = (minU += normal.minU * submap.getWidth()) + width * submap.getWidth();
            float maxV = (minV += normal.minV * submap.getHeight()) + height * submap.getHeight();
            return new UVs(other, new class_241(this.data[0].field_1343 == this.minU ? minU : maxU, this.data[0].field_1342 == this.minV ? minV : maxV), new class_241(this.data[1].field_1343 == this.minU ? minU : maxU, this.data[1].field_1342 == this.minV ? minV : maxV), new class_241(this.data[2].field_1343 == this.minU ? minU : maxU, this.data[2].field_1342 == this.minV ? minV : maxV), new class_241(this.data[3].field_1343 == this.minU ? minU : maxU, this.data[3].field_1342 == this.minV ? minV : maxV)).relativize();
        }

        UVs normalizeQuadrant() {
            UVs normal = this.normalize();
            int quadrant = normal.getQuadrant();
            float minUInterp = quadrant == 1 || quadrant == 2 ? 0.5f : 0.0f;
            float minVInterp = quadrant < 2 ? 0.5f : 0.0f;
            float maxUInterp = quadrant == 0 || quadrant == 3 ? 0.5f : 1.0f;
            float maxVInterp = quadrant > 1 ? 0.5f : 1.0f;
            normal = new UVs(this.sprite, this.normalize(new class_241(minUInterp, minVInterp), new class_241(maxUInterp, maxVInterp), normal.vectorize()));
            return normal.relativize();
        }

        public UVs normalize() {
            class_241 min = new class_241(this.sprite.method_4594(), this.sprite.method_4593());
            class_241 max = new class_241(this.sprite.method_4577(), this.sprite.method_4575());
            return new UVs(this.sprite, this.normalize(min, max, this.data));
        }

        public UVs relativize() {
            return this.relativize(this.sprite);
        }

        public UVs relativize(class_1058 sprite) {
            class_241 min = new class_241(sprite.method_4594(), sprite.method_4593());
            class_241 max = new class_241(sprite.method_4577(), sprite.method_4575());
            return new UVs(sprite, this.lerp(min, max, this.data));
        }

        public class_241[] vectorize() {
            class_241[] class_241Array;
            if (this.data == null) {
                class_241[] class_241Array2 = new class_241[4];
                class_241Array2[0] = new class_241(this.minU, this.minV);
                class_241Array2[1] = new class_241(this.minU, this.maxV);
                class_241Array2[2] = new class_241(this.maxU, this.maxV);
                class_241Array = class_241Array2;
                class_241Array2[3] = new class_241(this.maxU, this.minV);
            } else {
                class_241Array = this.data;
            }
            return class_241Array;
        }

        private class_241[] normalize(class_241 min, class_241 max, class_241 ... vecs) {
            class_241[] ret = new class_241[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.normalize(min, max, vecs[i]);
            }
            return ret;
        }

        private class_241 normalize(class_241 min, class_241 max, class_241 vec) {
            return new class_241(Quad.normalize(min.field_1343, max.field_1343, vec.field_1343), Quad.normalize(min.field_1342, max.field_1342, vec.field_1342));
        }

        private class_241[] lerp(class_241 min, class_241 max, class_241 ... vecs) {
            class_241[] ret = new class_241[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.lerp(min, max, vecs[i]);
            }
            return ret;
        }

        private class_241 lerp(class_241 min, class_241 max, class_241 vec) {
            return new class_241(Quad.lerp(min.field_1343, max.field_1343, vec.field_1343), Quad.lerp(min.field_1342, max.field_1342, vec.field_1342));
        }

        public int getQuadrant() {
            if (this.maxU <= 0.5f) {
                if (this.maxV <= 0.5f) {
                    return 3;
                }
                return 0;
            }
            if (this.maxV <= 0.5f) {
                return 2;
            }
            return 1;
        }

        public String toString() {
            return "Quad.UVs(minU=" + this.getMinU() + ", minV=" + this.getMinV() + ", maxU=" + this.getMaxU() + ", maxV=" + this.getMaxV() + ", sprite=" + this.getSprite() + ", data=" + Arrays.deepToString(this.data) + ")";
        }

        public float getMinU() {
            return this.minU;
        }

        public float getMinV() {
            return this.minV;
        }

        public float getMaxU() {
            return this.maxU;
        }

        public float getMaxV() {
            return this.maxV;
        }

        public class_1058 getSprite() {
            return this.sprite;
        }
    }

    public static final class Vertex {
        private final Vector3f pos;
        private final class_241 uvs;

        public Vertex(Vector3f pos, class_241 uvs) {
            this.pos = pos;
            this.uvs = uvs;
        }

        public Vector3f getPos() {
            return this.pos;
        }

        public class_241 getUvs() {
            return this.uvs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)o;
            Vector3f this$pos = this.getPos();
            Vector3f other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            class_241 this$uvs = this.getUvs();
            class_241 other$uvs = other.getUvs();
            return !(this$uvs == null ? other$uvs != null : !this$uvs.equals(other$uvs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Vector3f $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            class_241 $uvs = this.getUvs();
            result = result * 59 + ($uvs == null ? 43 : $uvs.hashCode());
            return result;
        }

        public String toString() {
            return "Quad.Vertex(pos=" + this.getPos() + ", uvs=" + this.getUvs() + ")";
        }
    }
}

