/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.lowdragmc.lowdraglib.client.bakedpipeline.QuadTransformers;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4609;
import net.minecraft.class_753;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_787;
import net.minecraft.class_789;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class FaceQuadBakery {
    public static final int VERTEX_INT_SIZE = 8;
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    public static final int VERTEX_COUNT = 4;
    private static final int COLOR_INDEX = 3;
    public static final int UV_INDEX = 4;

    public class_777 bakeQuad(Vector3f pPosFrom, Vector3f pPosTo, class_783 pFace, class_1058 pSprite, class_2350 pFacing, class_3665 pTransform, @Nullable class_789 pPartRotation, boolean pShade, int emissivity) {
        class_787 blockfaceuv = pFace.field_4227;
        if (pTransform.method_3512()) {
            blockfaceuv = FaceQuadBakery.recomputeUVs(pFace.field_4227, pFacing, pTransform.method_3509());
        }
        float[] afloat = new float[blockfaceuv.field_4235.length];
        System.arraycopy(blockfaceuv.field_4235, 0, afloat, 0, afloat.length);
        float f = pSprite.method_23842();
        float f1 = (blockfaceuv.field_4235[0] + blockfaceuv.field_4235[0] + blockfaceuv.field_4235[2] + blockfaceuv.field_4235[2]) / 4.0f;
        float f2 = (blockfaceuv.field_4235[1] + blockfaceuv.field_4235[1] + blockfaceuv.field_4235[3] + blockfaceuv.field_4235[3]) / 4.0f;
        blockfaceuv.field_4235[0] = class_3532.method_16439((float)f, (float)blockfaceuv.field_4235[0], (float)f1);
        blockfaceuv.field_4235[2] = class_3532.method_16439((float)f, (float)blockfaceuv.field_4235[2], (float)f1);
        blockfaceuv.field_4235[1] = class_3532.method_16439((float)f, (float)blockfaceuv.field_4235[1], (float)f2);
        blockfaceuv.field_4235[3] = class_3532.method_16439((float)f, (float)blockfaceuv.field_4235[3], (float)f2);
        int[] aint = this.makeVertices(blockfaceuv, pSprite, pFacing, this.setupShape(pPosFrom, pPosTo), pTransform.method_3509(), pPartRotation, pShade);
        class_2350 direction = FaceQuadBakery.calculateFacing(aint);
        System.arraycopy(afloat, 0, blockfaceuv.field_4235, 0, afloat.length);
        if (pPartRotation == null) {
            this.recalculateWinding(aint, direction);
        }
        FaceQuadBakery.fillNormal(aint, direction);
        class_777 quad = new class_777(aint, pFace.field_4226, direction, pSprite, pShade);
        QuadTransformers.settingEmissivity(emissivity).processInPlace(quad);
        return quad;
    }

    public static class_787 recomputeUVs(class_787 pUv, class_2350 pFacing, class_4590 pModelRotation) {
        float f11;
        float f10;
        float f9;
        float f8;
        Matrix4f matrix4f = class_4609.method_23221((class_4590)pModelRotation, (class_2350)pFacing, () -> "Unable to resolve UVLock for model").method_22936();
        float f = pUv.method_3415(pUv.method_3414(0));
        float f1 = pUv.method_3416(pUv.method_3414(0));
        Vector4f vector4f = new Vector4f(f / 16.0f, f1 / 16.0f, 0.0f, 1.0f);
        vector4f = matrix4f.transform(vector4f);
        float f2 = 16.0f * vector4f.x();
        float f3 = 16.0f * vector4f.y();
        float f4 = pUv.method_3415(pUv.method_3414(2));
        float f5 = pUv.method_3416(pUv.method_3414(2));
        Vector4f vector4f1 = new Vector4f(f4 / 16.0f, f5 / 16.0f, 0.0f, 1.0f);
        vector4f1 = matrix4f.transform(vector4f1);
        float f6 = 16.0f * vector4f1.x();
        float f7 = 16.0f * vector4f1.y();
        if (Math.signum(f4 - f) == Math.signum(f6 - f2)) {
            f8 = f2;
            f9 = f6;
        } else {
            f8 = f6;
            f9 = f2;
        }
        if (Math.signum(f5 - f1) == Math.signum(f7 - f3)) {
            f10 = f3;
            f11 = f7;
        } else {
            f10 = f7;
            f11 = f3;
        }
        float f12 = (float)Math.toRadians(pUv.field_4234);
        Vector3f vector3f = new Vector3f(class_3532.method_15362((float)f12), class_3532.method_15374((float)f12), 0.0f);
        Matrix3f matrix3f = new Matrix3f((Matrix4fc)matrix4f);
        vector3f = matrix3f.transform(vector3f);
        int i = Math.floorMod(-((int)Math.round(Math.toDegrees(Math.atan2(vector3f.y(), vector3f.x())) / 90.0)) * 90, 360);
        return new class_787(new float[]{f8, f10, f9, f11}, i);
    }

    private int[] makeVertices(class_787 pUvs, class_1058 pSprite, class_2350 pOrientation, float[] pPosDiv16, class_4590 pRotation, @Nullable class_789 pPartRotation, boolean pShade) {
        int[] aint = new int[32];
        for (int i = 0; i < 4; ++i) {
            this.bakeVertex(aint, i, pOrientation, pUvs, pPosDiv16, pSprite, pRotation, pPartRotation, pShade);
        }
        return aint;
    }

    private float[] setupShape(Vector3f pPos1, Vector3f pPos2) {
        float[] afloat = new float[class_2350.values().length];
        afloat[class_753.class_754.field_3967] = pPos1.x() / 16.0f;
        afloat[class_753.class_754.field_3968] = pPos1.y() / 16.0f;
        afloat[class_753.class_754.field_3969] = pPos1.z() / 16.0f;
        afloat[class_753.class_754.field_3970] = pPos2.x() / 16.0f;
        afloat[class_753.class_754.field_3971] = pPos2.y() / 16.0f;
        afloat[class_753.class_754.field_3972] = pPos2.z() / 16.0f;
        return afloat;
    }

    private void bakeVertex(int[] pVertexData, int pVertexIndex, class_2350 pFacing, class_787 pBlockFaceUV, float[] pPosDiv16, class_1058 pSprite, class_4590 pRotation, @Nullable class_789 pPartRotation, boolean pShade) {
        class_753.class_755 faceinfo$vertexinfo = class_753.method_3163((class_2350)pFacing).method_3162(pVertexIndex);
        Vector3f vector3f = new Vector3f(pPosDiv16[faceinfo$vertexinfo.field_3975], pPosDiv16[faceinfo$vertexinfo.field_3974], pPosDiv16[faceinfo$vertexinfo.field_3973]);
        this.applyElementRotation(vector3f, pPartRotation);
        this.applyModelRotation(vector3f, pRotation);
        this.fillVertex(pVertexData, pVertexIndex, vector3f, pSprite, pBlockFaceUV);
    }

    private void fillVertex(int[] pVertexData, int pVertexIndex, Vector3f pVector, class_1058 pSprite, class_787 pBlockFaceUV) {
        int i = pVertexIndex * 8;
        pVertexData[i] = Float.floatToRawIntBits(pVector.x());
        pVertexData[i + 1] = Float.floatToRawIntBits(pVector.y());
        pVertexData[i + 2] = Float.floatToRawIntBits(pVector.z());
        pVertexData[i + 3] = -1;
        pVertexData[i + 4] = Float.floatToRawIntBits(pSprite.method_4580((double)pBlockFaceUV.method_3415(pVertexIndex) * 0.999 + (double)pBlockFaceUV.method_3415((pVertexIndex + 2) % 4) * 0.001));
        pVertexData[i + 4 + 1] = Float.floatToRawIntBits(pSprite.method_4570((double)pBlockFaceUV.method_3416(pVertexIndex) * 0.999 + (double)pBlockFaceUV.method_3416((pVertexIndex + 2) % 4) * 0.001));
    }

    private void applyElementRotation(Vector3f pVec, @Nullable class_789 pPartRotation) {
        if (pPartRotation != null) {
            Vector3f vector3f;
            Vector3f vector3f1 = switch (pPartRotation.comp_1119()) {
                case class_2350.class_2351.field_11048 -> {
                    vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
                    yield new Vector3f(0.0f, 1.0f, 1.0f);
                }
                case class_2350.class_2351.field_11052 -> {
                    vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
                    yield new Vector3f(1.0f, 0.0f, 1.0f);
                }
                case class_2350.class_2351.field_11051 -> {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                    yield new Vector3f(1.0f, 1.0f, 0.0f);
                }
                default -> throw new IllegalArgumentException("There are only 3 axes");
            };
            Quaternionf quaternion = new Quaternionf().rotateAxis((float)Math.toRadians(pPartRotation.comp_1120()), (Vector3fc)vector3f);
            if (pPartRotation.comp_1121()) {
                if (Math.abs(pPartRotation.comp_1120()) == 22.5f) {
                    vector3f1.mul(RESCALE_22_5);
                } else {
                    vector3f1.mul(RESCALE_45);
                }
                vector3f1.add(1.0f, 1.0f, 1.0f);
            } else {
                vector3f1.set(1.0f, 1.0f, 1.0f);
            }
            this.rotateVertexBy(pVec, new Vector3f((Vector3fc)pPartRotation.comp_1118()), new Matrix4f().rotate((Quaternionfc)quaternion), vector3f1);
        }
    }

    public void applyModelRotation(Vector3f pPos, class_4590 pTransform) {
        if (pTransform != class_4590.method_22931()) {
            this.rotateVertexBy(pPos, new Vector3f(0.5f, 0.5f, 0.5f), pTransform.method_22936(), new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    private void rotateVertexBy(Vector3f pPos, Vector3f pOrigin, Matrix4f pTransform, Vector3f pScale) {
        Vector4f vector4f = new Vector4f(pPos.x() - pOrigin.x(), pPos.y() - pOrigin.y(), pPos.z() - pOrigin.z(), 1.0f);
        vector4f = pTransform.transform(vector4f);
        vector4f.mul(pScale.x, pScale.y, pScale.z, 1.0f);
        pPos.set(vector4f.x() + pOrigin.x(), vector4f.y() + pOrigin.y(), vector4f.z() + pOrigin.z());
    }

    public static class_2350 calculateFacing(int[] pFaceData) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(pFaceData[0]), Float.intBitsToFloat(pFaceData[1]), Float.intBitsToFloat(pFaceData[2]));
        Vector3f vector3f1 = new Vector3f(Float.intBitsToFloat(pFaceData[8]), Float.intBitsToFloat(pFaceData[9]), Float.intBitsToFloat(pFaceData[10]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(pFaceData[16]), Float.intBitsToFloat(pFaceData[17]), Float.intBitsToFloat(pFaceData[18]));
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f);
        vector3f3.sub((Vector3fc)vector3f1);
        Vector3f vector3f4 = new Vector3f((Vector3fc)vector3f2);
        vector3f4.sub((Vector3fc)vector3f1);
        Vector3f vector3f5 = new Vector3f((Vector3fc)vector3f4);
        vector3f5.cross((Vector3fc)vector3f3);
        vector3f5.normalize();
        class_2350 direction = null;
        float f = 0.0f;
        for (class_2350 direction1 : class_2350.values()) {
            class_2382 vec3i = direction1.method_10163();
            Vector3f vector3f6 = new Vector3f((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260());
            float f1 = vector3f5.dot((Vector3fc)vector3f6);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction == null ? class_2350.field_11036 : direction;
    }

    private void recalculateWinding(int[] pVertices, class_2350 pDirection) {
        int[] aint = new int[pVertices.length];
        System.arraycopy(pVertices, 0, aint, 0, pVertices.length);
        float[] afloat = new float[class_2350.values().length];
        afloat[class_753.class_754.field_3967] = 999.0f;
        afloat[class_753.class_754.field_3968] = 999.0f;
        afloat[class_753.class_754.field_3969] = 999.0f;
        afloat[class_753.class_754.field_3970] = -999.0f;
        afloat[class_753.class_754.field_3971] = -999.0f;
        afloat[class_753.class_754.field_3972] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 8 * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[class_753.class_754.field_3967]) {
                afloat[class_753.class_754.field_3967] = f;
            }
            if (f1 < afloat[class_753.class_754.field_3968]) {
                afloat[class_753.class_754.field_3968] = f1;
            }
            if (f2 < afloat[class_753.class_754.field_3969]) {
                afloat[class_753.class_754.field_3969] = f2;
            }
            if (f > afloat[class_753.class_754.field_3970]) {
                afloat[class_753.class_754.field_3970] = f;
            }
            if (f1 > afloat[class_753.class_754.field_3971]) {
                afloat[class_753.class_754.field_3971] = f1;
            }
            if (!(f2 > afloat[class_753.class_754.field_3972])) continue;
            afloat[class_753.class_754.field_3972] = f2;
        }
        class_753 faceinfo = class_753.method_3163((class_2350)pDirection);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 8 * i1;
            class_753.class_755 faceinfo$vertexinfo = faceinfo.method_3162(i1);
            float f8 = afloat[faceinfo$vertexinfo.field_3975];
            float f3 = afloat[faceinfo$vertexinfo.field_3974];
            float f4 = afloat[faceinfo$vertexinfo.field_3973];
            pVertices[j1] = Float.floatToRawIntBits(f8);
            pVertices[j1 + 1] = Float.floatToRawIntBits(f3);
            pVertices[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 8 * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!class_3532.method_15347((float)f8, (float)f5) || !class_3532.method_15347((float)f3, (float)f6) || !class_3532.method_15347((float)f4, (float)f7)) continue;
                pVertices[j1 + 4] = aint[l + 4];
                pVertices[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }

    public static void fillNormal(int[] faceData, class_2350 facing) {
        Vector3f v1 = FaceQuadBakery.getVertexPos(faceData, 3);
        Vector3f t1 = FaceQuadBakery.getVertexPos(faceData, 1);
        Vector3f v2 = FaceQuadBakery.getVertexPos(faceData, 2);
        Vector3f t2 = FaceQuadBakery.getVertexPos(faceData, 0);
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        int x = (byte)Math.round(v2.x() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.y() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.z() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 8 + 7] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 8;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }
}

