/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib;

import com.lowdragmc.lowdraglib.gui.factory.UIEditorFactory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class ServerCommands {
    public static List<LiteralArgumentBuilder<class_2168>> createServerCommands() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ldlib").then(class_2170.method_9247((String)"ui_editor").executes(context -> {
            UIEditorFactory.INSTANCE.openUI(UIEditorFactory.INSTANCE, ((class_2168)context.getSource()).method_9207());
            return 1;
        }))).then(class_2170.method_9247((String)"copy_block_tag").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos = class_2262.method_9696((CommandContext)context, (String)"pos");
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null) {
                class_2487 tag = blockEntity.method_38244();
                String value = class_2512.method_32271((class_2487)tag);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"[Copy to clipboard]").method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_21462, value))).method_10852(class_2512.method_32270((class_2520)tag)), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("No block entity at " + pos)).method_27696(class_2583.field_24360.method_10977(class_124.field_1061)), true);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"copy_entity_tag").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            class_2487 tag = entity.method_5647(new class_2487());
            String value = class_2512.method_32271((class_2487)tag);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"[Copy to clipboard]").method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_21462, value))).method_10852(class_2512.method_32270((class_2520)tag)), true);
            return 1;
        }))), (LiteralArgumentBuilder)class_2170.method_9247((String)"compass_server").then(class_2170.method_9247((String)"build_scene").then(class_2170.method_9244((String)"start", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"end", (ArgumentType)class_2262.method_9698()).executes(context -> ServerCommands.runBuildScene((CommandContext<class_2168>)context, false, new class_2338(0, 0, 0)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"saveNbt", (ArgumentType)BoolArgumentType.bool()).executes(context -> ServerCommands.runBuildScene((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"saveNbt"), new class_2338(0, 0, 0)))).then(class_2170.method_9244((String)"offset", (ArgumentType)class_2262.method_9698()).executes(context -> ServerCommands.runBuildScene((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"saveNbt"), class_2262.method_48299((CommandContext)context, (String)"offset")))))))));
    }

    public static int runBuildScene(CommandContext<class_2168> context, boolean saveNbt, class_2338 offset) {
        class_2338 start = class_2262.method_48299(context, (String)"start");
        class_2338 end = class_2262.method_48299(context, (String)"end");
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        int smallestX = start.method_10263() <= end.method_10263() ? start.method_10263() : end.method_10263();
        int smallestY = start.method_10264() <= end.method_10264() ? start.method_10264() : end.method_10264();
        int smallestZ = start.method_10260() <= end.method_10260() ? start.method_10260() : end.method_10260();
        int largestX = start.method_10263() >= end.method_10263() ? start.method_10263() : end.method_10263();
        int largestY = start.method_10264() >= end.method_10264() ? start.method_10264() : end.method_10264();
        int largestZ = start.method_10260() >= end.method_10260() ? start.method_10260() : end.method_10260();
        int offsetX = -((largestX - smallestX) / 2) + offset.method_10263();
        int offsetY = offset.method_10264();
        int offsetZ = -((largestZ - smallestZ) / 2) + offset.method_10260();
        ArrayList<String> nodes = new ArrayList<String>();
        for (int x = smallestX; x <= largestX; ++x) {
            for (int y = smallestY; y <= largestY; ++y) {
                for (int z = smallestZ; z <= largestZ; ++z) {
                    class_2680 block = world.method_8320(new class_2338(x, y, z));
                    class_2586 blockentity = world.method_8321(new class_2338(x, y, z));
                    if (block.method_26204() == class_2246.field_10124) continue;
                    String id = class_7923.field_41175.method_10221((Object)block.method_26204()).toString();
                    nodes.add(String.format("<add pos=\"%d %d %d\" block=\"%s\">", x - smallestX + offsetX, y - smallestY + offsetY, z - smallestZ + offsetZ, id));
                    nodes.addAll(block.method_11656().entrySet().stream().map(e -> String.format("<properties name=\"%s\" value=\"%s\" />", ((class_2769)e.getKey()).method_11899(), ((Comparable)e.getValue()).toString())).collect(Collectors.toList()));
                    if (saveNbt && blockentity != null) {
                        class_2487 tag = blockentity.method_38244();
                        nodes.add("<nbt>");
                        nodes.add(class_2512.method_32270((class_2520)tag).getString());
                        nodes.add("</nbt>");
                    }
                    nodes.add("</add>");
                }
            }
        }
        String text = nodes.stream().collect(Collectors.joining("\n"));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"[Copy XML to clipboard]").method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_21462, text))), true);
        return 1;
    }
}

