/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.GeometryTools;
import mcjty.lostcities.varia.NoiseGeneratorPerlin;
import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.ChunkFixer;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.DummyChunk;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.DamageArea;
import mcjty.lostcities.worldgen.lost.Direction;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Orientation;
import mcjty.lostcities.worldgen.lost.Railway;
import mcjty.lostcities.worldgen.lost.Transform;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.Condition;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import mcjty.lostcities.worldgen.lost.cityassets.IBuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class LostCityTerrainFeature {
    private static int gSeed = 123456789;
    private final int mainGroundLevel;
    private boolean statesSetup = false;
    public static BlockState air;
    public static BlockState hardAir;
    public static BlockState glowstone;
    public static BlockState gravel;
    public static BlockState glass;
    public static BlockState leaves;
    public static BlockState leaves2;
    public static BlockState leaves3;
    public static BlockState ironbars;
    public static BlockState grass;
    public static BlockState bedrock;
    public static BlockState endportal;
    public static BlockState endportalFrame;
    public static BlockState goldBlock;
    public static BlockState diamondBlock;
    public BlockState liquid;
    public BlockState base;
    private static Set<BlockState> rotatableStates;
    private static Set<BlockState> railStates;
    private static Set<BlockState> glassStates;
    private static Set<BlockState> statesNeedingTodo;
    private static Set<BlockState> statesNeedingLightingUpdate;
    private BlockState street;
    private BlockState streetBase;
    private BlockState street2;
    private int streetBorder;
    private NoiseGeneratorPerlin rubbleNoise;
    private NoiseGeneratorPerlin leavesNoise;
    private NoiseGeneratorPerlin ruinNoise;
    private static BlockState[] randomLeafs;
    private ChunkDriver driver;
    private final IDimensionInfo provider;
    private final LostCityProfile profile;
    private final Random rand;
    private final Integer[] mm00 = new Integer[2];
    private final Integer[] mm10 = new Integer[2];
    private final Integer[] mm01 = new Integer[2];
    private final Integer[] mm11 = new Integer[2];
    private Map<ChunkCoord, ChunkHeightmap> cachedHeightmaps = new HashMap<ChunkCoord, ChunkHeightmap>();
    private double[] rubbleBuffer = new double[256];
    private double[] leavesBuffer = new double[256];
    private double[] ruinBuffer = new double[256];

    public LostCityTerrainFeature(IDimensionInfo provider, LostCityProfile profile, Random rand) {
        this.provider = provider;
        this.profile = profile;
        this.rand = rand;
        this.driver = new ChunkDriver();
        this.mainGroundLevel = profile.GROUNDLEVEL;
        int waterLevel = provider.getWorld() == null ? 65 : provider.getWorld().func_181545_F();
        this.rubbleNoise = new NoiseGeneratorPerlin(rand, 4);
        this.leavesNoise = new NoiseGeneratorPerlin(rand, 4);
        this.ruinNoise = new NoiseGeneratorPerlin(rand, 4);
    }

    public static BlockState getRandomLeaf() {
        if (randomLeafs == null) {
            int i;
            randomLeafs = new BlockState[128];
            for (i = 0; i < 20; ++i) {
                LostCityTerrainFeature.randomLeafs[i] = leaves2;
            }
            while (i < 40) {
                LostCityTerrainFeature.randomLeafs[i] = leaves3;
                ++i;
            }
            while (i < randomLeafs.length) {
                LostCityTerrainFeature.randomLeafs[i] = leaves;
                ++i;
            }
        }
        return randomLeafs[LostCityTerrainFeature.fastrand128()];
    }

    public static Set<BlockState> getRailStates() {
        if (railStates == null) {
            railStates = new HashSet<BlockState>();
            LostCityTerrainFeature.addStates(Blocks.field_150448_aq, railStates);
            LostCityTerrainFeature.addStates(Blocks.field_196552_aC, railStates);
        }
        return railStates;
    }

    public static Set<BlockState> getGlassStates() {
        if (glassStates == null) {
            glassStates = new HashSet<BlockState>();
            for (Block block : Tags.Blocks.GLASS.func_230236_b_()) {
                LostCityTerrainFeature.addStates(block, glassStates);
            }
            for (Block block : Tags.Blocks.STAINED_GLASS.func_230236_b_()) {
                LostCityTerrainFeature.addStates(block, glassStates);
            }
            for (Block block : Tags.Blocks.GLASS_PANES.func_230236_b_()) {
                LostCityTerrainFeature.addStates(block, glassStates);
            }
            for (Block block : Tags.Blocks.STAINED_GLASS_PANES.func_230236_b_()) {
                LostCityTerrainFeature.addStates(block, glassStates);
            }
        }
        return glassStates;
    }

    public static Set<BlockState> getStatesNeedingTodo() {
        if (statesNeedingTodo == null) {
            statesNeedingTodo = new HashSet<BlockState>();
            for (Block block : BlockTags.field_200030_g.func_230236_b_()) {
                LostCityTerrainFeature.addStates(block, statesNeedingTodo);
            }
            for (Block block : BlockTags.field_219746_E.func_230236_b_()) {
                LostCityTerrainFeature.addStates(block, statesNeedingTodo);
            }
        }
        return statesNeedingTodo;
    }

    public static Set<BlockState> getStatesNeedingLightingUpdate() {
        if (statesNeedingLightingUpdate == null) {
            statesNeedingLightingUpdate = new HashSet<BlockState>();
            for (String s : LostCityConfiguration.BLOCKS_REQUIRING_LIGHTING_UPDATES) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null) continue;
                LostCityTerrainFeature.addStates(block, statesNeedingLightingUpdate);
            }
        }
        return statesNeedingLightingUpdate;
    }

    public static Set<BlockState> getRotatableStates() {
        if (rotatableStates == null) {
            rotatableStates = new HashSet<BlockState>();
            LostCityTerrainFeature.addStates(Blocks.field_150400_ck, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150487_bG, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150389_bf, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150370_cb, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150390_bg, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150401_cl, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150481_bH, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150387_bl, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150476_ad, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_185769_cV, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_180396_cN, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150372_bz, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150485_bF, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_222438_lb, rotatableStates);
            LostCityTerrainFeature.addStates(Blocks.field_150468_ap, rotatableStates);
        }
        return rotatableStates;
    }

    private static void addStates(Block block, Set<BlockState> set) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            set.add(state);
        }
    }

    public void setupStates(LostCityProfile profile) {
        if (!this.statesSetup) {
            air = Blocks.field_150350_a.func_176223_P();
            hardAir = Blocks.field_150483_bI.func_176223_P();
            glowstone = Blocks.field_150426_aN.func_176223_P();
            gravel = Blocks.field_150351_n.func_176223_P();
            this.base = profile.getBaseBlock();
            this.liquid = profile.getLiquidBlock();
            glass = Blocks.field_150359_w.func_176223_P();
            leaves = (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
            leaves2 = (BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
            leaves3 = (BlockState)Blocks.field_196645_X.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
            ironbars = Blocks.field_150411_aY.func_176223_P();
            grass = Blocks.field_196658_i.func_176223_P();
            bedrock = Blocks.field_150357_h.func_176223_P();
            endportal = Blocks.field_150384_bq.func_176223_P();
            endportalFrame = Blocks.field_150378_br.func_176223_P();
            goldBlock = Blocks.field_150340_R.func_176223_P();
            diamondBlock = Blocks.field_150484_ah.func_176223_P();
            this.statesSetup = true;
        }
    }

    private static int fastrand() {
        gSeed = 214013 * gSeed + 2531011;
        return gSeed >> 16 & Short.MAX_VALUE;
    }

    public static int fastrand128() {
        gSeed = 214013 * gSeed + 2531011;
        return gSeed >> 16 & 0x7F;
    }

    public void generateDummy(WorldGenRegion region, IChunk chunk) {
        WorldGenRegion oldRegion = this.driver.getRegion();
        IChunk oldChunk = this.driver.getPrimer();
        this.driver.setPrimer(region, chunk);
        this.street = Blocks.field_196696_di.func_176223_P();
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.provider);
        ChunkHeightmap heightmap = this.getHeightmap(chunkX, chunkZ, (ISeedReader)region);
        Random r = new Random((long)chunkX * 257017164707L + (long)chunkZ * 101754694003L);
        r.nextFloat();
        if ((double)r.nextFloat() < 0.4) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.driver.current(x, 30, z);
                    for (int height = r.nextInt(50) + 30; height > 0; --height) {
                        if ((double)r.nextFloat() < 0.01) {
                            this.driver.add(glowstone);
                            continue;
                        }
                        this.driver.add(this.street);
                    }
                }
            }
        } else if ((double)r.nextFloat() < 0.4) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.driver.current(x, 30, z);
                    for (int height = r.nextInt(50) + 30; height > 0; --height) {
                        if ((double)r.nextFloat() < 0.01) {
                            this.driver.add(glowstone);
                            continue;
                        }
                        this.driver.add(air);
                    }
                }
            }
        }
        this.driver.setPrimer(oldRegion, oldChunk);
    }

    private boolean isVoid(int x, int z) {
        this.driver.current(x, 255, z);
        while (this.driver.getBlock() == air && this.driver.getY() > 0) {
            this.driver.decY();
        }
        return this.driver.getY() == 0;
    }

    public void generate(WorldGenRegion region, IChunk chunk) {
        boolean doCity;
        WorldGenRegion oldRegion = this.driver.getRegion();
        IChunk oldChunk = this.driver.getPrimer();
        this.driver.setPrimer(region, chunk);
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.provider);
        CityStyle cityStyle = info.getCityStyle();
        this.street = info.getCompiledPalette().get(cityStyle.getStreetBlock().charValue());
        this.streetBase = info.getCompiledPalette().get(cityStyle.getStreetBaseBlock().charValue());
        this.street2 = info.getCompiledPalette().get(cityStyle.getStreetVariantBlock().charValue());
        this.streetBorder = (16 - cityStyle.getStreetWidth()) / 2;
        boolean bl = doCity = info.isCity || info.outsideChunk && info.hasBuilding;
        if (doCity && this.provider.getProfile().CITY_AVOID_VOID && this.provider.getProfile().isFloating()) {
            boolean v = this.isVoid(2, 2) || this.isVoid(2, 14) || this.isVoid(14, 2) || this.isVoid(14, 14) || this.isVoid(8, 8);
            boolean bl2 = doCity = !v;
        }
        if (doCity) {
            this.doCityChunk(chunkX, chunkZ, info);
        } else {
            this.doNormalChunk(chunkX, chunkZ, info);
        }
        Railway.RailChunkInfo railInfo = info.getRailInfo();
        if (railInfo.getType() != RailChunkType.NONE) {
            this.generateRailways(info, railInfo);
        }
        this.generateRailwayDungeons(info);
        if (this.profile.isSpace()) {
            this.generateMonorails(info);
        }
        this.fixTorches(info);
        this.rand.setSeed((long)chunkX * 257017164707L + (long)chunkZ * 101754694003L);
        if (info.getDamageArea().hasExplosions()) {
            this.breakBlocksForDamage(chunkX, chunkZ, info);
            this.fixAfterExplosionNew(info, this.rand);
        }
        this.generateDebris(this.rand, info);
        ChunkFixer.fix(this.provider, chunkX, chunkZ);
        this.driver.setPrimer(oldRegion, oldChunk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateMonorails(BuildingInfo info) {
        BuildingPart part;
        Transform transform;
        boolean horiz = info.hasHorizontalMonorail();
        boolean vert = info.hasVerticalMonorail();
        if (horiz && vert) {
            if (CitySphere.intersectsWithCitySphere(info.chunkX, info.chunkZ, this.provider)) return;
            BuildingPart part2 = AssetRegistries.PARTS.get("monorails_both");
            this.generatePart(info, part2, Transform.ROTATE_NONE, 0, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, 0, true);
            return;
        }
        if (horiz) {
            transform = Transform.ROTATE_90;
        } else {
            if (!vert) return;
            transform = Transform.ROTATE_NONE;
        }
        if (CitySphere.fullyInsideCitySpere(info.chunkX, info.chunkZ, this.provider)) {
            if (this.hasNonStationMonoRail(info.getXmin())) {
                part = AssetRegistries.PARTS.get("monorails_station");
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.MIRROR_90_X;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else if (this.hasNonStationMonoRail(info.getXmax())) {
                part = AssetRegistries.PARTS.get("monorails_station");
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.ROTATE_90;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else if (this.hasNonStationMonoRail(info.getZmin())) {
                part = AssetRegistries.PARTS.get("monorails_station");
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.ROTATE_NONE;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else {
                if (!this.hasNonStationMonoRail(info.getZmax())) return;
                part = AssetRegistries.PARTS.get("monorails_station");
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.MIRROR_Z;
                this.fillToGround(info, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            }
        } else {
            part = AssetRegistries.PARTS.get("monorails_vertical");
        }
        this.generatePart(info, part, transform, 0, this.mainGroundLevel + info.profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, 0, true);
    }

    private boolean hasNonStationMonoRail(BuildingInfo info) {
        return info.hasMonorail() && !CitySphere.fullyInsideCitySpere(info.chunkX, info.chunkZ, this.provider);
    }

    private void fixTorches(BuildingInfo info) {
        List<BlockPos> torches = info.getTorchTodo();
        if (torches.isEmpty()) {
            return;
        }
        for (BlockPos idx : torches) {
            this.driver.current(idx);
            BlockState torchState = Blocks.field_196591_bQ.func_176223_P();
            int x = this.driver.getX();
            int z = this.driver.getZ();
            if (this.driver.getBlockDown() != air) {
                this.driver.block(Blocks.field_150478_aa.func_176223_P());
                continue;
            }
            if (x > 0 && this.driver.getBlockWest() != air) {
                this.driver.block((BlockState)torchState.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)net.minecraft.util.Direction.EAST));
                continue;
            }
            if (x < 15 && this.driver.getBlockEast() != air) {
                this.driver.block((BlockState)torchState.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)net.minecraft.util.Direction.WEST));
                continue;
            }
            if (z > 0 && this.driver.getBlockNorth() != air) {
                this.driver.block((BlockState)torchState.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)net.minecraft.util.Direction.SOUTH));
                continue;
            }
            if (z >= 15 || this.driver.getBlockSouth() == air) continue;
            this.driver.block((BlockState)torchState.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)net.minecraft.util.Direction.NORTH));
        }
        info.clearTorchTodo();
    }

    private void doNormalChunk(int chunkX, int chunkZ, BuildingInfo info) {
        if (info.profile.isDefault()) {
            this.correctTerrainShape(chunkX, chunkZ);
        }
        this.generateBridges(info);
        this.generateHighways(chunkX, chunkZ, info);
    }

    private void breakBlocksForDamage(int chunkX, int chunkZ, BuildingInfo info) {
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        DamageArea damageArea = info.getDamageArea();
        boolean clear = false;
        float damageFactor = 1.0f;
        for (int yy = 0; yy < 16; ++yy) {
            if (!clear && !damageArea.hasExplosions(yy)) continue;
            if (clear || damageArea.isCompletelyDestroyed(yy)) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int height = yy * 16;
                        this.driver.current(x, height, z);
                        for (int y = 0; y < 16; ++y) {
                        }
                    }
                }
                clear = true;
                continue;
            }
            for (int y = 0; y < 16; ++y) {
                int cntDamaged = 0;
                int cntAir = 0;
                int cury = yy * 16 + y;
                for (int x = 0; x < 16; ++x) {
                    this.driver.current(x, cury, 0);
                    for (int z = 0; z < 16; ++z) {
                        BlockState d = this.driver.getBlock();
                        if (d != air || cury <= info.waterLevel) {
                            BlockState newd;
                            float damage = damageArea.getDamage(cx + x, cury, cz + z) * damageFactor;
                            if ((double)damage >= 0.001 && (newd = damageArea.damageBlock(d, this.provider, cury, damage, info.getCompiledPalette(), this.liquid)) != d) {
                                this.driver.block(newd);
                                ++cntDamaged;
                            }
                        } else {
                            ++cntAir;
                        }
                        this.driver.incZ();
                    }
                }
                int tot = cntDamaged + cntAir;
                if (tot > 250) {
                    damageFactor = 200.0f;
                    clear = true;
                    continue;
                }
                if (tot > 220) {
                    damageFactor *= 1.4f;
                    continue;
                }
                if (tot <= 180) continue;
                damageFactor *= 1.2f;
            }
        }
    }

    private void generateHighways(int chunkX, int chunkZ, BuildingInfo info) {
        int levelZ;
        int levelX = Highway.getXHighwayLevel(chunkX, chunkZ, this.provider, info.profile);
        if (levelX == (levelZ = Highway.getZHighwayLevel(chunkX, chunkZ, this.provider, info.profile)) && levelX >= 0) {
            this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getXmax(), info.getZmax(), "_bi");
        } else if (levelX >= 0 && levelZ >= 0) {
            if (levelX == 0) {
                this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), "");
                this.generateHighwayPart(info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), "");
            } else {
                this.generateHighwayPart(info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), "");
                this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), "");
            }
        } else if (levelX >= 0) {
            this.generateHighwayPart(info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), "");
        } else if (levelZ >= 0) {
            this.generateHighwayPart(info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), "");
        }
    }

    private static boolean isClearableAboveHighway(BlockState st) {
        return !st.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) && !st.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h);
    }

    private void generateHighwayPart(BuildingInfo info, int level, Transform transform, BuildingInfo adjacent1, BuildingInfo adjacent2, String suffix) {
        int z;
        int x;
        int clearheight;
        int height;
        BuildingPart part;
        int highwayGroundLevel = info.groundLevel + level * 6;
        if (info.isTunnel(level)) {
            part = AssetRegistries.PARTS.get("highway_tunnel" + suffix);
            this.generatePart(info, part, transform, 0, highwayGroundLevel, 0, true);
        } else if (info.isCity && level <= adjacent1.cityLevel && level <= adjacent2.cityLevel && adjacent1.isCity && adjacent2.isCity) {
            part = AssetRegistries.PARTS.get("highway_open" + suffix);
            height = this.generatePart(info, part, transform, 0, highwayGroundLevel, 0, true);
            if (!info.profile.isCavern()) {
                clearheight = 15;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        this.clearRange(info, x, z, height, height + clearheight, info.waterLevel > info.groundLevel, LostCityTerrainFeature::isClearableAboveHighway);
                    }
                }
            }
        } else {
            part = AssetRegistries.PARTS.get("highway_bridge" + suffix);
            height = this.generatePart(info, part, transform, 0, highwayGroundLevel, 0, true);
            if (!info.profile.isCavern()) {
                clearheight = 15;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        this.clearRange(info, x, z, height, height + clearheight, info.waterLevel > info.groundLevel, LostCityTerrainFeature::isClearableAboveHighway);
                    }
                }
            }
        }
        Character support = part.getMetaChar("support");
        if (info.profile.HIGHWAY_SUPPORTS && support != null) {
            BlockState sup = info.getCompiledPalette().get(support.charValue());
            int x1 = transform.rotateX(0, 15);
            int z1 = transform.rotateZ(0, 15);
            this.driver.current(x1, highwayGroundLevel - 1, z1);
            for (int y = 0; y < 40 && LostCityTerrainFeature.isEmpty(this.driver.getBlock()); ++y) {
                this.driver.block(sup);
                this.driver.decY();
            }
            int x2 = transform.rotateX(0, 0);
            int z2 = transform.rotateZ(0, 0);
            this.driver.current(x2, highwayGroundLevel - 1, z2);
            for (int y = 0; y < 40 && LostCityTerrainFeature.isEmpty(this.driver.getBlock()); ++y) {
                this.driver.block(sup);
                this.driver.decY();
            }
        }
    }

    private void clearRange(BuildingInfo info, int x, int z, int height1, int height2, boolean dowater) {
        if (dowater) {
            this.driver.setBlockRangeSafe(x, height1, z, info.waterLevel, this.liquid);
            this.driver.setBlockRangeSafe(x, info.waterLevel + 1, z, height2, air);
        } else {
            this.driver.setBlockRange(x, height1, z, height2, air);
        }
    }

    private void clearRange(BuildingInfo info, int x, int z, int height1, int height2, boolean dowater, Predicate<BlockState> test) {
        if (dowater) {
            this.driver.setBlockRangeSafe(x, height1, z, info.waterLevel, this.liquid, test);
            this.driver.setBlockRangeSafe(x, info.waterLevel + 1, z, height2, air, test);
        } else {
            this.driver.setBlockRange(x, height1, z, height2, air, test);
        }
    }

    private void generateBridges(BuildingInfo info) {
        if (info.getHighwayXLevel() == 0 || info.getHighwayZLevel() == 0) {
            return;
        }
        BuildingPart bt = info.hasXBridge(this.provider);
        if (bt != null) {
            this.generateBridge(info, bt, Orientation.X);
        } else {
            bt = info.hasZBridge(this.provider);
            if (bt != null) {
                this.generateBridge(info, bt, Orientation.Z);
            }
        }
    }

    private void generateBridge(BuildingInfo info, BuildingPart bt, Orientation orientation) {
        block18: {
            CompiledPalette compiledPalette = info.getCompiledPalette();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.driver.current(x, this.mainGroundLevel + 1, z);
                    for (int l = 0; l < bt.getSliceCount(); ++l) {
                        Character c = orientation == Orientation.X ? bt.getPaletteChar(x, l, z) : bt.getPaletteChar(z, l, x);
                        BlockState b = info.getCompiledPalette().get(c.charValue());
                        CompiledPalette.Info inf = compiledPalette.getInfo(c);
                        if (inf != null && inf.isTorch()) {
                            if (info.profile.GENERATE_LIGHTING) {
                                info.addTorchTodo(this.driver.getCurrentCopy());
                            } else {
                                b = air;
                            }
                        }
                        this.driver.add(b);
                    }
                }
            }
            Character support = bt.getMetaChar("support");
            if (!info.profile.BRIDGE_SUPPORTS || support == null) break block18;
            BlockState sup = compiledPalette.get(support.charValue());
            BuildingInfo minDir = orientation.getMinDir().get(info);
            BuildingInfo maxDir = orientation.getMaxDir().get(info);
            if (minDir.hasBridge(this.provider, orientation) != null && maxDir.hasBridge(this.provider, orientation) != null) {
                for (int y = info.waterLevel - 10; y <= info.groundLevel; ++y) {
                    this.driver.current(7, y, 7).block(sup);
                    this.driver.current(7, y, 8).block(sup);
                    this.driver.current(8, y, 7).block(sup);
                    this.driver.current(8, y, 8).block(sup);
                }
            }
            if (minDir.hasBridge(this.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x = 0;
                    this.driver.current(x, this.mainGroundLevel, 6);
                    for (int z = 6; z <= 9; ++z) {
                        this.driver.block(sup).incZ();
                    }
                } else {
                    int z = 0;
                    this.driver.current(6, this.mainGroundLevel, z);
                    for (int x = 6; x <= 9; ++x) {
                        this.driver.block(sup).incX();
                    }
                }
            }
            if (maxDir.hasBridge(this.provider, orientation) == null) {
                if (orientation == Orientation.X) {
                    int x = 15;
                    this.driver.current(x, this.mainGroundLevel, 6);
                    for (int z = 6; z <= 9; ++z) {
                        this.driver.block(sup).incZ();
                    }
                } else {
                    int z = 15;
                    this.driver.current(6, this.mainGroundLevel, z);
                    for (int x = 6; x <= 9; ++x) {
                        this.driver.block(sup).incX();
                    }
                }
            }
        }
    }

    public static int getRandomizedOffset(int chunkX, int chunkZ, int min, int max) {
        Random rand = new Random((long)chunkZ * 256203221L + (long)chunkX * 899809363L);
        rand.nextFloat();
        return rand.nextInt(max - min + 1) + min;
    }

    public static int getHeightOffsetL1(int chunkX, int chunkZ) {
        Random rand = new Random((long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        rand.nextFloat();
        return rand.nextInt(5);
    }

    public static int getHeightOffsetL2(int chunkX, int chunkZ) {
        Random rand = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        rand.nextFloat();
        return rand.nextInt(5);
    }

    @Deprecated
    private int getHeightAt00Corner(BuildingInfo info) {
        int h = this.getHeightForChunk(info);
        h = Math.min(h, this.getHeightForChunk(info.getXmin()));
        h = Math.min(h, this.getHeightForChunk(info.getZmin()));
        h = Math.min(h, this.getHeightForChunk(info.getXmin().getZmin()));
        return h;
    }

    @Deprecated
    private int getHeightForChunk(BuildingInfo info) {
        if (info.isCity) {
            return info.getCityGroundLevel();
        }
        if (info.isOcean()) {
            return info.groundLevel - 4;
        }
        return info.getCityGroundLevel();
    }

    private synchronized void correctTerrainShape(int chunkX, int chunkZ) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.provider);
        Integer[] mm00 = info.getDesiredMaxHeightL2();
        Integer[] mm10 = info.getXmax().getDesiredMaxHeightL2();
        Integer[] mm01 = info.getZmax().getDesiredMaxHeightL2();
        Integer[] mm11 = info.getXmax().getZmax().getDesiredMaxHeightL2();
        float min00 = mm00[0].intValue();
        float min10 = mm10[0].intValue();
        float min01 = mm01[0].intValue();
        float min11 = mm11[0].intValue();
        float max00 = mm00[1].intValue();
        float max10 = mm10[1].intValue();
        float max01 = mm01[1].intValue();
        float max11 = mm11[1].intValue();
        if (max00 < 256.0f || max10 < 256.0f || max01 < 256.0f || max11 < 256.0f || min00 < 256.0f || min10 < 256.0f || min01 < 256.0f || min11 < 256.0f) {
            ChunkHeightmap heightmap = this.getHeightmap(chunkX, chunkZ, this.provider.getWorld());
            int maxHeightP = heightmap.getMaximumHeight() + 10;
            int minHeightP = heightmap.getMinimumHeight() - 10;
            if (max00 >= 256.0f) {
                max00 = maxHeightP;
            }
            if (max10 >= 256.0f) {
                max10 = maxHeightP;
            }
            if (max01 >= 256.0f) {
                max01 = maxHeightP;
            }
            if (max11 >= 256.0f) {
                max11 = maxHeightP;
            }
            if (min00 >= 256.0f) {
                min00 = minHeightP;
            }
            if (min10 >= 256.0f) {
                min10 = minHeightP;
            }
            if (min01 >= 256.0f) {
                min01 = minHeightP;
            }
            if (min11 >= 256.0f) {
                min11 = minHeightP;
            }
            for (int x = 0; x < 16; ++x) {
                float factor = (15.0f - (float)x) / 15.0f;
                float maxh0 = max11 + (max01 - max11) * factor;
                float maxh1 = max10 + (max00 - max10) * factor;
                float minh0 = min11 + (min01 - min11) * factor;
                float minh1 = min10 + (min00 - min10) * factor;
                for (int z = 0; z < 16; ++z) {
                    float maxheight = maxh0 + (maxh1 - maxh0) * (15.0f - (float)z) / 15.0f;
                    boolean moved = this.moveDown(info, x, z, (int)maxheight, info.waterLevel > info.groundLevel);
                    if (moved) continue;
                    float minheight = minh0 + (minh1 - minh0) * (15.0f - (float)z) / 15.0f;
                    this.moveUp(info, x, z, (int)minheight, info.waterLevel > info.groundLevel);
                }
            }
        }
    }

    private static boolean isEmpty(BlockState state) {
        Material material = state.func_185904_a();
        if (material == Material.field_151579_a) {
            return true;
        }
        if (material == Material.field_151586_h) {
            return true;
        }
        return material == Material.field_151587_i;
    }

    private void moveUp(BuildingInfo info, int x, int z, int height, boolean dowater) {
        BlockState blockToMove;
        this.driver.current(x, height, z);
        while (LostCityTerrainFeature.isEmpty(this.driver.getBlock()) && this.driver.getY() > 0) {
            this.driver.decY();
        }
        if (this.driver.getY() >= height) {
            return;
        }
        this.driver.current(x, height, z);
        for (int idx = this.driver.getY(); idx > 0 && (blockToMove = this.driver.getBlock(x, idx, z)).func_185904_a() != Material.field_151579_a && blockToMove.func_177230_c() != Blocks.field_150357_h; --idx) {
            this.driver.block(blockToMove);
            this.driver.decY();
        }
    }

    private boolean moveDown(BuildingInfo info, int x, int z, int height, boolean dowater) {
        int y = 255;
        this.driver.current(x, y, z);
        while (this.driver.getBlock() == air && this.driver.getY() > height) {
            this.driver.decY();
        }
        if (this.driver.getY() <= height) {
            return false;
        }
        BlockState[] buffer = new BlockState[6];
        int bufferIdx = 0;
        while (this.driver.getY() >= height) {
            if (bufferIdx < buffer.length) {
                buffer[bufferIdx++] = this.driver.getBlock();
            }
            this.driver.block(air);
            this.driver.decY();
        }
        int idx = 0;
        while (idx < bufferIdx && this.driver.getY() > 0) {
            this.driver.block(buffer[idx++]);
            this.driver.decY();
        }
        return true;
    }

    @Deprecated
    private void flattenChunkToCityBorder(int chunkX, int chunkZ) {
        double dist;
        int z;
        int x;
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.provider);
        float h00 = this.getHeightAt00Corner(info);
        float h10 = this.getHeightAt00Corner(info.getXmax());
        float h01 = this.getHeightAt00Corner(info.getZmax());
        float h11 = this.getHeightAt00Corner(info.getXmax().getZmax());
        ArrayList<GeometryTools.AxisAlignedBB2D> boxes = new ArrayList<GeometryTools.AxisAlignedBB2D>();
        ArrayList<GeometryTools.AxisAlignedBB2D> boxesDownwards = new ArrayList<GeometryTools.AxisAlignedBB2D>();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                GeometryTools.AxisAlignedBB2D box;
                if (x == 0 && z == 0) continue;
                int ccx = chunkX + x;
                int ccz = chunkZ + z;
                BuildingInfo info2 = BuildingInfo.getBuildingInfo(ccx, ccz, this.provider);
                if (info2.isCity) {
                    box = new GeometryTools.AxisAlignedBB2D(ccx * 16, ccz * 16, ccx * 16 + 15, ccz * 16 + 15);
                    boxes.add(box);
                    continue;
                }
                if (info2.getMaxHighwayLevel() < 0 || info2.isTunnel(info2.getMaxHighwayLevel())) continue;
                box = new GeometryTools.AxisAlignedBB2D(ccx * 16, ccz * 16, ccx * 16 + 15, ccz * 16 + 15);
                box.height = info.groundLevel + info2.getMaxHighwayLevel() * 6;
                boxesDownwards.add(box);
            }
        }
        if (!boxes.isEmpty()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    double mindist = 1.0E9;
                    int height = this.bipolate(h11, h01, h10, h00, x, z);
                    for (GeometryTools.AxisAlignedBB2D box : boxes) {
                        dist = GeometryTools.squaredDistanceBoxPoint(box, cx + x, cz + z);
                        if (!(dist < mindist)) continue;
                        mindist = dist;
                    }
                    int offset = (int)(Math.sqrt(mindist) * 2.0);
                    this.flattenChunkBorder(info, x, offset, z, this.rand, height);
                }
            }
        }
        if (!boxesDownwards.isEmpty()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    double mindist = 1.0E9;
                    int minheight = 1000000000;
                    for (GeometryTools.AxisAlignedBB2D box : boxesDownwards) {
                        dist = GeometryTools.squaredDistanceBoxPoint(box, cx + x, cz + z);
                        if (dist < mindist) {
                            mindist = dist;
                        }
                        if (box.height >= minheight) continue;
                        minheight = box.height;
                    }
                    int height = minheight;
                    int offset = (int)(Math.sqrt(mindist) * 2.0);
                    this.flattenChunkBorderDownwards(info, x, offset, z, this.rand, height);
                }
            }
        }
    }

    public static boolean isWaterBiome(IDimensionInfo provider, ChunkCoord coord) {
        BiomeInfo biomeInfo = BiomeInfo.getBiomeInfo(provider, coord);
        Biome mainBiome = biomeInfo.getMainBiome();
        return LostCityTerrainFeature.isWaterBiome(mainBiome);
    }

    private static boolean isWaterBiome(Biome biome) {
        Biome.Category category = biome.func_201856_r();
        return category.equals((Object)Biome.Category.OCEAN) || category.equals((Object)Biome.Category.BEACH) || category.equals((Object)Biome.Category.RIVER);
    }

    @Deprecated
    private void flattenChunkBorder(BuildingInfo info, int x, int offset, int z, Random rand, int level) {
        this.driver.current(x, 0, z);
        for (int y = 0; y <= level - offset - rand.nextInt(2); ++y) {
            BlockState b = this.driver.getBlock();
            if (b != bedrock) {
                this.driver.add(this.base);
                continue;
            }
            this.driver.incY();
        }
        int r = rand.nextInt(2);
        this.clearRange(info, x, z, level + offset + r, 230, info.waterLevel > info.groundLevel);
    }

    @Deprecated
    private void flattenChunkBorderDownwards(BuildingInfo info, int x, int offset, int z, Random rand, int level) {
        int r = rand.nextInt(2);
        this.clearRange(info, x, z, level + offset + r, 230, info.waterLevel > info.groundLevel);
    }

    public synchronized ChunkHeightmap getHeightmap(int chunkX, int chunkZ, @Nonnull ISeedReader world) {
        ChunkGenerator generator;
        ChunkCoord key = new ChunkCoord((RegistryKey<World>)world.func_201672_e().func_234923_W_(), chunkX, chunkZ);
        if (this.cachedHeightmaps.containsKey(key)) {
            return this.cachedHeightmaps.get(key);
        }
        ChunkHeightmap heightmap = new ChunkHeightmap(this.profile.LANDSCAPE_TYPE, this.profile.GROUNDLEVEL, this.base);
        boolean doNoiseVariant = false;
        ServerChunkProvider chunkProvider = world.func_201672_e().func_72863_F();
        if (chunkProvider instanceof ServerChunkProvider && (generator = chunkProvider.func_201711_g()) instanceof NoiseChunkGenerator) {
            doNoiseVariant = true;
        }
        if (doNoiseVariant) {
            this.makeDummyChunkNoise(chunkX, chunkZ, world, heightmap);
        } else {
            this.makeDummyChunk(heightmap);
        }
        this.cachedHeightmaps.put(key, heightmap);
        return heightmap;
    }

    private void makeDummyChunk(ChunkHeightmap heightmap) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                heightmap.update(x, 70, z, Blocks.field_150348_b.func_176223_P());
            }
        }
    }

    private void makeDummyChunkNoise(int chunkX, int chunkZ, ISeedReader region, ChunkHeightmap heightmap) {
        DummyChunk primer = new DummyChunk(new ChunkPos(chunkX, chunkZ), heightmap);
        ServerChunkProvider chunkProvider = region.func_201672_e().func_72863_F();
        if (chunkProvider instanceof ServerChunkProvider) {
            ChunkGenerator generator = chunkProvider.func_201711_g();
            generator.func_242706_a((Registry)region.func_241828_r().func_243612_b(Registry.field_239720_u_), (IChunk)primer);
            LostCityTerrainFeature.updateHeightmap((NoiseChunkGenerator)generator, (IChunk)primer, heightmap);
        }
    }

    public static void updateHeightmap(NoiseChunkGenerator chunkGenerator, IChunk chunk, ChunkHeightmap heightmap) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int cx = chunkX << 4;
        int cz = chunkZ << 4;
        double[][][] noise = new double[2][chunkGenerator.field_222567_n + 1][chunkGenerator.field_222566_m + 1];
        for (int nz = 0; nz < chunkGenerator.field_222567_n + 1; ++nz) {
            noise[0][nz] = new double[chunkGenerator.field_222566_m + 1];
            chunkGenerator.func_222548_a(noise[0][nz], chunkX * chunkGenerator.field_222565_l, chunkZ * chunkGenerator.field_222567_n + nz);
            noise[1][nz] = new double[chunkGenerator.field_222566_m + 1];
        }
        for (int nx = 0; nx < chunkGenerator.field_222565_l; ++nx) {
            int nz;
            for (nz = 0; nz < chunkGenerator.field_222567_n + 1; ++nz) {
                chunkGenerator.func_222548_a(noise[1][nz], chunkX * chunkGenerator.field_222565_l + nx + 1, chunkZ * chunkGenerator.field_222567_n + nz);
            }
            for (nz = 0; nz < chunkGenerator.field_222567_n; ++nz) {
                for (int ny = chunkGenerator.field_222566_m - 1; ny >= 0; --ny) {
                    double d0 = noise[0][nz][ny];
                    double d1 = noise[0][nz + 1][ny];
                    double d2 = noise[1][nz][ny];
                    double d3 = noise[1][nz + 1][ny];
                    double d4 = noise[0][nz][ny + 1];
                    double d5 = noise[0][nz + 1][ny + 1];
                    double d6 = noise[1][nz][ny + 1];
                    double d7 = noise[1][nz + 1][ny + 1];
                    for (int l1 = chunkGenerator.field_222563_j - 1; l1 >= 0; --l1) {
                        int yy = ny * chunkGenerator.field_222563_j + l1;
                        int yyy = yy & 0xF;
                        int chunkIndex = yy >> 4;
                        double d8 = (double)l1 / (double)chunkGenerator.field_222563_j;
                        double d9 = MathHelper.func_219803_d((double)d8, (double)d0, (double)d4);
                        double d10 = MathHelper.func_219803_d((double)d8, (double)d2, (double)d6);
                        double d11 = MathHelper.func_219803_d((double)d8, (double)d1, (double)d5);
                        double d12 = MathHelper.func_219803_d((double)d8, (double)d3, (double)d7);
                        for (int l2 = 0; l2 < chunkGenerator.field_222564_k; ++l2) {
                            int xx = cx + nx * chunkGenerator.field_222564_k + l2;
                            int xxx = xx & 0xF;
                            double d13 = (double)l2 / (double)chunkGenerator.field_222564_k;
                            double d14 = MathHelper.func_219803_d((double)d13, (double)d9, (double)d10);
                            double d15 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                            for (int k3 = 0; k3 < chunkGenerator.field_222564_k; ++k3) {
                                int zz = cz + nz * chunkGenerator.field_222564_k + k3;
                                int zzz = zz & 0xF;
                                double d16 = (double)k3 / (double)chunkGenerator.field_222564_k;
                                double d17 = MathHelper.func_219803_d((double)d16, (double)d14, (double)d15);
                                double d18 = MathHelper.func_151237_a((double)(d17 / 200.0), (double)-1.0, (double)1.0);
                                BlockState blockstate = chunkGenerator.func_236086_a_(d18, yy);
                                if (blockstate == air) continue;
                                heightmap.update(xxx, (chunkIndex << 4) + yyy, zzz, blockstate);
                            }
                        }
                    }
                }
            }
            double[][] adouble1 = noise[0];
            noise[0] = noise[1];
            noise[1] = adouble1;
        }
    }

    private void doCityChunk(int chunkX, int chunkZ, BuildingInfo info) {
        boolean building = info.hasBuilding;
        ChunkHeightmap heightmap = this.getHeightmap(info.chunkX, info.chunkZ, this.provider.getWorld());
        Random rand = new Random(this.provider.getSeed() * 377L + (long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        rand.nextFloat();
        rand.nextFloat();
        if (info.profile.isDefault()) {
            int z;
            int x;
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.driver.setBlockRange(x, 0, z, info.profile.BEDROCK_LAYER, bedrock);
                }
            }
            if (info.waterLevel > info.groundLevel) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        this.driver.setBlockRange(x, info.groundLevel, z, info.waterLevel, this.liquid);
                    }
                }
            }
        }
        if (building) {
            this.generateBuilding(info, heightmap);
        } else {
            this.generateStreet(info, heightmap, rand);
        }
        if ((double)info.profile.RUIN_CHANCE > 0.0) {
            this.generateRuins(info);
        }
        int levelX = info.getHighwayXLevel();
        int levelZ = info.getHighwayZLevel();
        if (!building) {
            Railway.RailChunkInfo railInfo = info.getRailInfo();
            if (levelX < 0 && levelZ < 0 && !railInfo.getType().isSurface()) {
                this.generateStreetDecorations(info);
            }
        }
        if (levelX >= 0 || levelZ >= 0) {
            this.generateHighways(chunkX, chunkZ, info);
        }
        if (info.profile.RUBBLELAYER && (!info.hasBuilding || info.ruinHeight >= 0.0f)) {
            this.generateRubble(chunkX, chunkZ, info);
        }
    }

    private void generateRailwayDungeons(BuildingInfo info) {
        if (info.railDungeon == null) {
            return;
        }
        if (info.getZmin().getRailInfo().getType() == RailChunkType.HORIZONTAL || info.getZmax().getRailInfo().getType() == RailChunkType.HORIZONTAL) {
            int height = info.groundLevel + -18;
            this.generatePart(info, info.railDungeon, Transform.ROTATE_NONE, 0, height, 0, false);
        }
    }

    private void generateRailways(BuildingInfo info, Railway.RailChunkInfo railInfo) {
        ChunkHeightmap heightmap;
        int maxh;
        BuildingPart part;
        int height = info.groundLevel + railInfo.getLevel() * 6;
        RailChunkType type = railInfo.getType();
        Transform transform = Transform.ROTATE_NONE;
        boolean needsStaircase = false;
        boolean clearUpper = false;
        switch (type) {
            case NONE: {
                return;
            }
            case STATION_SURFACE: 
            case STATION_EXTENSION_SURFACE: {
                part = railInfo.getLevel() < info.cityLevel ? AssetRegistries.PARTS.get("station_underground") : (railInfo.getPart() != null ? AssetRegistries.PARTS.get(railInfo.getPart()) : AssetRegistries.PARTS.get("station_open"));
                clearUpper = true;
                break;
            }
            case STATION_UNDERGROUND: {
                part = AssetRegistries.PARTS.get("station_underground_stairs");
                needsStaircase = true;
                break;
            }
            case STATION_EXTENSION_UNDERGROUND: {
                part = AssetRegistries.PARTS.get("station_underground");
                break;
            }
            case RAILS_END_HERE: {
                part = AssetRegistries.PARTS.get("rails_horizontal_end");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case HORIZONTAL: {
                part = AssetRegistries.PARTS.get("rails_horizontal");
                RailChunkType type1 = info.getXmin().getRailInfo().getType();
                RailChunkType type2 = info.getXmax().getRailInfo().getType();
                if (type1.isStation() || type2.isStation() || this.driver.getBlock(3, height + 2, 3) != this.liquid || this.driver.getBlock(12, height + 2, 3) != this.liquid || this.driver.getBlock(3, height + 2, 12) != this.liquid || this.driver.getBlock(12, height + 2, 12) != this.liquid || this.driver.getBlock(3, height + 4, 7) != this.liquid || this.driver.getBlock(12, height + 4, 8) != this.liquid) break;
                part = AssetRegistries.PARTS.get("rails_horizontal_water");
                break;
            }
            case VERTICAL: {
                part = AssetRegistries.PARTS.get("rails_vertical");
                if (this.driver.getBlock(3, height + 2, 3) == this.liquid && this.driver.getBlock(12, height + 2, 3) == this.liquid && this.driver.getBlock(3, height + 2, 12) == this.liquid && this.driver.getBlock(12, height + 2, 12) == this.liquid && this.driver.getBlock(3, height + 4, 7) == this.liquid && this.driver.getBlock(12, height + 4, 8) == this.liquid) {
                    part = AssetRegistries.PARTS.get("rails_vertical_water");
                }
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case THREE_SPLIT: {
                part = AssetRegistries.PARTS.get("rails_3split");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_TWO_FROM_SURFACE: 
            case GOING_DOWN_FURTHER: {
                part = AssetRegistries.PARTS.get("rails_down2");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_ONE_FROM_SURFACE: {
                part = AssetRegistries.PARTS.get("rails_down1");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case DOUBLE_BEND: {
                part = AssetRegistries.PARTS.get("rails_bend");
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            default: {
                part = AssetRegistries.PARTS.get("rails_flat");
            }
        }
        int h = this.generatePart(info, part, transform, 0, height, 0, false);
        if (clearUpper && h < (maxh = (heightmap = this.getHeightmap(info.chunkX, info.chunkZ, this.provider.getWorld())).getMaximumHeight() + 4)) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.clearRange(info, x, z, h, maxh, false);
                }
            }
        }
        Character railMainBlock = info.getCityStyle().getRailMainBlock();
        BlockState rail = info.getCompiledPalette().get(railMainBlock.charValue());
        if (type == RailChunkType.HORIZONTAL) {
            int z;
            if (info.getZmin().railDungeon != null) {
                for (z = 0; z < 4; ++z) {
                    this.driver.current(6, height + 1, z).add(rail).add(air).add(air);
                    this.driver.current(7, height + 1, z).add(rail).add(air).add(air);
                }
                for (z = 0; z < 3; ++z) {
                    this.driver.current(5, height + 2, z).add(rail).add(rail).add(rail);
                    this.driver.current(6, height + 4, z).block(rail);
                    this.driver.current(7, height + 4, z).block(rail);
                    this.driver.current(8, height + 2, z).add(rail).add(rail).add(rail);
                }
            }
            if (info.getZmax().railDungeon != null) {
                for (z = 0; z < 5; ++z) {
                    this.driver.current(6, height + 1, 15 - z).add(rail).add(air).add(air);
                    this.driver.current(7, height + 1, 15 - z).add(rail).add(air).add(air);
                }
                for (z = 0; z < 4; ++z) {
                    this.driver.current(5, height + 2, 15 - z).add(rail).add(rail).add(rail);
                    this.driver.current(6, height + 4, 15 - z).block(rail);
                    this.driver.current(7, height + 4, 15 - z).block(rail);
                    this.driver.current(8, height + 2, 15 - z).add(rail).add(rail).add(rail);
                }
            }
        }
        if (railInfo.getRails() < 3) {
            switch (railInfo.getType()) {
                case NONE: {
                    break;
                }
                case STATION_SURFACE: 
                case STATION_EXTENSION_SURFACE: 
                case STATION_UNDERGROUND: 
                case STATION_EXTENSION_UNDERGROUND: 
                case HORIZONTAL: {
                    int x;
                    if (railInfo.getRails() == 1) {
                        this.driver.current(0, height + 1, 5);
                        for (x = 0; x < 16; ++x) {
                            this.driver.block(rail).incX();
                        }
                        this.driver.current(0, height + 1, 9);
                        for (x = 0; x < 16; ++x) {
                            this.driver.block(rail).incX();
                        }
                    } else {
                        this.driver.current(0, height + 1, 7);
                        for (x = 0; x < 16; ++x) {
                            this.driver.block(rail).incX();
                        }
                    }
                    break;
                }
                case GOING_DOWN_TWO_FROM_SURFACE: 
                case GOING_DOWN_FURTHER: 
                case GOING_DOWN_ONE_FROM_SURFACE: {
                    int y;
                    int x;
                    if (railInfo.getRails() == 1) {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                this.driver.current(x, y, 5);
                                if (LostCityTerrainFeature.getRailStates().contains(this.driver.getBlock())) {
                                    this.driver.block(rail);
                                }
                                this.driver.current(x, y, 9);
                                if (!LostCityTerrainFeature.getRailStates().contains(this.driver.getBlock())) continue;
                                this.driver.block(rail);
                            }
                        }
                    } else {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                this.driver.current(x, y, 7);
                                if (!LostCityTerrainFeature.getRailStates().contains(this.driver.getBlock())) continue;
                                this.driver.block(rail);
                            }
                        }
                    }
                    break;
                }
                case THREE_SPLIT: {
                    break;
                }
                case VERTICAL: {
                    break;
                }
            }
        }
        if (needsStaircase) {
            part = AssetRegistries.PARTS.get("station_staircase");
            for (int i = railInfo.getLevel() + 1; i < info.cityLevel; ++i) {
                height = info.groundLevel + i * 6;
                this.generatePart(info, part, transform, 0, height, 0, false);
            }
            height = info.groundLevel + info.cityLevel * 6;
            part = AssetRegistries.PARTS.get("station_staircase_surface");
            this.generatePart(info, part, transform, 0, height, 0, false);
        }
    }

    private void generateStreetDecorations(BuildingInfo info) {
        Direction stairDirection = info.getActualStairDirection();
        if (stairDirection != null) {
            Transform transform;
            BuildingPart stairs = info.stairType;
            int oy = info.getCityGroundLevel() + 1;
            switch (stairDirection) {
                case XMIN: {
                    transform = Transform.ROTATE_NONE;
                    break;
                }
                case XMAX: {
                    transform = Transform.ROTATE_180;
                    break;
                }
                case ZMIN: {
                    transform = Transform.ROTATE_90;
                    break;
                }
                case ZMAX: {
                    transform = Transform.ROTATE_270;
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot happen!");
                }
            }
            this.generatePart(info, stairs, transform, 0, oy, 0, false);
        }
    }

    public long getSeed() {
        return this.driver.getRegion().func_72905_C();
    }

    private Blob findBlob(List<Blob> blobs, BlockPos index) {
        for (Blob blob : blobs) {
            if (!blob.contains(index)) continue;
            return blob;
        }
        return null;
    }

    private void fixAfterExplosionNew(BuildingInfo info, Random rand) {
        int start = info.getDamageArea().getLowestExplosionHeight();
        if (start == -1) {
            return;
        }
        int end = info.getDamageArea().getHighestExplosionHeight();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.driver.current(x, start, z);
                for (int y = start; y < end; ++y) {
                    Blob blob2;
                    BlockState p = this.driver.getBlock();
                    if (p != air && p != this.liquid && (blob2 = this.findBlob(blobs, this.driver.getCurrentCopy())) == null) {
                        blob2 = new Blob(start);
                        BlockPos current = this.driver.getCurrentCopy();
                        blob2.scan(info, this.driver, air, this.liquid, new BlockPos(x, y, z));
                        blobs.add(blob2);
                        this.driver.current(current);
                    }
                    this.driver.incY();
                }
            }
        }
        Blob blocksToMove = new Blob(0);
        blobs.stream().filter(blob -> blob.destroyOrMoveThis(this.provider, info)).sorted().forEachOrdered(blob -> {
            if (rand.nextFloat() < info.profile.DESTROY_OR_MOVE_CHANCE || ((Blob)blob).connectedBlocks.size() < info.profile.DESTROY_SMALL_SECTIONS_SIZE || ((Blob)blob).connections < 5) {
                for (BlockPos index : ((Blob)blob).connectedBlocks) {
                    this.driver.current(index);
                    this.driver.block(this.driver.getY() < info.waterLevel ? this.liquid : air);
                }
            } else {
                blocksToMove.connectedBlocks.addAll(((Blob)blob).connectedBlocks);
            }
        });
        for (BlockPos index : blocksToMove.connectedBlocks) {
            this.driver.current(index);
            BlockState c = this.driver.getBlock();
            this.driver.block(this.driver.getY() < info.waterLevel ? this.liquid : air);
            this.driver.decY();
            for (int y = this.driver.getY(); y > 2 && (blocksToMove.contains(this.driver.getCurrentCopy()) || LostCityTerrainFeature.isEmpty(this.driver.getBlock())); --y) {
                this.driver.decY();
            }
            this.driver.incY();
            this.driver.block(c);
        }
    }

    private void generateRubble(int chunkX, int chunkZ, BuildingInfo info) {
        this.rubbleBuffer = this.rubbleNoise.getRegion(this.rubbleBuffer, chunkX * 16, chunkZ * 16, 16, 16, 0.0625, 0.0625, 1.0);
        this.leavesBuffer = this.leavesNoise.getRegion(this.leavesBuffer, chunkX * 64, chunkZ * 64, 16, 16, 0.015625, 0.015625, 4.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int i;
                double vl;
                double vr = info.profile.RUBBLE_DIRT_SCALE < 0.01f ? 0.0 : this.rubbleBuffer[x + z * 16] / (double)info.profile.RUBBLE_DIRT_SCALE;
                double d = vl = info.profile.RUBBLE_LEAVE_SCALE < 0.01f ? 0.0 : this.leavesBuffer[x + z * 16] / (double)info.profile.RUBBLE_LEAVE_SCALE;
                if (!(vr > 0.5) && !(vl > 0.5)) continue;
                int height = this.getInterpolatedHeight(info, x, z);
                this.driver.current(x, height, z);
                BlockState c = this.driver.getBlockDown();
                if (c != air && c != this.liquid) {
                    i = 0;
                    while ((double)i < vr) {
                        if (LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                            this.driver.add(this.base);
                        } else {
                            this.driver.incY();
                        }
                        ++i;
                    }
                }
                if (this.driver.getBlockDown() != this.base) continue;
                i = 0;
                while ((double)i < vl) {
                    if (LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                        this.driver.add(LostCityTerrainFeature.getRandomLeaf());
                    } else {
                        this.driver.incY();
                    }
                    ++i;
                }
            }
        }
    }

    private int getInterpolatedHeight(BuildingInfo info, int x, int z) {
        if (x < 8 && z < 8) {
            float h00 = info.getXmin().getZmin().getCityGroundLevelOutsideLower();
            float h10 = info.getZmin().getCityGroundLevelOutsideLower();
            float h01 = info.getXmin().getCityGroundLevelOutsideLower();
            float h11 = info.getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x + 8, z + 8);
        }
        if (x >= 8 && z < 8) {
            float h00 = info.getZmin().getCityGroundLevelOutsideLower();
            float h10 = info.getXmax().getZmin().getCityGroundLevelOutsideLower();
            float h01 = info.getCityGroundLevelOutsideLower();
            float h11 = info.getXmax().getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x - 8, z + 8);
        }
        if (x < 8 && z >= 8) {
            float h00 = info.getXmin().getCityGroundLevelOutsideLower();
            float h10 = info.getCityGroundLevelOutsideLower();
            float h01 = info.getXmin().getZmax().getCityGroundLevelOutsideLower();
            float h11 = info.getZmax().getCityGroundLevelOutsideLower();
            return this.bipolate(h00, h10, h01, h11, x + 8, z - 8);
        }
        float h00 = info.getCityGroundLevelOutsideLower();
        float h10 = info.getXmax().getCityGroundLevelOutsideLower();
        float h01 = info.getZmax().getCityGroundLevelOutsideLower();
        float h11 = info.getXmax().getZmax().getCityGroundLevelOutsideLower();
        return this.bipolate(h00, h10, h01, h11, x - 8, z - 8);
    }

    private int bipolate(float h00, float h10, float h01, float h11, int dx, int dz) {
        float factor = (15.0f - (float)dx) / 15.0f;
        float h0 = h00 + (h10 - h00) * factor;
        float h1 = h01 + (h11 - h01) * factor;
        float h = h0 + (h1 - h0) * (15.0f - (float)dz) / 15.0f;
        return (int)h;
    }

    private void generateRuins(BuildingInfo info) {
        if (info.ruinHeight < 0.0f) {
            return;
        }
        int chunkX = info.chunkX;
        int chunkZ = info.chunkZ;
        double d0 = 0.03125;
        this.ruinBuffer = this.ruinNoise.getRegion(this.ruinBuffer, chunkX * 16, chunkZ * 16, 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        boolean doLeaves = info.profile.RUBBLELAYER;
        if (doLeaves) {
            this.leavesBuffer = this.leavesNoise.getRegion(this.leavesBuffer, chunkX * 64, chunkZ * 64, 16, 16, 0.015625, 0.015625, 4.0);
        }
        int baseheight = (int)((float)(info.getCityGroundLevel() + 1) + info.ruinHeight * (float)info.getNumFloors() * 6.0f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double v = this.ruinBuffer[x + z * 16];
                int height = baseheight + (int)v;
                this.driver.current(x, height, z);
                height = info.getMaxHeight() + 10 - height;
                int vl = 0;
                if (doLeaves) {
                    vl = (int)(info.profile.RUBBLE_LEAVE_SCALE < 0.01f ? 0.0 : this.leavesBuffer[x + z * 16] / (double)info.profile.RUBBLE_LEAVE_SCALE);
                }
                while (height > 0) {
                    BlockState damage = info.getCompiledPalette().canBeDamagedToIronBars(this.driver.getBlock());
                    BlockState c = this.driver.getBlockDown();
                    if ((damage != null || c == ironbars) && c != air && c != this.liquid && this.rand.nextFloat() < 0.2f) {
                        this.driver.add(ironbars);
                    } else if (vl > 0) {
                        c = this.driver.getBlockDown();
                        while (LostCityTerrainFeature.isEmpty(c)) {
                            this.driver.decY();
                            ++height;
                            c = this.driver.getBlockDown();
                        }
                        this.driver.add(LostCityTerrainFeature.getRandomLeaf());
                        --vl;
                    } else {
                        this.driver.add(air);
                    }
                    --height;
                }
            }
        }
    }

    private void generateStreet(BuildingInfo info, ChunkHeightmap heightmap, Random rand) {
        boolean canDoParks;
        boolean xRail = info.hasXCorridor();
        boolean zRail = info.hasZCorridor();
        if (xRail || zRail) {
            this.generateCorridors(info, xRail, zRail);
        }
        Railway.RailChunkInfo railInfo = info.getRailInfo();
        boolean bl = canDoParks = info.getHighwayXLevel() != info.cityLevel && info.getHighwayZLevel() != info.cityLevel && railInfo.getType() != RailChunkType.STATION_SURFACE && (railInfo.getType() != RailChunkType.STATION_EXTENSION_SURFACE || railInfo.getLevel() < info.cityLevel);
        if (canDoParks) {
            int height = info.getCityGroundLevel();
            if (this.profile.isDefault()) {
                this.clearToMax(info, heightmap, height);
            }
            BuildingInfo.StreetType streetType = info.streetType;
            boolean elevated = info.isElevatedParkSection();
            if (elevated) {
                Character elevationBlock = info.getCityStyle().getParkElevationBlock();
                BlockState elevation = info.getCompiledPalette().get(elevationBlock.charValue());
                streetType = BuildingInfo.StreetType.PARK;
                for (int x = 0; x < 16; ++x) {
                    this.driver.current(x, height, 0);
                    for (int z = 0; z < 16; ++z) {
                        this.driver.block(elevation).incZ();
                    }
                }
                ++height;
            }
            switch (streetType) {
                case NORMAL: {
                    this.generateNormalStreetSection(info, height);
                    break;
                }
                case FULL: {
                    this.generateFullStreetSection(height);
                    break;
                }
                case PARK: {
                    this.generateParkSection(info, height, elevated);
                }
            }
            ++height;
            if (streetType == BuildingInfo.StreetType.PARK || info.fountainType != null) {
                BuildingPart part = streetType == BuildingInfo.StreetType.PARK ? info.parkType : info.fountainType;
                this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, false);
            }
            this.generateRandomVegetation(info, rand, height);
            this.generateFrontPart(info, height, info.getXmin(), Transform.ROTATE_NONE);
            this.generateFrontPart(info, height, info.getZmin(), Transform.ROTATE_90);
            this.generateFrontPart(info, height, info.getXmax(), Transform.ROTATE_180);
            this.generateFrontPart(info, height, info.getZmax(), Transform.ROTATE_270);
        }
        this.generateBorders(info, canDoParks);
    }

    private void generateBorders(BuildingInfo info, boolean canDoParks) {
        int x;
        int z;
        int z2;
        int x2;
        Character borderBlock = info.getCityStyle().getBorderBlock();
        switch (info.profile.LANDSCAPE_TYPE) {
            case DEFAULT: {
                this.fillToBedrockStreetBlock(info);
                break;
            }
            case FLOATING: {
                this.fillMainStreetBlock(info, borderBlock, 3);
                break;
            }
            case CAVERN: {
                this.fillMainStreetBlock(info, borderBlock, 2);
                break;
            }
            case SPACE: {
                this.fillToGroundStreetBlock(info, info.getCityGroundLevel());
            }
        }
        if (this.doBorder(info, Direction.XMIN)) {
            x2 = 0;
            for (z2 = 0; z2 < 16; ++z2) {
                this.generateBorder(info, canDoParks, x2, z2, Direction.XMIN.get(info));
            }
        }
        if (this.doBorder(info, Direction.XMAX)) {
            x2 = 15;
            for (z2 = 0; z2 < 16; ++z2) {
                this.generateBorder(info, canDoParks, x2, z2, Direction.XMAX.get(info));
            }
        }
        if (this.doBorder(info, Direction.ZMIN)) {
            z = 0;
            for (x = 0; x < 16; ++x) {
                this.generateBorder(info, canDoParks, x, z, Direction.ZMIN.get(info));
            }
        }
        if (this.doBorder(info, Direction.ZMAX)) {
            z = 15;
            for (x = 0; x < 16; ++x) {
                this.generateBorder(info, canDoParks, x, z, Direction.ZMAX.get(info));
            }
        }
    }

    private void fillToBedrockStreetBlock(BuildingInfo info) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = info.getCityGroundLevel() - 1;
                this.driver.current(x, y, z);
                while (this.driver.getY() > info.profile.BEDROCK_LAYER && LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                    this.driver.block(this.base);
                    this.driver.decY();
                }
            }
        }
    }

    private void fillToGroundStreetBlock(BuildingInfo info, int lowestLevel) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                this.driver.current(x, y, z);
                for (y = lowestLevel - 1; y > 1 && this.driver.getBlock() == air; --y) {
                    this.driver.block(this.base).decY();
                }
            }
        }
    }

    private void fillMainStreetBlock(BuildingInfo info, Character borderBlock, int offset) {
        BlockState border = info.getCompiledPalette().get(borderBlock.charValue());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.driver.setBlockRange(x, info.getCityGroundLevel() - (offset - 1), z, info.getCityGroundLevel(), this.base);
                this.driver.current(x, info.getCityGroundLevel() - offset, z).block(border);
            }
        }
    }

    private void generateBorder(BuildingInfo info, boolean canDoParks, int x, int z, BuildingInfo adjacent) {
        Character borderBlock = info.getCityStyle().getBorderBlock();
        Character wallBlock = info.getCityStyle().getWallBlock();
        BlockState wall = info.getCompiledPalette().get(wallBlock.charValue());
        switch (info.profile.LANDSCAPE_TYPE) {
            case DEFAULT: {
                this.setBlocksFromPalette(x, info.groundLevel - 12, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                break;
            }
            case SPACE: {
                int adjacentY = info.getCityGroundLevel() - 8;
                if (adjacent.isCity) {
                    adjacentY = Math.min(adjacentY, adjacent.getCityGroundLevel());
                } else {
                    ChunkHeightmap adjacentHeightmap = this.getHeightmap(adjacent.chunkX, adjacent.chunkZ, this.provider.getWorld());
                    int minimumHeight = adjacentHeightmap.getMinimumHeight();
                    adjacentY = Math.min(adjacentY, minimumHeight - 2);
                }
                if (adjacentY <= 5) break;
                this.setBlocksFromPalette(x, adjacentY, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                break;
            }
            case FLOATING: {
                this.setBlocksFromPalette(x, info.getCityGroundLevel() - 3, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                if (!this.isCorner(x, z)) break;
                this.generateBorderSupport(info, wall, x, z, 3);
                break;
            }
            case CAVERN: {
                this.setBlocksFromPalette(x, info.getCityGroundLevel() - 2, z, info.getCityGroundLevel() + 1, info.getCompiledPalette(), borderBlock.charValue());
                if (!this.isCorner(x, z)) break;
                this.generateBorderSupport(info, wall, x, z, 2);
            }
        }
        if (canDoParks) {
            if (!this.borderNeedsConnectionToAdjacentChunk(info, x, z)) {
                this.driver.current(x, info.getCityGroundLevel() + 1, z).block(wall);
            } else {
                this.driver.current(x, info.getCityGroundLevel() + 1, z).block(air);
            }
        }
    }

    private void generateBorderSupport(BuildingInfo info, BlockState wall, int x, int z, int offset) {
        ChunkHeightmap heightmap = this.getHeightmap(info.chunkX, info.chunkZ, this.provider.getWorld());
        int height = heightmap.getHeight(x, z);
        if (height > 1) {
            int y;
            this.driver.current(x, y, z);
            for (y = info.getCityGroundLevel() - offset - 1; y > 1 && this.driver.getBlock() == air; --y) {
                this.driver.block(wall).decY();
            }
            while (y > 1 && this.driver.getBlock() == this.liquid) {
                this.driver.block(this.base).decY();
                --y;
            }
        }
    }

    private int generateFrontPart(BuildingInfo info, int height, BuildingInfo adj, Transform rot) {
        if (info.hasFrontPartFrom(adj)) {
            return this.generatePart(adj, adj.frontType, rot, 0, height, 0, false);
        }
        return height;
    }

    private void generateCorridors(BuildingInfo info, boolean xRail, boolean zRail) {
        BlockState railx = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST);
        BlockState railz = Blocks.field_150448_aq.func_176223_P();
        Character corridorRoofBlock = info.getCityStyle().getCorridorRoofBlock();
        Character corridorGlassBlock = info.getCityStyle().getCorridorGlassBlock();
        CompiledPalette palette = info.getCompiledPalette();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (xRail && z >= 7 && z <= 10 || zRail && x >= 7 && x <= 10) {
                    int height = info.groundLevel - 5;
                    BlockState b = xRail && z == 10 ? railx : (zRail && x == 10 ? railz : air);
                    this.driver.current(x, height, z).add(b).add(air).add(air);
                    if (xRail && x == 7 && (z == 8 || z == 9) || zRail && z == 7 && (x == 8 || x == 9)) {
                        BlockState glass = palette.get(corridorGlassBlock.charValue());
                        info.addLightingUpdateTodo(new BlockPos(x, height, z));
                        this.driver.add(glass).add(glowstone);
                        continue;
                    }
                    BlockState roof = palette.get(corridorRoofBlock.charValue());
                    this.driver.add(roof).add(roof);
                    continue;
                }
                this.driver.setBlockRange(x, info.groundLevel - 5, z, info.getCityGroundLevel(), this.base);
            }
        }
    }

    private void generateRandomVegetation(BuildingInfo info, Random rand, int height) {
        int x;
        int z;
        int cnt;
        float v;
        int z2;
        int x2;
        if (info.getXmin().hasBuilding) {
            for (x2 = 0; x2 < info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    this.driver.current(x2, height, z2);
                    while (this.driver.getBlockDown() == air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = Math.min(0.8f, info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS + 1 - x2));
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(LostCityTerrainFeature.getRandomLeaf());
                    }
                }
            }
        }
        if (info.getXmax().hasBuilding) {
            for (x2 = 15 - info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; x2 < 15; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    this.driver.current(x2, height, z2);
                    while (this.driver.getBlockDown() == air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = Math.min(0.8f, info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(x2 - 14 + info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS));
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(LostCityTerrainFeature.getRandomLeaf());
                    }
                }
            }
        }
        if (info.getZmin().hasBuilding) {
            for (z = 0; z < info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; ++z) {
                for (x = 0; x < 16; ++x) {
                    this.driver.current(x, height, z);
                    while (this.driver.getBlockDown() == air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = Math.min(0.8f, info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS + 1 - z));
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(LostCityTerrainFeature.getRandomLeaf());
                    }
                }
            }
        }
        if (info.getZmax().hasBuilding) {
            for (z = 15 - info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS; z < 15; ++z) {
                for (x = 0; x < 16; ++x) {
                    this.driver.current(x, height, z);
                    while (this.driver.getBlockDown() == air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    v = info.profile.CHANCE_OF_RANDOM_LEAFBLOCKS * (float)(z - 14 + info.profile.THICKNESS_OF_RANDOM_LEAFBLOCKS);
                    for (cnt = 0; rand.nextFloat() < v && cnt < 30; ++cnt) {
                        this.driver.add(LostCityTerrainFeature.getRandomLeaf());
                    }
                }
            }
        }
    }

    private void generateParkSection(BuildingInfo info, int height, boolean elevated) {
        boolean el00 = info.getXmin().getZmin().isElevatedParkSection();
        boolean el10 = info.getZmin().isElevatedParkSection();
        boolean el20 = info.getXmax().getZmin().isElevatedParkSection();
        boolean el01 = info.getXmin().isElevatedParkSection();
        boolean el21 = info.getXmax().isElevatedParkSection();
        boolean el02 = info.getXmin().getZmax().isElevatedParkSection();
        boolean el12 = info.getZmax().isElevatedParkSection();
        boolean el22 = info.getXmax().getZmax().isElevatedParkSection();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockState b;
                if (x == 0 || x == 15 || z == 0 || z == 15) {
                    b = this.street;
                    if (elevated) {
                        if (x == 0 && z == 0) {
                            if (el01 && el00 && el10) {
                                b = grass;
                            }
                        } else if (x == 15 && z == 0) {
                            if (el21 && el20 && el10) {
                                b = grass;
                            }
                        } else if (x == 0 && z == 15) {
                            if (el01 && el02 && el12) {
                                b = grass;
                            }
                        } else if (x == 15 && z == 15) {
                            if (el12 && el22 && el21) {
                                b = grass;
                            }
                        } else if (x == 0) {
                            if (el01) {
                                b = grass;
                            }
                        } else if (x == 15) {
                            if (el21) {
                                b = grass;
                            }
                        } else if (z == 0) {
                            if (el10) {
                                b = grass;
                            }
                        } else if (z == 15 && el12) {
                            b = grass;
                        }
                    }
                } else {
                    b = grass;
                }
                this.driver.current(x, height, z).block(b);
            }
        }
    }

    private void generateFullStreetSection(int height) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockState b = this.isSide(x, z) ? this.street : this.street2;
                this.driver.current(x, height, z).block(b);
            }
        }
    }

    private void generateNormalStreetSection(BuildingInfo info, int height) {
        BlockState defaultStreet = this.streetBase;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockState b = defaultStreet;
                if (this.isStreetBorder(x, z)) {
                    if (x <= this.streetBorder && z > this.streetBorder && z < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getXmin()) || info.getXmin().hasXBridge(this.provider) != null)) {
                        b = this.street;
                    } else if (x >= 15 - this.streetBorder && z > this.streetBorder && z < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getXmax()) || info.getXmax().hasXBridge(this.provider) != null)) {
                        b = this.street;
                    } else if (z <= this.streetBorder && x > this.streetBorder && x < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getZmin()) || info.getZmin().hasZBridge(this.provider) != null)) {
                        b = this.street;
                    } else if (z >= 15 - this.streetBorder && x > this.streetBorder && x < 15 - this.streetBorder && (BuildingInfo.hasRoadConnection(info, info.getZmax()) || info.getZmax().hasZBridge(this.provider) != null)) {
                        b = this.street;
                    }
                } else {
                    b = this.street;
                }
                this.driver.current(x, height, z).block(b);
            }
        }
    }

    private boolean borderNeedsConnectionToAdjacentChunk(BuildingInfo info, int x, int z) {
        for (Direction direction : Direction.VALUES) {
            if (!direction.atSide(x, z)) continue;
            BuildingInfo adjacent = direction.get(info);
            if (adjacent.getActualStairDirection() == direction.getOpposite()) {
                BuildingPart stairType = adjacent.stairType;
                Integer z1 = stairType.getMetaInteger("z1");
                Integer z2 = stairType.getMetaInteger("z2");
                Transform transform = direction.getOpposite().getRotation();
                int xx1 = transform.rotateX(15, z1);
                int zz1 = transform.rotateZ(15, z1);
                int xx2 = transform.rotateX(15, z2);
                int zz2 = transform.rotateZ(15, z2);
                if (x >= Math.min(xx1, xx2) && x <= Math.max(xx1, xx2) && z >= Math.min(zz1, zz2) && z <= Math.max(zz1, zz2)) {
                    return true;
                }
            }
            if (adjacent.hasBridge(this.provider, direction.getOrientation()) == null) continue;
            return true;
        }
        return false;
    }

    private int generatePart(BuildingInfo info, IBuildingPart part, Transform transform, int ox, int oy, int oz, boolean airWaterLevel) {
        CompiledPalette compiledPalette = info.getCompiledPalette();
        Palette localPalette = part.getLocalPalette();
        if (localPalette != null) {
            compiledPalette = new CompiledPalette(compiledPalette, localPalette);
        }
        boolean nowater = part.getMetaBoolean("nowater");
        for (int x = 0; x < part.getXSize(); ++x) {
            for (int z = 0; z < part.getZSize(); ++z) {
                char[] vs = part.getVSlice(x, z);
                if (vs == null) continue;
                int rx = ox + transform.rotateX(x, z);
                int rz = oz + transform.rotateZ(x, z);
                this.driver.current(rx, oy, rz);
                int len = vs.length;
                for (int y = 0; y < len; ++y) {
                    char c = vs[y];
                    BlockState b = compiledPalette.get(c);
                    if (b == null) {
                        throw new RuntimeException("Could not find entry '" + c + "' in the palette for part '" + part.getName() + "'!");
                    }
                    CompiledPalette.Info inf = compiledPalette.getInfo(Character.valueOf(c));
                    if (transform != Transform.ROTATE_NONE) {
                        if (LostCityTerrainFeature.getRotatableStates().contains(b)) {
                            b = b.func_185907_a(transform.getMcRotation());
                        } else if (LostCityTerrainFeature.getRailStates().contains(b)) {
                            EnumProperty shapeProperty;
                            if (b.func_177230_c() == Blocks.field_150448_aq) {
                                shapeProperty = RailBlock.field_176565_b;
                            } else if (b.func_177230_c() == Blocks.field_196552_aC) {
                                shapeProperty = PoweredRailBlock.field_176568_b;
                            } else {
                                throw new RuntimeException("Error with rail!");
                            }
                            RailShape shape = (RailShape)b.func_177229_b((Property)shapeProperty);
                            b = (BlockState)b.func_206870_a((Property)shapeProperty, (Comparable)transform.transform(shape));
                        }
                    }
                    if (b != air) {
                        BlockState bs;
                        Block block;
                        Runnable action = null;
                        if (b == this.liquid) {
                            if (info.profile.AVOID_WATER) {
                                b = air;
                            }
                        } else if (b == hardAir) {
                            b = airWaterLevel && !info.profile.AVOID_WATER && !nowater ? (oy + y < info.waterLevel ? this.liquid : air) : air;
                        } else if (inf != null) {
                            if (inf.isTorch()) {
                                if (info.profile.GENERATE_LIGHTING) {
                                    info.addTorchTodo(this.driver.getCurrentCopy());
                                } else {
                                    b = air;
                                }
                            } else if (inf.getLoot() != null && !inf.getLoot().isEmpty()) {
                                if (!info.noLoot) {
                                    BlockPos pos = new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz);
                                    BlockState finalB = b;
                                    action = () -> {
                                        this.provider.getWorld().func_180501_a(pos, finalB, 2);
                                        this.generateLoot(info, (IWorld)this.provider.getWorld(), pos, new BuildingInfo.ConditionTodo(inf.getLoot(), part.getName(), info));
                                    };
                                }
                            } else if (inf.getMobId() != null && !inf.getMobId().isEmpty()) {
                                if (info.profile.GENERATE_SPAWNERS && !info.noLoot) {
                                    String mobid = inf.getMobId();
                                    BlockPos pos = new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz);
                                    BlockState finalB1 = b;
                                    action = () -> {
                                        this.provider.getWorld().func_180501_a(pos, finalB1, 2);
                                        LostCityTerrainFeature.createSpawner(this.rand, this.provider, info, new BuildingInfo.ConditionTodo(mobid, part.getName(), info), pos);
                                    };
                                } else {
                                    b = air;
                                }
                            }
                        } else if (LostCityTerrainFeature.getStatesNeedingLightingUpdate().contains(b)) {
                            info.getTodoChunk(rx, rz).addLightingUpdateTodo(new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz));
                        } else if (LostCityTerrainFeature.getStatesNeedingTodo().contains(b) && ((block = (bs = b).func_177230_c()) instanceof SaplingBlock || block instanceof FlowerBlock)) {
                            if (info.profile.AVOID_FOLIAGE) {
                                b = air;
                            } else {
                                info.getTodoChunk(rx, rz).addSaplingTodo(new BlockPos(info.chunkX * 16 + rx, oy + y, info.chunkZ * 16 + rz));
                            }
                        }
                        this.driver.add(b);
                        if (action == null) continue;
                        action.run();
                        continue;
                    }
                    this.driver.incY();
                }
            }
        }
        return oy + part.getSliceCount();
    }

    public static void createSpawner(Random random, final IDimensionInfo diminfo, final BuildingInfo info, BuildingInfo.ConditionTodo todo, final BlockPos pos) {
        ISeedReader world = diminfo.getWorld();
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MobSpawnerTileEntity) {
            int floor;
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)tileentity;
            String condition = todo.getCondition();
            Condition cnd = AssetRegistries.CONDITIONS.get(condition);
            if (cnd == null) {
                throw new RuntimeException("Cannot find condition '" + condition + "'!");
            }
            int level = (pos.func_177956_o() - diminfo.getProfile().GROUNDLEVEL) / 6;
            ConditionContext conditionContext = new ConditionContext(level, floor = (pos.func_177956_o() - info.getCityGroundLevel()) / 6, info.floorsBelowGround, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ, (IWorld)world){
                final /* synthetic */ IWorld val$world;
                {
                    this.val$world = iWorld;
                    super(level, floor, floorsBelowGround, floorsAboveGround, part, building, chunkX, chunkZ);
                }

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(info.chunkX, info.chunkZ, pos, diminfo);
                }

                @Override
                public ResourceLocation getBiome() {
                    return this.val$world.func_226691_t_(pos).getRegistryName();
                }
            };
            String randomValue = cnd.getRandomValue(random, conditionContext);
            if (randomValue == null) {
                throw new RuntimeException("Condition '" + cnd.getName() + "' did not return a valid mob!");
            }
            AbstractSpawner logic = spawner.func_145881_a();
            logic.func_200876_a((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomValue)));
            spawner.func_70296_d();
            if (LostCityConfiguration.DEBUG) {
                LostCities.setup.getLogger().debug("generateLootSpawners: mob=" + randomValue + " pos=" + pos.toString());
            }
        } else if (tileentity != null) {
            LostCities.setup.getLogger().error("The mob spawner at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ") has a TileEntity of incorrect type " + tileentity.getClass().getName() + "!");
        } else {
            LostCities.setup.getLogger().error("The mob spawner at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ") is missing its TileEntity!");
        }
    }

    private void generateLoot(BuildingInfo info, IWorld world, BlockPos pos, BuildingInfo.ConditionTodo condition) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LockableLootTileEntity) {
            if (this.provider.getProfile().GENERATE_LOOT) {
                LostCityTerrainFeature.createLoot(info, this.rand, world, pos, condition, this.provider);
            }
        } else if (te == null) {
            LostCities.setup.getLogger().error("Error setting loot at " + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p());
        }
    }

    public static void createLoot(final BuildingInfo info, Random random, final IWorld world, final BlockPos pos, BuildingInfo.ConditionTodo todo, final IDimensionInfo diminfo) {
        if (random.nextFloat() < diminfo.getProfile().CHEST_WITHOUT_LOOT_CHANCE) {
            return;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof LockableLootTileEntity && todo != null) {
            String lootTable = todo.getCondition();
            int level = (pos.func_177956_o() - diminfo.getProfile().GROUNDLEVEL) / 6;
            int floor = (pos.func_177956_o() - info.getCityGroundLevel()) / 6;
            ConditionContext conditionContext = new ConditionContext(level, floor, info.floorsBelowGround, info.getNumFloors(), todo.getPart(), todo.getBuilding(), info.chunkX, info.chunkZ){

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(info.chunkX, info.chunkZ, pos, diminfo);
                }

                @Override
                public ResourceLocation getBiome() {
                    return world.func_226691_t_(pos).getRegistryName();
                }
            };
            String randomValue = AssetRegistries.CONDITIONS.get(lootTable).getRandomValue(random, conditionContext);
            if (randomValue == null) {
                throw new RuntimeException("Condition '" + lootTable + "' did not return a table under certain conditions!");
            }
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)pos, (ResourceLocation)new ResourceLocation(randomValue));
        }
    }

    private void generateDebris(Random rand, BuildingInfo info) {
        this.generateDebrisFromChunk(rand, info, info.getXmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) / 16.0f));
        this.generateDebrisFromChunk(rand, info, info.getXmax(), (xx, zz) -> Float.valueOf((float)xx.intValue() / 16.0f));
        this.generateDebrisFromChunk(rand, info, info.getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)zz.intValue()) / 16.0f));
        this.generateDebrisFromChunk(rand, info, info.getZmax(), (xx, zz) -> Float.valueOf((float)zz.intValue() / 16.0f));
        this.generateDebrisFromChunk(rand, info, info.getXmin().getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (15.0f - (float)zz.intValue()) / 256.0f));
        this.generateDebrisFromChunk(rand, info, info.getXmax().getZmax(), (xx, zz) -> Float.valueOf((float)(xx * zz) / 256.0f));
        this.generateDebrisFromChunk(rand, info, info.getXmin().getZmax(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (float)zz.intValue() / 256.0f));
        this.generateDebrisFromChunk(rand, info, info.getXmax().getZmin(), (xx, zz) -> Float.valueOf((float)xx.intValue() * (15.0f - (float)zz.intValue()) / 256.0f));
    }

    private void generateDebrisFromChunk(Random rand, BuildingInfo info, BuildingInfo adjacentInfo, BiFunction<Integer, Integer, Float> locationFactor) {
        if (adjacentInfo.hasBuilding) {
            BlockState filler = adjacentInfo.getCompiledPalette().get(adjacentInfo.getBuilding().getFillerBlock());
            float damageFactor = adjacentInfo.getDamageArea().getDamageFactor();
            if (damageFactor > 0.5f) {
                int blocks = (1 + adjacentInfo.getNumFloors()) * 1000;
                float damage = Math.max(1.0f, damageFactor * 0.7f);
                int destroyedBlocks = (int)((float)blocks * damage);
                destroyedBlocks /= info.profile.DEBRIS_TO_NEARBYCHUNK_FACTOR;
                int h = adjacentInfo.getMaxHeight() + 10;
                for (int i = 0; i < destroyedBlocks; ++i) {
                    BlockState b;
                    int x = rand.nextInt(16);
                    int z = rand.nextInt(16);
                    if (!(rand.nextFloat() < locationFactor.apply(x, z).floatValue())) continue;
                    this.driver.current(x, h, z);
                    while (h > 0 && LostCityTerrainFeature.isEmpty(this.driver.getBlock())) {
                        --h;
                        this.driver.decY();
                    }
                    switch (rand.nextInt(5)) {
                        case 0: {
                            b = ironbars;
                            break;
                        }
                        default: {
                            b = filler;
                        }
                    }
                    this.driver.current(x, h + 1, z).block(b);
                }
            }
        }
    }

    private boolean doBorder(BuildingInfo info, Direction direction) {
        BuildingInfo adjacent = direction.get(info);
        if (this.isHigherThenNearbyStreetChunk(info, adjacent)) {
            return true;
        }
        if (!adjacent.isCity) {
            ChunkHeightmap adjacentHeightmap;
            int adjacentHeight;
            if (adjacent.cityLevel <= info.cityLevel) {
                return true;
            }
            if (info.profile.isSpace() && (adjacentHeight = (adjacentHeightmap = this.getHeightmap(adjacent.chunkX, adjacent.chunkZ, this.provider.getWorld())).getAverageHeight()) > 5 && adjacentHeight - 4 < info.getCityGroundLevel()) {
                return true;
            }
        }
        return false;
    }

    private boolean isHigherThenNearbyStreetChunk(BuildingInfo info, BuildingInfo adjacent) {
        if (!adjacent.isCity) {
            return false;
        }
        if (adjacent.hasBuilding) {
            return adjacent.cityLevel + adjacent.getNumFloors() < info.cityLevel;
        }
        return adjacent.cityLevel < info.cityLevel;
    }

    private void setBlocksFromPalette(int x, int y, int z, int y2, CompiledPalette palette, char character) {
        if (palette.isSimple(character)) {
            BlockState b = palette.get(character);
            this.driver.setBlockRangeSafe(x, y, z, y2, b);
        } else {
            this.driver.current(x, y, z);
            while (y < y2) {
                this.driver.add(palette.get(character));
                ++y;
            }
        }
    }

    private void generateBuilding(BuildingInfo info, ChunkHeightmap heightmap) {
        int z;
        int x;
        int lowestLevel = info.getCityGroundLevel() - info.floorsBelowGround * 6;
        Character borderBlock = info.getCityStyle().getBorderBlock();
        CompiledPalette palette = info.getCompiledPalette();
        char fillerBlock = info.getBuilding().getFillerBlock();
        if (info.profile.isFloating()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.driver.current(x, 255, z);
                    while (this.driver.getBlock() == air && this.driver.getY() > 0) {
                        this.driver.decY();
                    }
                    int height = this.driver.getY();
                    if (height > 1 && height < lowestLevel - 1) {
                        this.driver.setBlockRange(x, height + 1, z, lowestLevel, this.base);
                    }
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, info.waterLevel > info.groundLevel);
                }
            }
        } else if (info.profile.isSpace()) {
            this.fillToGround(info, lowestLevel, borderBlock);
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, false);
                }
            }
        } else {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    if (this.isSide(x, z)) {
                        int y;
                        this.driver.current(x, y, z);
                        for (y = lowestLevel - 10; y < lowestLevel; ++y) {
                            this.driver.add(palette.get(borderBlock.charValue()));
                        }
                    } else if (info.profile.isDefault()) {
                        // empty if block
                    }
                    if (this.driver.getBlock(x, lowestLevel, z) == air) {
                        BlockState filler = palette.get(fillerBlock);
                        this.driver.current(x, lowestLevel, z).block(filler);
                    }
                    this.clearRange(info, x, z, lowestLevel, info.getCityGroundLevel() + info.getNumFloors() * 6, info.waterLevel > info.groundLevel);
                }
            }
        }
        int height = lowestLevel;
        for (int f = -info.floorsBelowGround; f <= info.getNumFloors(); ++f) {
            boolean isTop;
            if (f == info.getNumFloors() && this.profile.isDefault()) {
                this.clearToMax(info, heightmap, height);
            }
            BuildingPart part = info.getFloor(f);
            this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, false);
            part = info.getFloorPart2(f);
            if (part != null) {
                this.generatePart(info, part, Transform.ROTATE_NONE, 0, height, 0, false);
            }
            boolean bl = isTop = f == info.getNumFloors();
            if (!isTop) {
                this.generateDoors(info, height + 1, f);
            }
            height += 6;
        }
        if (info.floorsBelowGround > 0) {
            for (int x2 = 0; x2 < 16; ++x2) {
                this.setBlocksFromPalette(x2, lowestLevel, 0, Math.min(info.getCityGroundLevel(), info.getZmin().getCityGroundLevel()) + 1, palette, fillerBlock);
                this.setBlocksFromPalette(x2, lowestLevel, 15, Math.min(info.getCityGroundLevel(), info.getZmax().getCityGroundLevel()) + 1, palette, fillerBlock);
            }
            for (z = 1; z < 15; ++z) {
                this.setBlocksFromPalette(0, lowestLevel, z, Math.min(info.getCityGroundLevel(), info.getXmin().getCityGroundLevel()) + 1, palette, fillerBlock);
                this.setBlocksFromPalette(15, lowestLevel, z, Math.min(info.getCityGroundLevel(), info.getXmax().getCityGroundLevel()) + 1, palette, fillerBlock);
            }
        }
        if (info.floorsBelowGround >= 1) {
            this.generateCorridorConnections(info);
        }
    }

    private void clearToMax(BuildingInfo info, ChunkHeightmap heightmap, int height) {
        int maximumHeight = Math.min(255, heightmap.getMaximumHeight() + 10);
        if (height < maximumHeight) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.clearRange(info, x, z, height, maximumHeight, false);
                }
            }
        }
    }

    private void fillToGround(BuildingInfo info, int lowestLevel, Character borderBlock) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = lowestLevel - 1;
                this.driver.current(x, y, z);
                if (this.isSide(x, z)) {
                    while (y > 1 && this.driver.getBlock() == air) {
                        this.driver.block(info.getCompiledPalette().get(borderBlock.charValue())).decY();
                    }
                    continue;
                }
                while (y > 1 && this.driver.getBlock() == air) {
                    this.driver.block(this.base).decY();
                }
            }
        }
    }

    private BlockState getDoor(Block door, boolean upper, boolean left, net.minecraft.util.Direction facing) {
        return (BlockState)((BlockState)((BlockState)door.func_176223_P().func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)(upper ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER))).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)(left ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)facing);
    }

    private void generateDoors(BuildingInfo info, int height, int f) {
        int z;
        int x;
        BlockState filler = info.getCompiledPalette().get(info.getBuilding().getFillerBlock());
        --height;
        if (info.hasConnectionAtX(f + info.floorsBelowGround)) {
            x = 0;
            if (this.hasConnectionWithBuilding(f, info, info.getXmin())) {
                this.driver.setBlockRange(x, height, 6, height + 4, filler);
                this.driver.setBlockRange(x, height, 9, height + 4, filler);
                this.driver.current(x, height, 7).add(filler).add(air).add(air).add(filler);
                this.driver.current(x, height, 8).add(filler).add(air).add(air).add(filler);
            } else if (this.hasConnectionToTopOrOutside(f, info, info.getXmin())) {
                this.driver.setBlockRange(x, height, 6, height + 4, filler);
                this.driver.setBlockRange(x, height, 9, height + 4, filler);
                this.driver.current(x, height, 7).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.util.Direction.EAST)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.util.Direction.EAST)).add(filler);
                this.driver.current(x, height, 8).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.util.Direction.EAST)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.util.Direction.EAST)).add(filler);
            }
        }
        if (this.hasConnectionWithBuildingMax(f, info, info.getXmax(), Orientation.X)) {
            x = 15;
            this.driver.setBlockRange(x, height, 6, height + 4, filler);
            this.driver.setBlockRange(x, height, 9, height + 4, filler);
            this.driver.current(x, height, 7).add(filler).add(air).add(air).add(filler);
            this.driver.current(x, height, 8).add(filler).add(air).add(air).add(filler);
        } else if (this.hasConnectionToTopOrOutside(f, info, info.getXmax()) && info.getXmax().hasConnectionAtXFromStreet(f + info.getXmax().floorsBelowGround)) {
            x = 15;
            this.driver.setBlockRange(x, height, 6, height + 4, filler);
            this.driver.setBlockRange(x, height, 9, height + 4, filler);
            this.driver.current(x, height, 7).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.util.Direction.WEST)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.util.Direction.WEST)).add(filler);
            this.driver.current(x, height, 8).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.util.Direction.WEST)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.util.Direction.WEST)).add(filler);
        }
        if (info.hasConnectionAtZ(f + info.floorsBelowGround)) {
            z = 0;
            if (this.hasConnectionWithBuilding(f, info, info.getZmin())) {
                this.driver.setBlockRange(6, height, z, height + 4, filler);
                this.driver.setBlockRange(9, height, z, height + 4, filler);
                this.driver.current(7, height, z).add(filler).add(air).add(air).add(filler);
                this.driver.current(8, height, z).add(filler).add(air).add(air).add(filler);
            } else if (this.hasConnectionToTopOrOutside(f, info, info.getZmin())) {
                this.driver.setBlockRange(6, height, z, height + 4, filler);
                this.driver.setBlockRange(9, height, z, height + 4, filler);
                this.driver.current(7, height, z).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.util.Direction.NORTH)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.util.Direction.NORTH)).add(filler);
                this.driver.current(8, height, z).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.util.Direction.NORTH)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.util.Direction.NORTH)).add(filler);
            }
        }
        if (this.hasConnectionWithBuildingMax(f, info, info.getZmax(), Orientation.Z)) {
            z = 15;
            this.driver.setBlockRange(6, height, z, height + 4, filler);
            this.driver.setBlockRange(9, height, z, height + 4, filler);
            this.driver.current(7, height, z).add(filler).add(air).add(air).add(filler);
            this.driver.current(8, height, z).add(filler).add(air).add(air).add(filler);
        } else if (this.hasConnectionToTopOrOutside(f, info, info.getZmax()) && info.getZmax().hasConnectionAtZFromStreet(f + info.getZmax().floorsBelowGround)) {
            z = 15;
            this.driver.setBlockRange(6, height, z, height + 4, filler);
            this.driver.setBlockRange(9, height, z, height + 4, filler);
            this.driver.current(7, height, z).add(filler).add(this.getDoor(info.doorBlock, false, false, net.minecraft.util.Direction.SOUTH)).add(this.getDoor(info.doorBlock, true, false, net.minecraft.util.Direction.SOUTH)).add(filler);
            this.driver.current(8, height, z).add(filler).add(this.getDoor(info.doorBlock, false, true, net.minecraft.util.Direction.SOUTH)).add(this.getDoor(info.doorBlock, true, true, net.minecraft.util.Direction.SOUTH)).add(filler);
        }
    }

    private void generateCorridorConnections(BuildingInfo info) {
        int x;
        int z;
        int z2;
        int x2;
        if (info.getXmin().hasXCorridor()) {
            x2 = 0;
            for (z2 = 7; z2 <= 10; ++z2) {
                this.driver.setBlockRange(x2, info.groundLevel - 5, z2, info.groundLevel - 2, air);
            }
        }
        if (info.getXmax().hasXCorridor()) {
            x2 = 15;
            for (z2 = 7; z2 <= 10; ++z2) {
                this.driver.setBlockRange(x2, info.groundLevel - 5, z2, info.groundLevel - 2, air);
            }
        }
        if (info.getZmin().hasXCorridor()) {
            z = 0;
            for (x = 7; x <= 10; ++x) {
                this.driver.setBlockRange(x, info.groundLevel - 5, z, info.groundLevel - 2, air);
            }
        }
        if (info.getZmax().hasXCorridor()) {
            z = 15;
            for (x = 7; x <= 10; ++x) {
                this.driver.setBlockRange(x, info.groundLevel - 5, z, info.groundLevel - 2, air);
            }
        }
    }

    private boolean hasConnectionWithBuildingMax(int localLevel, BuildingInfo info, BuildingInfo info2, Orientation x) {
        if (info.isValidFloor(localLevel) && info.getFloor(localLevel).getMetaBoolean("dontconnect")) {
            return false;
        }
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        if (info2.isValidFloor(localAdjacent) && info2.getFloor(localAdjacent).getMetaBoolean("dontconnect")) {
            return false;
        }
        int level = localAdjacent + info2.floorsBelowGround;
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.floorsBelowGround) && info2.hasConnectionAt(level, x);
    }

    private boolean hasConnectionToTopOrOutside(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        if (info.getFloor(localLevel).getMetaBoolean("dontconnect")) {
            return false;
        }
        return info2.isCity && !info2.hasBuilding && localLevel == 0 && localAdjacent == 0 || info2.hasBuilding && localAdjacent == info2.getNumFloors();
    }

    private boolean hasConnectionWithBuilding(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.floorsBelowGround);
    }

    private boolean isSide(int x, int z) {
        return x == 0 || x == 15 || z == 0 || z == 15;
    }

    private boolean isCorner(int x, int z) {
        return !(x != 0 && x != 15 || z != 0 && z != 15);
    }

    private boolean isStreetBorder(int x, int z) {
        return x <= this.streetBorder || x >= 15 - this.streetBorder || z <= this.streetBorder || z >= 15 - this.streetBorder;
    }

    static {
        rotatableStates = null;
        railStates = null;
        glassStates = null;
        statesNeedingTodo = null;
        statesNeedingLightingUpdate = null;
        randomLeafs = null;
    }

    private static class Blob
    implements Comparable<Blob> {
        private final int starty;
        private final Set<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        private final Map<Integer, Integer> blocksPerY = new HashMap<Integer, Integer>();
        private int connections = 0;
        private int lowestY;
        private int highestY;
        private float avgdamage;
        private int cntMindamage;

        public Blob(int starty) {
            this.starty = starty;
            this.lowestY = 256;
            this.highestY = 0;
        }

        public float getAvgdamage() {
            return this.avgdamage;
        }

        public int getCntMindamage() {
            return this.cntMindamage;
        }

        public boolean contains(BlockPos index) {
            return this.connectedBlocks.contains(index);
        }

        public int getLowestY() {
            return this.lowestY;
        }

        public int getHighestY() {
            return this.highestY;
        }

        public int needsSplitting() {
            float averageBlocksPerLevel = (float)this.connectedBlocks.size() / (float)(this.highestY - this.lowestY + 1);
            int connectionThreshold = (int)(averageBlocksPerLevel / 10.0f);
            if (connectionThreshold <= 0) {
                return -1;
            }
            int cuttingY = -1;
            int cuttingCount = 1000000;
            for (int y = this.lowestY; y <= this.highestY; ++y) {
                if (y < 3 || this.blocksPerY.get(y) > connectionThreshold) continue;
                if (this.blocksPerY.get(y) < cuttingCount) {
                    cuttingCount = this.blocksPerY.get(y);
                    cuttingY = y;
                    continue;
                }
                if (this.blocksPerY.get(y) <= cuttingCount * 4) continue;
                return cuttingY;
            }
            return -1;
        }

        public boolean destroyOrMoveThis(IDimensionInfo provider, BuildingInfo info) {
            return this.connections < 5 || (float)this.connections / (float)this.connectedBlocks.size() < info.profile.DESTROY_LONE_BLOCKS_FACTOR;
        }

        private boolean isOutside(BuildingInfo info, int x, int y, int z) {
            if (x < 0) {
                if (y <= info.getXmin().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (x > 15) {
                if (y <= info.getXmax().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (z < 0) {
                if (y <= info.getZmin().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (z > 15) {
                if (y <= info.getZmax().getMaxHeight() + 3) {
                    ++this.connections;
                }
                return true;
            }
            if (y < this.starty) {
                this.connections += 5;
                return true;
            }
            return false;
        }

        public void scan(BuildingInfo info, ChunkDriver driver, BlockState air, BlockState liquid, BlockPos pos) {
            DamageArea damageArea = info.getDamageArea();
            this.avgdamage = 0.0f;
            this.cntMindamage = 0;
            ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
            todo.add(pos);
            while (!todo.isEmpty()) {
                pos = (BlockPos)todo.poll();
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (this.connectedBlocks.contains(pos) || this.isOutside(info, x, y, z)) continue;
                driver.current(x, y, z);
                if (LostCityTerrainFeature.isEmpty(driver.getBlock())) continue;
                this.connectedBlocks.add(pos);
                float damage = damageArea.getDamage(x, y, z);
                if (damage < 0.01f) {
                    ++this.cntMindamage;
                }
                this.avgdamage += damage;
                if (!this.blocksPerY.containsKey(y)) {
                    this.blocksPerY.put(y, 1);
                } else {
                    this.blocksPerY.put(y, this.blocksPerY.get(y) + 1);
                }
                if (y < this.lowestY) {
                    this.lowestY = y;
                }
                if (y > this.highestY) {
                    this.highestY = y;
                }
                todo.add(pos.func_177984_a());
                todo.add(pos.func_177977_b());
                todo.add(pos.func_177974_f());
                todo.add(pos.func_177976_e());
                todo.add(pos.func_177968_d());
                todo.add(pos.func_177978_c());
            }
            this.avgdamage /= (float)this.connectedBlocks.size();
        }

        @Override
        public int compareTo(Blob o) {
            return this.lowestY - o.lowestY;
        }
    }
}

