/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CATEGORY_PROFILES = "profiles";
    public static final String[] DEFAULT_ASSETS = new String[]{"/assets/lostcities/citydata/conditions.json", "/assets/lostcities/citydata/palette.json", "/assets/lostcities/citydata/palette_desert.json", "/assets/lostcities/citydata/palette_chisel.json", "/assets/lostcities/citydata/palette_chisel_desert.json", "/assets/lostcities/citydata/highwayparts.json", "/assets/lostcities/citydata/railparts.json", "/assets/lostcities/citydata/monorailparts.json", "/assets/lostcities/citydata/buildingparts.json", "/assets/lostcities/citydata/library.json", "$lostcities/userassets.json"};
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ASSETS;
    private static final String[] DEFAULT_DIMENSION_PROFILES;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_PROFILES;
    private static Map<RegistryKey<World>, String> dimensionProfileCache;
    public static String profileFromClient;
    public static String jsonFromClient;
    public static ForgeConfigSpec.ConfigValue<String> SELECTED_PROFILE;
    public static ForgeConfigSpec.ConfigValue<String> SELECTED_CUSTOM_JSON;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    private static final ForgeConfigSpec.Builder SERVER_BUILDER;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec SERVER_CONFIG;

    public static void reset() {
        profileFromClient = null;
        jsonFromClient = null;
        dimensionProfileCache = null;
    }

    public static String getProfileForDimension(RegistryKey<World> type) {
        if (dimensionProfileCache == null) {
            String profile;
            dimensionProfileCache = new HashMap<RegistryKey<World>, String>();
            for (String dp : (List)DIMENSION_PROFILES.get()) {
                String[] split = dp.split("=");
                if (split.length != 2) {
                    LostCities.getLogger().error("Bad format for config value: '" + dp + "'!");
                    continue;
                }
                RegistryKey dimensionType = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(split[0]));
                if (dimensionType != null) {
                    String profileName = split[1];
                    LostCityProfile profile2 = LostCityConfiguration.standardProfiles.get(profileName);
                    if (profile2 != null) {
                        dimensionProfileCache.put((RegistryKey<World>)dimensionType, profileName);
                        continue;
                    }
                    LostCities.getLogger().error("Cannot find profile: " + profileName + " for dimension " + split[0] + "!");
                    continue;
                }
                LostCities.getLogger().error("Cannot find dimension: " + split[0] + "!");
            }
            String selectedProfile = (String)SELECTED_PROFILE.get();
            if ("<CHECK>".equals(selectedProfile)) {
                if (profileFromClient != null && !profileFromClient.isEmpty()) {
                    SELECTED_PROFILE.set((Object)profileFromClient);
                    if (jsonFromClient != null && !jsonFromClient.isEmpty()) {
                        SELECTED_CUSTOM_JSON.set((Object)jsonFromClient);
                    } else {
                        SELECTED_CUSTOM_JSON.set((Object)"");
                    }
                    selectedProfile = profileFromClient;
                } else {
                    SELECTED_PROFILE.set((Object)"");
                    selectedProfile = "";
                }
            }
            if (!selectedProfile.isEmpty()) {
                dimensionProfileCache.put((RegistryKey<World>)World.field_234918_g_, selectedProfile);
                String json = (String)SELECTED_CUSTOM_JSON.get();
                if (json != null && !json.isEmpty()) {
                    LostCityProfile profile3 = new LostCityProfile("customized", json);
                    if (!LostCityConfiguration.standardProfiles.containsKey("customized")) {
                        LostCityConfiguration.standardProfiles.put("customized", new LostCityProfile("customized", false));
                    }
                    LostCityConfiguration.standardProfiles.get("customized").copyFrom(profile3);
                }
            }
            if ((profile = Config.getProfileForDimension((RegistryKey<World>)World.field_234918_g_)) != null && !profile.isEmpty() && LostCityConfiguration.standardProfiles.get((Object)profile).GENERATE_NETHER) {
                dimensionProfileCache.put((RegistryKey<World>)World.field_234919_h_, "cavern");
            }
        }
        return dimensionProfileCache.get(type);
    }

    static {
        DEFAULT_DIMENSION_PROFILES = new String[]{"lostcities:lostcity=default"};
        dimensionProfileCache = null;
        profileFromClient = null;
        jsonFromClient = null;
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        SERVER_BUILDER = new ForgeConfigSpec.Builder();
        LostCityConfiguration.init(SERVER_BUILDER);
        COMMON_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        CLIENT_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        SERVER_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        DIMENSION_PROFILES = COMMON_BUILDER.comment("A list of dimensions with associated city generation profiles (format <dimensionid>=<profilename>").defineList("dimensionsWithProfiles", (List)Lists.newArrayList((Object[])DEFAULT_DIMENSION_PROFILES), s -> s instanceof String);
        ASSETS = COMMON_BUILDER.comment("A list of assets that Lost Cities will use to load city data. Paths starting with '/' are relative to the Lost City resource pack. Paths starting with '$' are relative to the main config directory").defineList("assets", (List)Lists.newArrayList((Object[])DEFAULT_ASSETS), s -> s instanceof String);
        SELECTED_PROFILE = SERVER_BUILDER.define("selectedProfile", (Object)"<CHECK>");
        SELECTED_CUSTOM_JSON = SERVER_BUILDER.define("selectedCustomJson", (Object)"");
        SERVER_BUILDER.pop();
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

