/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.util.ChestUtil;

public class CommandLootr {
    private final CommandDispatcher<CommandSource> dispatcher;
    private static List<ResourceLocation> tables = null;
    private static List<String> tableNames = null;
    private static final Map<String, UUID> profileMap = new HashMap<String, UUID>();

    public CommandLootr(CommandDispatcher<CommandSource> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public CommandLootr register() {
        this.dispatcher.register(this.builder((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lootr").requires(p -> p.func_197034_c(2)))));
        return this;
    }

    private static List<ResourceLocation> getTables() {
        if (tables == null) {
            tables = new ArrayList<ResourceLocation>(LootTables.func_215796_a());
            tableNames = tables.stream().map(ResourceLocation::toString).collect(Collectors.toList());
        }
        return tables;
    }

    private static List<String> getProfiles() {
        return Lists.newArrayList(ServerLifecycleHooks.getCurrentServer().func_152358_ax().field_152661_c.keySet());
    }

    private static List<String> getTableNames() {
        CommandLootr.getTables();
        return tableNames;
    }

    public static void createBlock(CommandSource c, @Nullable Block block, @Nullable ResourceLocation table) {
        ServerWorld world = c.func_197023_e();
        BlockPos pos = new BlockPos(c.func_197036_d());
        if (table == null) {
            table = CommandLootr.getTables().get(world.func_201674_k().nextInt(CommandLootr.getTables().size()));
        }
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Entity e = c.func_197022_f();
            if (e != null) {
                cart.field_70177_z = e.field_70177_z;
            }
            cart.func_184289_a(table, world.func_201674_k().nextLong());
            world.func_217376_c((Entity)cart);
            c.func_197030_a((ITextComponent)new TranslationTextComponent("lootr.commands.summon", new Object[]{TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("lootr.commands.blockpos", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)).func_240713_a_(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            BlockState placementState = block.func_176223_P();
            Entity e = c.func_197022_f();
            if (e != null) {
                DirectionProperty prop = null;
                Direction dir = Direction.func_196054_a((Entity)e)[0].func_176734_d();
                if (placementState.func_235901_b_((Property)LootrBarrelBlock.field_220092_a)) {
                    prop = LootrBarrelBlock.field_220092_a;
                } else if (placementState.func_235901_b_((Property)LootrChestBlock.field_176459_a)) {
                    prop = LootrChestBlock.field_176459_a;
                    dir = e.func_174811_aO().func_176734_d();
                } else if (placementState.func_235901_b_((Property)LootrShulkerBlock.field_190957_a)) {
                    prop = LootrShulkerBlock.field_190957_a;
                }
                if (prop != null) {
                    placementState = (BlockState)placementState.func_206870_a((Property)prop, (Comparable)dir);
                }
            }
            world.func_180501_a(pos, placementState, 2);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)world.func_201674_k(), (BlockPos)pos, (ResourceLocation)table);
            c.func_197030_a((ITextComponent)new TranslationTextComponent("lootr.commands.create", new Object[]{new TranslationTextComponent(block.func_149739_a()), TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("lootr.commands.blockpos", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)).func_240713_a_(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    private RequiredArgumentBuilder<CommandSource, ResourceLocation> suggestTables() {
        return Commands.func_197056_a((String)"table", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests((c, build) -> ISuggestionProvider.func_197005_b(CommandLootr.getTableNames(), (SuggestionsBuilder)build));
    }

    private RequiredArgumentBuilder<CommandSource, String> suggestProfiles() {
        return Commands.func_197056_a((String)"profile", (ArgumentType)StringArgumentType.string()).suggests((c, build) -> ISuggestionProvider.func_197005_b(CommandLootr.getProfiles(), (SuggestionsBuilder)build));
    }

    public LiteralArgumentBuilder<CommandSource> builder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> {
            ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lootr.commands.usage"), false);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"barrel").executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.BARREL, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.BARREL, ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"trapped_chest").executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.TRAPPED_CHEST, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.TRAPPED_CHEST, ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"chest").executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.CHEST, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.CHEST, ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"shulker").executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.SHULKER, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), (Block)ModBlocks.SHULKER, ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").executes(c -> {
            ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Must provide player name."), true);
            return 1;
        })).then(this.suggestProfiles().executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            GameProfile profile = ((CommandSource)c.getSource()).func_197028_i().func_152358_ax().func_152655_a(playerName);
            if (profile == null) {
                ((CommandSource)c.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Invalid player name: " + playerName + ", profile not found in the cache."));
                return 0;
            }
            ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent(DataStorage.clearInventories(profile.getId()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear"), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"cart").executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), null, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSource)c.getSource(), null, ResourceLocationArgument.func_197195_e((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(Commands.func_197057_a((String)"custom").executes(c -> {
            BlockPos pos = new BlockPos(((CommandSource)c.getSource()).func_197036_d());
            ServerWorld world = ((CommandSource)c.getSource()).func_197023_e();
            BlockState state = world.func_180495_p(pos);
            if (!state.func_203425_a(Blocks.field_150486_ae)) {
                pos = pos.func_177977_b();
                state = world.func_180495_p(pos);
            }
            if (!state.func_203425_a(Blocks.field_150486_ae)) {
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Please stand on the chest you wish to convert."), false);
            } else {
                NonNullList reference = ((ChestTileEntity)Objects.requireNonNull(world.func_175625_s((BlockPos)pos))).field_145985_p;
                NonNullList<ItemStack> custom = ChestUtil.copyItemList((NonNullList<ItemStack>)reference);
                world.func_175713_t(pos);
                world.func_175656_a(pos, (BlockState)((BlockState)ModBlocks.INVENTORY.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, state.func_177229_b((Property)ChestBlock.field_176459_a))).func_206870_a((Property)ChestBlock.field_204511_c, state.func_177229_b((Property)ChestBlock.field_204511_c)));
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof LootrInventoryTileEntity)) {
                    ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryTileEntity inventory = (LootrInventoryTileEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.func_70296_d();
                }
            }
            return 1;
        }));
        builder.then(Commands.func_197057_a((String)"id").executes(c -> {
            BlockPos pos = new BlockPos(((CommandSource)c.getSource()).func_197036_d());
            ServerWorld world = ((CommandSource)c.getSource()).func_197023_e();
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ILootTile)) {
                pos = pos.func_177977_b();
                te = world.func_175625_s(pos);
            }
            if (!(te instanceof ILootTile)) {
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Please stand on a valid Lootr chest."), false);
            } else {
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("The ID of this inventory is: " + ((ILootTile)te).getTileId().toString()), false);
            }
            return 1;
        }));
        builder.then(Commands.func_197057_a((String)"openers").then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(c -> {
            BlockPos position = Vec3Argument.func_200385_b((CommandContext)c, (String)"location").func_197280_c((CommandSource)c.getSource());
            ServerWorld world = ((CommandSource)c.getSource()).func_197023_e();
            TileEntity tile = world.func_175625_s(position);
            if (tile instanceof ILootTile) {
                Set<UUID> openers = ((ILootTile)tile).getOpeners();
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Tile at location " + position + " has " + openers.size() + " openers. UUIDs as follows:"), true);
                for (UUID uuid : openers) {
                    GameProfile profile = ((CommandSource)c.getSource()).func_197028_i().func_152358_ax().func_152652_a(uuid);
                    ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("UUID: " + uuid + ", user profile: " + (profile == null ? "null" : profile.getName())), true);
                }
            } else {
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("No Lootr tile exists at location: " + position), false);
            }
            return 1;
        })));
        return builder;
    }
}

