/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.loot.action.AddLootAction;
import com.almostreliable.lootjs.loot.action.DropExperienceAction;
import com.almostreliable.lootjs.loot.action.ExplodeAction;
import com.almostreliable.lootjs.loot.action.LightningStrikeAction;
import com.almostreliable.lootjs.loot.action.ModifyLootAction;
import com.almostreliable.lootjs.loot.action.RemoveLootAction;
import com.almostreliable.lootjs.loot.action.ReplaceLootAction;
import com.almostreliable.lootjs.loot.action.WeightedAddLootAction;
import net.minecraft.class_1927;
import net.minecraft.class_44;
import net.minecraft.class_5658;
import net.minecraft.class_6005;

public interface LootActionsContainer<A extends LootActionsContainer<?>> {
    default public A addLoot(LootEntry ... entries) {
        return this.addAction(new AddLootAction(entries));
    }

    default public A addAlternativesLoot(LootEntry ... entries) {
        return this.addAction(new AddLootAction(entries, AddLootAction.AddType.ALTERNATIVES));
    }

    default public A addSequenceLoot(LootEntry ... entries) {
        return this.addAction(new AddLootAction(entries, AddLootAction.AddType.SEQUENCE));
    }

    default public A addWeightedLoot(class_5658 numberProvider, boolean allowDuplicateLoot, LootEntry[] poolEntries) {
        class_6005.class_6006 weightedListBuilder = class_6005.method_34971();
        for (LootEntry poolEntry : poolEntries) {
            weightedListBuilder.method_34975((Object)poolEntry, poolEntry.getWeight());
        }
        return this.addAction(new WeightedAddLootAction(numberProvider, (class_6005<LootEntry>)weightedListBuilder.method_34974(), allowDuplicateLoot));
    }

    default public A addWeightedLoot(class_5658 numberProvider, LootEntry[] poolEntries) {
        return this.addWeightedLoot(numberProvider, true, poolEntries);
    }

    default public A addWeightedLoot(LootEntry[] poolEntries) {
        return this.addWeightedLoot((class_5658)class_44.method_32448((float)1.0f), true, poolEntries);
    }

    default public A removeLoot(ItemFilter filter) {
        return this.addAction(new RemoveLootAction(filter));
    }

    default public A replaceLoot(ItemFilter filter, LootEntry lootEntry) {
        return this.replaceLoot(filter, lootEntry, false);
    }

    default public A replaceLoot(ItemFilter filter, LootEntry lootEntry, boolean preserveCount) {
        return this.addAction(new ReplaceLootAction(filter, lootEntry, preserveCount));
    }

    default public A modifyLoot(ItemFilter filter, ModifyLootAction.Callback callback) {
        return this.addAction(new ModifyLootAction(filter, callback));
    }

    default public A triggerExplosion(float radius, boolean destroy, boolean fire) {
        class_1927.class_4179 mode = destroy ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878;
        return this.addAction(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerExplosion(float radius, class_1927.class_4179 mode, boolean fire) {
        return this.addAction(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerLightningStrike(boolean shouldDamage) {
        return this.addAction(new LightningStrikeAction(shouldDamage));
    }

    default public A dropExperience(int amount) {
        return this.addAction(new DropExperienceAction(amount));
    }

    public A addAction(ILootAction var1);
}

