/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.filters;

import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1766;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1811;
import net.minecraft.class_1812;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;

public interface ItemFilter
extends Predicate<class_1799> {
    public static final ItemFilter ALWAYS_FALSE = itemStack -> false;
    public static final ItemFilter ALWAYS_TRUE = itemStack -> true;
    public static final ItemFilter SWORD = itemStack -> itemStack.method_7909() instanceof class_1829;
    public static final ItemFilter PICKAXE = itemStack -> itemStack.method_7909() instanceof class_1810;
    public static final ItemFilter AXE = itemStack -> itemStack.method_7909() instanceof class_1743;
    public static final ItemFilter SHOVEL = itemStack -> itemStack.method_7909() instanceof class_1821;
    public static final ItemFilter HOE = itemStack -> itemStack.method_7909() instanceof class_1794;
    public static final ItemFilter TOOL = itemStack -> itemStack.method_7909() instanceof class_1766;
    public static final ItemFilter POTION = itemStack -> itemStack.method_7909() instanceof class_1812;
    public static final ItemFilter HAS_TIER = itemStack -> itemStack.method_7909() instanceof class_1831;
    public static final ItemFilter PROJECTILE_WEAPON = itemStack -> itemStack.method_7909() instanceof class_1811;
    public static final ItemFilter ARMOR = itemStack -> itemStack.method_7909() instanceof class_1738;
    public static final ItemFilter WEAPON = itemStack -> {
        class_1792 i = itemStack.method_7909();
        return i instanceof class_1829 || i instanceof class_1766 || i instanceof class_1811 || i instanceof class_1835;
    };
    public static final ItemFilter HEAD_ARMOR = ItemFilter.equipmentSlot(class_1304.field_6169);
    public static final ItemFilter CHEST_ARMOR = ItemFilter.equipmentSlot(class_1304.field_6174);
    public static final ItemFilter LEGS_ARMOR = ItemFilter.equipmentSlot(class_1304.field_6172);
    public static final ItemFilter FEET_ARMOR = ItemFilter.equipmentSlot(class_1304.field_6166);
    public static final ItemFilter FOOD = class_1799::method_19267;
    public static final ItemFilter DAMAGEABLE = class_1799::method_7963;
    public static final ItemFilter DAMAGED = class_1799::method_7986;
    public static final ItemFilter ENCHANTABLE = class_1799::method_7923;
    public static final ItemFilter ENCHANTED = class_1799::method_7942;
    public static final ItemFilter BLOCK = itemStack -> itemStack.method_7909() instanceof class_1747;

    public static ItemFilter hasEnchantment(ResourceLocationFilter filter) {
        return ItemFilter.hasEnchantment(filter, 1, 255);
    }

    public static ItemFilter hasEnchantment(ResourceLocationFilter filter, int min, int max) {
        return itemStack -> {
            class_2499 listTag = itemStack.method_31574(class_1802.field_8598) ? class_1772.method_7806((class_1799)itemStack) : itemStack.method_7921();
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 tag = listTag.method_10602(i);
                class_2960 id = class_1890.method_37427((class_2487)tag);
                int level = class_1890.method_37424((class_2487)tag);
                if (id == null || !filter.test(id) || min > level || level > max) continue;
                return true;
            }
            return false;
        };
    }

    public static ItemFilter equipmentSlot(class_1304 slot) {
        return itemStack -> class_1309.method_32326((class_1799)itemStack) == slot;
    }

    public static ItemFilter and(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].and(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (itemFilter.test(itemStack)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static ItemFilter not(ItemFilter itemFilter) {
        return itemFilter.negate();
    }

    public static ItemFilter or(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ALWAYS_FALSE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].or(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (!itemFilter.test(itemStack)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    public static ItemFilter custom(Predicate<class_1799> predicate) {
        return predicate::test;
    }

    @Override
    public boolean test(class_1799 var1);

    default public ItemFilter and(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) && other.test(itemStack);
    }

    default public ItemFilter negate() {
        return itemS -> !this.test(itemS);
    }

    default public ItemFilter or(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) || other.test(itemStack);
    }
}

