/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core;

import com.almostreliable.lootjs.core.ILootCondition;
import com.almostreliable.lootjs.kube.LootConditionsContainer;
import com.almostreliable.lootjs.loot.LootFunctionsContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_47;
import net.minecraft.class_79;

public class LootEntry
implements LootFunctionsContainer<LootEntry> {
    private final Generator generator;
    private final List<class_117> postModifications = new ArrayList<class_117>();
    private final List<ILootCondition> conditions = new ArrayList<ILootCondition>();
    private int weight = 1;

    public LootEntry(class_1792 item) {
        this.generator = new ItemGenerator(new class_1799((class_1935)item));
    }

    public LootEntry(class_1799 itemStack) {
        this.generator = new ItemGenerator(itemStack);
    }

    public LootEntry(Generator generator) {
        this.generator = generator;
    }

    @Nullable
    public class_1799 createItem(class_47 context) {
        if (!this.matchesConditions(context)) {
            return null;
        }
        class_1799 itemStack = this.generator.create(context);
        if (itemStack == null) {
            return null;
        }
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 result = itemStack.method_7972();
        for (class_117 lootItemFunction : this.postModifications) {
            result = (class_1799)lootItemFunction.apply((Object)result, (Object)context);
        }
        return result;
    }

    @Override
    public LootEntry addFunction(class_117 lootItemFunction) {
        this.postModifications.add(lootItemFunction);
        return this;
    }

    public boolean matchesConditions(class_47 context) {
        for (ILootCondition condition : this.conditions) {
            if (condition.test(context)) continue;
            return false;
        }
        return true;
    }

    public boolean hasWeight() {
        return this.weight >= 1;
    }

    public int getWeight() {
        return this.weight;
    }

    public LootEntry withWeight(int weight) {
        this.weight = Math.max(1, weight);
        return this;
    }

    public LootEntry withChance(int chance) {
        return this.withWeight(chance);
    }

    public LootEntry when(Consumer<LootConditionsContainer<?>> action) {
        final ArrayList conditions = new ArrayList();
        LootConditionsContainer lcc = new LootConditionsContainer<LootConditionsContainer<?>>(){

            @Override
            public LootConditionsContainer<?> addCondition(ILootCondition condition) {
                conditions.add(condition);
                return this;
            }
        };
        action.accept(lcc);
        this.conditions.addAll(conditions);
        return this;
    }

    public record ItemGenerator(class_1799 item) implements Generator
    {
        @Override
        @Nullable
        public class_1799 create(class_47 context) {
            return this.item;
        }
    }

    public static interface Generator {
        @Nullable
        public class_1799 create(class_47 var1);
    }

    public record VanillaWrappedLootEntry(class_79 entry) implements Generator
    {
        @Override
        public class_1799 create(class_47 context) {
            ArrayList items = new ArrayList();
            this.entry.expand(context, entry -> entry.method_426(items::add, context));
            if (items.isEmpty()) {
                return null;
            }
            return (class_1799)items.get(context.method_294().method_43048(items.size()));
        }
    }

    public record RandomIngredientGenerator(class_1856 ingredient) implements Generator
    {
        @Override
        @Nullable
        public class_1799 create(class_47 context) {
            class_1799[] items = this.ingredient.method_8105();
            if (items.length == 0) {
                return class_1799.field_8037;
            }
            int index = context.method_294().method_43048(items.length);
            return items[index];
        }
    }
}

