/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.loot.results.LootContextInfo;
import com.almostreliable.lootjs.loot.results.LootInfoCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModificationsAPI {
    public static final List<ResourceLocationFilter> FILTERS = new ArrayList<ResourceLocationFilter>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ILootAction> actions = new ArrayList<ILootAction>();
    public static Consumer<String> DEBUG_ACTION = arg_0 -> ((Logger)LOGGER).info(arg_0);
    public static boolean LOOT_MODIFICATION_LOGGING = false;
    public static boolean DISABLE_WITHER_DROPPING_NETHER_STAR = false;
    public static boolean DISABLE_ZOMBIE_DROPPING_HEAD = false;
    public static boolean DISABLE_SKELETON_DROPPING_HEAD = false;
    public static boolean DISABLE_CREEPER_DROPPING_HEAD = false;

    private LootModificationsAPI() {
    }

    public static void reload() {
        actions.clear();
        LOOT_MODIFICATION_LOGGING = false;
        FILTERS.clear();
        FILTERS.add(new ResourceLocationFilter.ByLocation(new class_2960("minecraft:blocks/fire")));
    }

    public static void invokeActions(List<class_1799> loot, class_47 context) {
        ILootContextData contextData = (ILootContextData)context.method_296(LootJSParamSets.DATA);
        assert (contextData != null);
        for (ResourceLocationFilter filter : FILTERS) {
            if (!filter.test(LootJSPlatform.INSTANCE.getQueriedLootTableId(context))) continue;
            return;
        }
        context.method_299().method_16107().method_15396("LootModificationsAPI::invokeActions");
        loot.removeIf(class_1799::method_7960);
        contextData.setGeneratedLoot(loot);
        LootContextInfo lootContextInfo = LootContextInfo.create(context);
        for (ILootAction modification : actions) {
            modification.applyLootHandler(context, loot);
            contextData.reset();
        }
        LootModificationsAPI.handleCollector(context, lootContextInfo);
        context.method_299().method_16107().method_15407();
    }

    private static void handleCollector(class_47 context, @Nullable LootContextInfo lootContextInfo) {
        if (DEBUG_ACTION == null || !LOOT_MODIFICATION_LOGGING || lootContextInfo == null) {
            return;
        }
        LootInfoCollector collector = (LootInfoCollector)context.method_296(LootJSParamSets.RESULT_COLLECTOR);
        ILootContextData data = (ILootContextData)context.method_296(LootJSParamSets.DATA);
        if (collector == null || data == null || collector.getFirstLayer().isEmpty()) {
            return;
        }
        lootContextInfo.updateLoot(data.getGeneratedLoot());
        StringBuilder sb = new StringBuilder().append("\n").append("[ Loot information ]").append("\n");
        lootContextInfo.getCollector().append(sb, 1);
        sb.append("[ Modifications  ]").append("\n");
        collector.append(sb, 1);
        DEBUG_ACTION.accept(sb.toString());
    }

    public static void addModification(ILootAction action) {
        actions.add(action);
    }
}

