/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.wiki.page.panel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.screen.Texture;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.client.screen.wiki.WikiScreen;
import owmii.lib.client.util.MC;
import owmii.lib.client.wiki.Section;
import owmii.lib.client.wiki.page.panel.ItemPanel;

public class CraftingPanel<T extends IItemProvider>
extends ItemPanel<T> {
    private int currRecipe;
    @OnlyIn(value=Dist.CLIENT)
    private IconButton nextRecipe = IconButton.EMPTY;
    @OnlyIn(value=Dist.CLIENT)
    private IconButton prevRecipe = IconButton.EMPTY;

    public CraftingPanel(Section parent) {
        super(parent);
    }

    public CraftingPanel(T item, Section parent) {
        super(item, parent);
    }

    public CraftingPanel(List<T> items, Section parent) {
        super(items, parent);
    }

    public CraftingPanel(IItemProvider[] items, Section parent) {
        super(items, parent);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init(int x, int y, WikiScreen screen) {
        super.init(x, y, screen);
        this.nextRecipe = screen.addButton2(new IconButton(x + 144, y + 140, Texture.WIKI_ITM_NEXT, button -> {
            if (this.currRecipe < this.getRecipe().size() - 1) {
                ++this.currRecipe;
                screen.setPanel(this);
                MC.open(screen);
            }
        }, screen));
        this.prevRecipe = screen.addButton2(new IconButton(x + 6, y + 140, Texture.WIKI_ITM_PREV, button -> {
            if (this.currRecipe > 0) {
                --this.currRecipe;
                screen.setPanel(this);
                MC.open(screen);
            }
        }, screen));
        this.refresh();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void refresh() {
        super.refresh();
        this.currRecipe = MathHelper.func_76125_a((int)this.currRecipe, (int)0, (int)Math.max(0, this.getRecipe().size() - 1));
        this.nextRecipe.field_230694_p_ = this.currRecipe < this.getRecipe().size() - 1;
        this.prevRecipe.field_230694_p_ = this.currRecipe > 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrix, int x, int y, int mx, int my, float pt, FontRenderer font, WikiScreen screen) {
        super.render(matrix, x, y, mx, my, pt, font, screen);
        if (0 <= this.currRecipe && this.currRecipe < this.getRecipe().size()) {
            int i;
            NonNullList ingredients = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
            NonNullList ingredients1 = this.getRecipe().get(this.currRecipe).func_192400_c();
            for (i = 0; i < ingredients1.size(); ++i) {
                ingredients.set(i, ingredients1.get(i));
            }
            if (!ingredients.isEmpty()) {
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        int id = j + i * 3;
                        Ingredient ingredient = (Ingredient)ingredients.get(id);
                        ItemStack[] stacks = ingredient.func_193365_a();
                        RenderSystem.pushMatrix();
                        RenderSystem.translatef((float)(x + 24 + j * 40), (float)(y + 90 + i * 40), (float)0.0f);
                        Texture.WIKI_RCP_FRM.draw(matrix, 0, 0);
                        if (stacks.length > 0) {
                            boolean b = ingredients1.size() == 4 && id == 2;
                            RenderSystem.translatef((float)(b ? -36.0f : 4.0f), (float)(b ? 44.0f : 4.0f), (float)0.0f);
                            RenderSystem.scaled((double)1.5, (double)1.5, (double)1.0);
                            ItemStack stack = stacks[MathHelper.func_76141_d((float)((float)MC.ticks / 20.0f)) % stacks.length];
                            if (Texture.WIKI_RCP_FRM.isMouseOver(x + 24 + j * 40, y + 90 + i * 40, mx, my)) {
                                screen.hoveredStack = stack;
                            }
                            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
                        }
                        RenderSystem.popMatrix();
                    }
                }
            }
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double i) {
        if (mouseY > 90.0) {
            if (i == -1.0 && this.nextRecipe.field_230694_p_) {
                this.nextRecipe.func_230930_b_();
                return true;
            }
            if (i == 1.0 && this.prevRecipe.field_230694_p_) {
                this.prevRecipe.func_230930_b_();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, i);
    }

    protected List<IRecipe<?>> getRecipe() {
        return this.getWiki().getCrafting().getOrDefault(this.getItem(), new ArrayList());
    }
}

