/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen.wiki;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.screen.ScreenBase;
import owmii.lib.client.screen.Texture;
import owmii.lib.client.util.MC;
import owmii.lib.client.util.Text;
import owmii.lib.client.wiki.Entry;
import owmii.lib.client.wiki.Page;
import owmii.lib.client.wiki.Section;
import owmii.lib.client.wiki.page.panel.Panel;

@OnlyIn(value=Dist.CLIENT)
public class WikiScreen
extends ScreenBase {
    private final Entry entry;
    private Page page;
    private Panel panel;
    public ItemStack hoveredStack = ItemStack.field_190927_a;
    @Nullable
    public static WikiScreen last;

    public WikiScreen(Section section) {
        super((ITextComponent)Text.EMPTY);
        this.w = Texture.WIKI_BG_0.getWidth() + Texture.WIKI_BG_1.getWidth() + 28;
        this.h = Texture.WIKI_BG_0.getHeight();
        this.entry = section.getEntry();
        this.page = section.getPage();
        this.panel = (Panel)section.getPanel();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.page.init(this.x, this.y, this);
        this.panel.init(this.x + 246, this.y, this);
        last = this;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.page.refresh();
        this.panel.refresh();
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mx, int my, float pt) {
        this.func_230446_a_(matrix);
        this.hoveredStack = ItemStack.field_190927_a;
        Texture.WIKI_BG_0.draw(matrix, this.x + 28, this.y);
        Texture.WIKI_BG_1.draw(matrix, this.x + 28 + Texture.WIKI_BG_0.getWidth(), this.y);
        this.page.render(matrix, this.x + 31, this.y + 3, mx, my, pt, this.field_230712_o_, this);
        this.panel.render(matrix, this.x + 246, this.y + 3, mx, my, pt, this.field_230712_o_, this);
        super.func_230430_a_(matrix, mx, my, pt);
        if (!this.hoveredStack.func_190926_b()) {
            this.func_230457_a_(matrix, this.hoveredStack, mx, my);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double i) {
        if (this.isMouseOver(this.x + 31, this.y + 3, 212, 224, mouseX, mouseY) ? this.page.mouseScrolled(mouseX, mouseY, i) : this.isMouseOver(this.x + 246, this.y + 3, 161, 224, mouseX, mouseY) && this.panel.mouseScrolled(mouseX, mouseY, i)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, i);
    }

    public void func_231175_as__() {
        this.page.onClose();
        this.panel.onClose();
        super.func_231175_as__();
    }

    public static void open(Entry entry) {
        if (last != null) {
            MC.open(last);
        } else {
            MC.open(new WikiScreen(entry.getSections().get(0)));
        }
    }

    public Page getPage() {
        return this.page;
    }

    public WikiScreen setPage(Page page) {
        this.page = page;
        return this;
    }

    public Page getPanel() {
        return this.panel;
    }

    public WikiScreen setPanel(Panel panel) {
        this.panel = panel;
        return this;
    }

    @Nullable
    public static WikiScreen getLast() {
        return last;
    }

    public Entry getEntry() {
        return this.entry;
    }
}

