/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import owmii.lib.client.screen.Texture;
import owmii.lib.logistics.inventory.AbstractContainer;
import owmii.lib.logistics.inventory.slot.ITexturedSlot;

public class AbstractContainerScreen<C extends AbstractContainer>
extends ContainerScreen<C> {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final Texture backGround;
    @Nullable
    protected Runnable delayedClick;
    protected int clickDelay;

    public AbstractContainerScreen(C container, PlayerInventory inv, ITextComponent title, Texture backGround) {
        super(container, inv, title);
        this.backGround = backGround;
        this.field_146999_f = backGround.getWidth();
        this.field_147000_g = backGround.getHeight();
    }

    public void setDelayedClick(int delay, @Nullable Runnable delayedClick) {
        this.clickDelay = delay;
        this.delayedClick = delayedClick;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.delayedClick != null && this.clickDelay >= 0) {
            --this.clickDelay;
            if (this.clickDelay == 0) {
                this.delayedClick.run();
                this.delayedClick = null;
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(matrix, partialTicks, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.drawForeground(matrix, mouseX, mouseY);
    }

    protected void func_230459_a_(MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230459_a_(matrix, mouseX, mouseY);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX, mouseY);
            return;
        }
    }

    protected void drawBackground(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.backGround.draw(matrix, this.field_147003_i, this.field_147009_r);
    }

    protected void drawForeground(MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitle(matrix, 0, 0);
    }

    protected void drawTitle(MatrixStack matrix, int x, int y) {
        String title = this.field_230704_d_.getString();
        int width = this.field_230712_o_.func_78256_a(title);
        this.field_230712_o_.func_238405_a_(matrix, title, (float)(x + this.field_146999_f / 2 - width / 2), (float)y - 14.0f, 0x999999);
    }

    public void func_238746_a_(MatrixStack matrixStack, Slot slot) {
        if (slot instanceof ITexturedSlot) {
            ITexturedSlot base = (ITexturedSlot)slot;
            int x = slot.field_75223_e;
            int y = slot.field_75221_f;
            base.getBackground2().draw(matrixStack, x, y);
            if (!slot.func_75216_d()) {
                RenderSystem.pushMatrix();
                RenderSystem.enableBlend();
                base.getOverlay().draw(matrixStack, x, y);
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
        }
        super.func_238746_a_(matrixStack, slot);
    }

    public void bindTexture(ResourceLocation guiTexture) {
        this.mc.func_110434_K().func_110577_a(guiTexture);
    }

    public boolean isMouseOver(double mouseX, double mouseY, int w, int h) {
        return mouseX >= (double)this.field_147003_i && mouseY >= (double)this.field_147009_r && mouseX < (double)(this.field_147003_i + w) && mouseY < (double)(this.field_147009_r + h);
    }

    protected <T extends Widget> T addWidget(T w) {
        this.field_230710_m_.add(w);
        return (T)((Widget)this.func_230481_d_((IGuiEventListener)w));
    }

    public List<Rectangle2d> getExtraAreas() {
        return new ArrayList<Rectangle2d>();
    }

    protected Rectangle2d toRectangle2d(int x, int y, Texture texture) {
        return new Rectangle2d(x, y, texture.getWidth(), texture.getHeight());
    }

    protected Rectangle2d toRectangle2d(Widget widget) {
        return new Rectangle2d(widget.field_230690_l_, widget.field_230691_m_, widget.func_230998_h_(), widget.func_238483_d_());
    }
}

