/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.hopper;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.common.hopper.StorableItemStack;
import me.jellysquid.mods.lithium.common.util.tuples.RefIntPair;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements StorableItemStack {
    @Shadow
    private int field_8031;
    private int mySlot;
    @Nullable
    private Object myLocation;

    @Override
    public void registerToInventory(LithiumStackList itemStacks, int mySlot) {
        if (this.myLocation != null) {
            this.lithiumRegisterMultipleInventories(itemStacks, mySlot);
        } else {
            this.myLocation = itemStacks;
            this.mySlot = mySlot;
        }
    }

    @Override
    public void unregisterFromInventory(LithiumStackList stackList) {
        this.unregisterFromInventory(stackList, -1);
    }

    @Override
    public void unregisterFromInventory(LithiumStackList myInventoryList, int index) {
        if (this.myLocation == myInventoryList) {
            this.myLocation = null;
            this.mySlot = -1;
        } else if (this.myLocation instanceof Set) {
            this.lithiumUnregisterMultipleInventories(myInventoryList, index);
        } else {
            this.myLocation = null;
        }
    }

    @ModifyVariable(method={"setCount(I)V"}, at=@At(value="HEAD"))
    public int updateInventory(int count) {
        if (this.myLocation != null && this.field_8031 != count) {
            Object object = this.myLocation;
            if (object instanceof LithiumStackList) {
                LithiumStackList stackList = (LithiumStackList)object;
                stackList.beforeSlotCountChange(this.mySlot, count);
            } else {
                this.lithiumUpdateMultipleInventories();
            }
        }
        return count;
    }

    private void lithiumRegisterMultipleInventories(LithiumStackList itemStacks, int mySlot) {
        RefIntPair<LithiumStackList> pair;
        Set stackLists;
        if (this.myLocation instanceof Set) {
            stackLists = (Set)this.myLocation;
        } else {
            stackLists = new ObjectOpenHashSet();
            if (this.myLocation != null) {
                pair = new RefIntPair<LithiumStackList>((LithiumStackList)this.myLocation, this.mySlot);
                stackLists.add(pair);
                this.myLocation = stackLists;
                this.mySlot = -1;
            }
        }
        pair = new RefIntPair<LithiumStackList>(itemStacks, mySlot);
        stackLists.add(pair);
    }

    private void lithiumUnregisterMultipleInventories(LithiumStackList itemStacks, int mySlot) {
        Object object = this.myLocation;
        if (object instanceof Set) {
            Set set;
            Set stackLists = set = (Set)object;
            if (mySlot >= 0) {
                stackLists.remove(new RefIntPair<LithiumStackList>(itemStacks, mySlot));
            } else {
                stackLists.removeIf(stackListSlotPair -> stackListSlotPair.left() == itemStacks);
            }
        }
    }

    private void lithiumUpdateMultipleInventories() {
        Object object = this.myLocation;
        if (object instanceof Set) {
            Set set;
            Set stackLists = set = (Set)object;
            for (RefIntPair stackListLocationPair : stackLists) {
                ((LithiumStackList)stackListLocationPair.left()).beforeSlotCountChange(stackListLocationPair.right(), this.field_8031);
            }
        }
    }
}

