/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.nearby_entity_tracking;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import me.jellysquid.mods.lithium.common.entity.PositionedEntityTrackingSection;
import me.jellysquid.mods.lithium.common.entity.nearby_tracker.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.entity.nearby_tracker.NearbyEntityListenerSection;
import net.minecraft.class_1297;
import net.minecraft.class_3509;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5584;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5572.class})
public abstract class EntityTrackingSectionMixin<T extends class_5568>
implements NearbyEntityListenerSection,
PositionedEntityTrackingSection {
    @Shadow
    private class_5584 field_27249;
    @Shadow
    @Final
    private class_3509<T> field_27248;
    private final ReferenceOpenHashSet<NearbyEntityListener> nearbyEntityListeners = new ReferenceOpenHashSet(0);

    @Shadow
    public abstract boolean method_31761();

    @Override
    public void addListener(NearbyEntityListener listener) {
        this.nearbyEntityListeners.add((Object)listener);
        if (this.field_27249.method_31885()) {
            listener.onSectionEnteredRange(this, this.field_27248);
        }
    }

    @Override
    public void removeListener(class_5573<?> sectionedEntityCache, NearbyEntityListener listener) {
        boolean removed = this.nearbyEntityListeners.remove((Object)listener);
        if (this.field_27249.method_31885() && removed) {
            listener.onSectionLeftRange(this, this.field_27248);
        }
        if (this.method_31761()) {
            sectionedEntityCache.method_31786(this.getPos());
        }
    }

    @Inject(method={"isEmpty()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> cir) {
        if (!this.nearbyEntityListeners.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/entity/EntityLike;)V"}, at={@At(value="RETURN")})
    private void onEntityAdded(T entityLike, CallbackInfo ci) {
        if (!this.field_27249.method_31885() || this.nearbyEntityListeners.isEmpty()) {
            return;
        }
        if (entityLike instanceof class_1297) {
            class_1297 entity = (class_1297)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityEnteredRange(entity);
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/EntityLike;)Z"}, at={@At(value="RETURN")})
    private void onEntityRemoved(T entityLike, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_27249.method_31885() && !this.nearbyEntityListeners.isEmpty() && entityLike instanceof class_1297) {
            class_1297 entity = (class_1297)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityLeftRange(entity);
            }
        }
    }

    @ModifyVariable(method={"swapStatus(Lnet/minecraft/world/entity/EntityTrackingStatus;)Lnet/minecraft/world/entity/EntityTrackingStatus;"}, at=@At(value="HEAD"), argsOnly=true)
    public class_5584 swapStatus(class_5584 newStatus) {
        block3: {
            block4: {
                if (this.field_27249.method_31885() == newStatus.method_31885()) break block3;
                if (newStatus.method_31885()) break block4;
                if (this.nearbyEntityListeners.isEmpty()) break block3;
                for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                    nearbyEntityListener.onSectionLeftRange(this, this.field_27248);
                }
                break block3;
            }
            if (!this.nearbyEntityListeners.isEmpty()) {
                for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                    nearbyEntityListener.onSectionEnteredRange(this, this.field_27248);
                }
            }
        }
        return newStatus;
    }
}

