/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.math;

import net.minecraft.class_3532;

public class CompactSineLUT {
    private static final int[] SINE_TABLE_INT;
    private static final float SINE_TABLE_MIDPOINT;

    public static float sin(float f) {
        return CompactSineLUT.lookup((int)(f * 10430.378f) & 0xFFFF);
    }

    public static float cos(float f) {
        return CompactSineLUT.lookup((int)(f * 10430.378f + 16384.0f) & 0xFFFF);
    }

    private static float lookup(int index) {
        if (index == 32768) {
            return SINE_TABLE_MIDPOINT;
        }
        int neg = (index & 0x8000) << 16;
        int mask = index << 17 >> 31;
        int pos = (0x8001 & mask) + (index ^ mask);
        return Float.intBitsToFloat(SINE_TABLE_INT[pos &= Short.MAX_VALUE] ^ neg);
    }

    static {
        int i;
        SINE_TABLE_INT = new int[16385];
        for (i = 0; i < SINE_TABLE_INT.length; ++i) {
            CompactSineLUT.SINE_TABLE_INT[i] = Float.floatToRawIntBits(class_3532.field_15725[i]);
        }
        SINE_TABLE_MIDPOINT = class_3532.field_15725[class_3532.field_15725.length / 2];
        for (i = 0; i < class_3532.field_15725.length; ++i) {
            float expected = class_3532.field_15725[i];
            float value = CompactSineLUT.lookup(i);
            if (expected == value) continue;
            throw new IllegalArgumentException(String.format("LUT error at index %d (expected: %s, found: %s)", i, Float.valueOf(expected), Float.valueOf(value)));
        }
    }
}

