/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common;

import architectury_inject_lightoverlay_common_77e7a66500f84c178beb4d3407328799_5e770ce14bcdc200bcfe71239fa5ffad3671fe50ffa2e89301876ce895dafbd9lightoverlay800devjar.PlatformMethods;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.lightoverlay.common.CubicChunkPos;
import me.shedaniel.lightoverlay.common.LightOverlayRenderer;
import me.shedaniel.lightoverlay.common.LightOverlayTicker;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;

public class LightOverlay {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    public static int reach = 12;
    public static int crossLevel = 0;
    public static int secondaryLevel = 7;
    public static int lowerCrossLevel = -1;
    public static int higherCrossLevel = -1;
    public static boolean caching = false;
    public static boolean showNumber = false;
    public static boolean underwater = false;
    public static boolean mushroom = false;
    public static float lineWidth = 1.0f;
    public static int yellowColor = 0xFFFF00;
    public static int redColor = 0xFF0000;
    public static int secondaryColor = 255;
    public static File configFile;
    public static class_304 enableOverlay;
    public static boolean enabled;
    public static LightOverlayTicker ticker;
    public static LightOverlayRenderer renderer;
    public static final byte CROSS_YELLOW = 0;
    public static final byte CROSS_RED = 1;
    public static final byte CROSS_SECONDARY = 2;
    public static final byte CROSS_NONE = 3;
    public static byte higherCross;
    public static byte lowerCross;

    public static void register() {
        configFile = new File(Platform.getConfigFolder().toFile(), "lightoverlay.properties");
        LightOverlay.loadConfig(configFile);
        enableOverlay = LightOverlay.createKeyBinding(new class_2960("lightoverlay", "enable_overlay"), class_3675.class_307.field_1668, 296, "key.lightoverlay.category");
        KeyMappingRegistry.register((class_304)enableOverlay);
        LightOverlay.registerDebugRenderer(renderer);
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(list -> {
            if (enabled) {
                if (caching) {
                    list.add(String.format("[Light Overlay] Chunks to queue: %02d", LightOverlay.ticker.POS.size()));
                } else {
                    list.add("[Light Overlay] Enabled");
                }
            } else {
                list.add("[Light Overlay] Disabled");
            }
        });
        ClientTickEvent.CLIENT_POST.register(ticker::tick);
    }

    public static void queueChunkAndNear(CubicChunkPos pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    LightOverlay.queueChunk(new CubicChunkPos(pos.x + xOffset, pos.y + yOffset, pos.z + zOffset));
                }
            }
        }
    }

    public static void queueChunk(CubicChunkPos pos) {
        ticker.queueChunk(pos);
    }

    public static int getChunkRange() {
        return Math.max(class_3532.method_15386((float)((float)reach / 16.0f)), 1);
    }

    public static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            if (!file.exists() || !file.canRead()) {
                LightOverlay.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            secondaryLevel = Integer.parseInt((String)properties.computeIfAbsent("secondaryLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            caching = ((String)properties.computeIfAbsent("cachingData", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            mushroom = ((String)properties.computeIfAbsent("mushroom", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            g = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            secondaryColor = (r << 16) + (g << 8) + b;
            LightOverlay.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            crossLevel = 0;
            secondaryLevel = 7;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            caching = true;
            showNumber = false;
            underwater = false;
            mushroom = false;
            try {
                LightOverlay.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (secondaryLevel >= crossLevel) {
            higherCross = (byte)2;
            lowerCross = 0;
        } else {
            higherCross = 0;
            lowerCross = (byte)2;
        }
        lowerCrossLevel = Math.min(crossLevel, secondaryLevel);
        higherCrossLevel = Math.max(crossLevel, secondaryLevel);
        LightOverlay.ticker.CHUNK_MAP.clear();
        LightOverlay.ticker.POS.clear();
    }

    public static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryLevel=" + secondaryLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("cachingData=" + caching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("mushroom=" + mushroom).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorRed=" + (secondaryColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorGreen=" + (secondaryColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorBlue=" + (secondaryColor & 0xFF)).getBytes());
        fos.close();
    }

    private static class_304 createKeyBinding(class_2960 id, class_3675.class_307 type, int code, String category) {
        return new class_304("key." + id.method_12836() + "." + id.method_12832(), type, code, category);
    }

    private static void registerDebugRenderer(Consumer<class_4587> runnable) {
        try {
            Class.forName("me.shedaniel.lightoverlay." + PlatformMethods.getCurrentTarget() + ".LightOverlayImpl").getDeclaredField("debugRenderer").set(null, runnable);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        enabled = false;
        ticker = new LightOverlayTicker();
        renderer = new LightOverlayRenderer(ticker);
        higherCross = 0;
        lowerCross = (byte)2;
    }
}

