/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.fabric;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.io.Closeable;
import me.shedaniel.lightoverlay.common.fabric.LightOverlay;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_3726;
import org.lwjgl.opengl.GL11;

public class ChunkData
implements Closeable {
    private static final IllegalStateException WRONG_TYPE = new IllegalStateException("Wrong type accessed!");
    private Long2ByteMap data;
    private int glListIndex = 0;
    private boolean generatedList = false;

    public ChunkData() {
        this((Long2ByteMap)new Long2ByteOpenHashMap());
    }

    public ChunkData(Long2ByteMap data) {
        this.data = data;
    }

    public Long2ByteMap data() {
        return this.data;
    }

    private void compileList(class_1937 level, class_3726 collisionContext) {
        byte crossType;
        this.generatedList = true;
        if (this.data().isEmpty()) {
            this.glListIndex = 0;
            return;
        }
        this.glListIndex = GL11.glGenLists((int)3);
        GL11.glNewList((int)this.glListIndex, (int)4864);
        GL11.glBegin((int)1);
        ChunkData.color(LightOverlay.redColor);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (Long2ByteMap.Entry objectEntry : this.data().long2ByteEntrySet()) {
            crossType = objectEntry.getByteValue();
            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
            if (crossType != 1) continue;
            ChunkData.renderCross(level, (class_2338)mutable, collisionContext);
        }
        GL11.glEnd();
        GL11.glEndList();
        GL11.glNewList((int)(this.glListIndex + 1), (int)4864);
        GL11.glBegin((int)1);
        ChunkData.color(LightOverlay.yellowColor);
        for (Long2ByteMap.Entry objectEntry : this.data().long2ByteEntrySet()) {
            crossType = objectEntry.getByteValue();
            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
            if (crossType != 0) continue;
            ChunkData.renderCross(level, (class_2338)mutable, collisionContext);
        }
        GL11.glEnd();
        GL11.glEndList();
        GL11.glNewList((int)(this.glListIndex + 2), (int)4864);
        GL11.glBegin((int)1);
        ChunkData.color(LightOverlay.secondaryColor);
        for (Long2ByteMap.Entry objectEntry : this.data().long2ByteEntrySet()) {
            crossType = objectEntry.getByteValue();
            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
            if (crossType != 2) continue;
            ChunkData.renderCross(level, (class_2338)mutable, collisionContext);
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public void renderList(class_1937 level, class_3726 collisionContext) {
        if (!this.generatedList) {
            this.compileList(level, collisionContext);
        }
        if (this.glListIndex != 0) {
            GL11.glCallList((int)this.glListIndex);
            GL11.glCallList((int)(this.glListIndex + 1));
            GL11.glCallList((int)(this.glListIndex + 2));
        }
    }

    private static void color(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
    }

    public static void renderCross(class_1937 level, class_2338 pos, class_3726 collisionContext) {
        double blockOffset = 0.0;
        class_265 upperOutlineShape = level.method_8320(pos).method_26172((class_1922)level, pos, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            blockOffset += upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        GL11.glVertex3d((double)((double)x + 0.01), (double)((double)y + blockOffset), (double)((double)z + 0.01));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0), (double)((double)y + blockOffset), (double)((double)z - 0.01 + 1.0));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0), (double)((double)y + blockOffset), (double)((double)z + 0.01));
        GL11.glVertex3d((double)((double)x + 0.01), (double)((double)y + blockOffset), (double)((double)z - 0.01 + 1.0));
    }

    @Override
    public void close() {
        if (this.glListIndex != 0) {
            GL11.glDeleteLists((int)this.glListIndex, (int)3);
        }
    }
}

