/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.util;

import com.tac.guns.Config;
import com.tac.guns.common.Gun;
import com.tac.guns.common.network.ServerPlayHandler;
import com.tac.guns.item.GunItem;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolTipUtil {
    public static void showBasicInfo(ItemStack stack, List<ITextComponent> tooltip) {
        Gun modifiedGun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        CompoundNBT tagCompound = stack.func_77978_p();
        if (ammo != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ammo_type", new Object[]{new TranslationTextComponent(ammo.func_77658_a()).func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        String additionalDamageText = "";
        float additionalDamage = GunModifierHelper.getAdditionalDamage((ItemStack)stack);
        if (additionalDamage > 0.0f) {
            additionalDamageText = TextFormatting.GREEN + " +" + ItemStack.field_111284_a.format(additionalDamage);
        } else if (additionalDamage < 0.0f) {
            additionalDamageText = TextFormatting.RED + " " + ItemStack.field_111284_a.format(additionalDamage);
        }
        additionalDamage = modifiedGun.getProjectile().getDamage();
        additionalDamage = GunModifierHelper.getModifiedProjectileDamage((ItemStack)stack, (float)additionalDamage);
        additionalDamage = GunEnchantmentHelper.getAcceleratorDamage((ItemStack)stack, (float)additionalDamage);
        tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.damage", new Object[]{TextFormatting.GOLD + ItemStack.field_111284_a.format(additionalDamage) + additionalDamageText}).func_240699_a_(TextFormatting.DARK_GRAY));
        if (tagCompound != null) {
            if (tagCompound.func_74767_n("IgnoreAmmo")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ignore_ammo").func_240699_a_(TextFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.func_74762_e("AmmoCount");
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ammo", new Object[]{TextFormatting.GOLD.toString() + ammoCount + "/" + GunModifierHelper.getAmmoCapacity((ItemStack)stack, (Gun)modifiedGun)}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    public static void showAttributes(ItemStack stack, List<ITextComponent> tooltip) {
        Gun modifiedGun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
        CompoundNBT tagCompound = stack.func_77978_p();
        GunItem gun = (GunItem)stack.func_77973_b();
        if (tagCompound != null) {
            double armorPen = gun.getGun().getProjectile().getGunArmorIgnore() >= 0.0f ? Math.min((Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)gun.getGun().getProjectile().getGunArmorIgnore() * 100.0, 100.0) : 0.0;
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.armorPen", new Object[]{new TranslationTextComponent(String.format("%.1f", armorPen) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA));
            int headDamgeModifier = (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)gun.getGun().getProjectile().getGunHeadDamage() >= 0.0 ? (int)((Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)gun.getGun().getProjectile().getGunHeadDamage() * 100.0) : 0;
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.headDamageModifier", new Object[]{new TranslationTextComponent(String.format("%d", headDamgeModifier) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA));
            float speed = ServerPlayHandler.calceldGunWeightSpeed((Gun)gun.getGun(), (ItemStack)stack);
            speed = Math.max(Math.min(speed, 0.1f), 0.075f);
            if (speed > 0.094f) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.lightWeightGun", new Object[]{new TranslationTextComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA));
            } else if ((double)speed < 0.095 && (double)speed > 0.0875) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.standardWeightGun", new Object[]{new TranslationTextComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_GREEN));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.heavyWeightGun", new Object[]{new TranslationTextComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_RED));
            }
            float percentageToNextLevel = tagCompound.func_74760_g("levelDmg") * 100.0f / (modifiedGun.getGeneral().getLevelReq() * (float)tagCompound.func_74762_e("level") * 3.0f);
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.current_level").func_230529_a_((ITextComponent)new TranslationTextComponent(" " + tagCompound.func_74762_e("level") + " : " + String.format("%.2f", Float.valueOf(percentageToNextLevel)) + "%")).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.BOLD));
        }
    }
}

