/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.util;

import com.tac.guns.Config;
import com.tac.guns.init.ModEffects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SightTraceUtil {
    public static boolean calculateAndApplyEffect(Effect effect, Config.EffectCriteria criteria, LivingEntity starter, LivingEntity target) {
        Vector3d p = starter.func_213303_ch().func_72441_c(0.0, 1.0, 0.0);
        Vector3d eyes = target.func_174824_e(1.0f);
        Vector3d d1 = p.func_178788_d(eyes);
        Vector3d d2 = eyes.func_178788_d(p);
        double distanceMax = (Double)criteria.radius.get();
        double distance = d1.func_72433_c();
        if (distance > distanceMax) {
            return false;
        }
        double a1 = Math.toDegrees(Math.acos(target.func_70676_i(1.0f).func_72430_b(d1.func_72432_b())));
        double a2 = Math.toDegrees(Math.acos(starter.func_70676_i(1.0f).func_72430_b(d2.func_72432_b())));
        double angleMax = 85.0;
        double affectAngle = 90.0;
        if (a1 <= 0.0 || a2 <= 0.0 || a1 > angleMax || a2 > affectAngle) {
            return false;
        }
        if (effect != ModEffects.BLINDED.get() || !((Boolean)Config.COMMON.stunGrenades.blind.criteria.raytraceOpaqueBlocks.get()).booleanValue() || SightTraceUtil.rayTraceOpaqueBlocks((Entity)starter, target.field_70170_p, eyes, p, false, false, false) == null) {
            int mx = (Integer)criteria.durationMax.get();
            int mn = (Integer)criteria.durationMin.get();
            int durationBlinded = (int)Math.round((double)mx - (double)(mx - mn) * (distance / (Double)criteria.radius.get()));
            durationBlinded = (int)((double)durationBlinded * (1.0 - a1 * (1.0 - (Double)criteria.angleAttenuationMax.get()) / angleMax));
            target.func_195064_c(new EffectInstance(effect, durationBlinded));
            return !(target instanceof PlayerEntity);
        }
        return false;
    }

    @Nullable
    public static RayTraceResult rayTraceOpaqueBlocks(Entity caster, World world, Vector3d start, Vector3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                int startZ;
                int startY;
                int endX = MathHelper.func_76128_c((double)end.field_72450_a);
                int endY = MathHelper.func_76128_c((double)end.field_72448_b);
                int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
                int startX = MathHelper.func_76128_c((double)start.field_72450_a);
                BlockPos pos = new BlockPos(startX, startY = MathHelper.func_76128_c((double)start.field_72448_b), startZ = MathHelper.func_76128_c((double)start.field_72449_c));
                BlockState stateInside = world.func_180495_p(pos);
                if (!(stateInside.func_200016_a((IBlockReader)world, pos) == 0 || ignoreBlockWithoutBoundingBox && stateInside.func_196952_d((IBlockReader)world, pos) == VoxelShapes.func_197880_a())) {
                    return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, caster));
                }
                Object raytraceresult2 = null;
                int limit = 200;
                while (limit-- >= 0) {
                    BlockState state;
                    Direction direction;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return null;
                    }
                    boolean completedX = true;
                    boolean completedY = true;
                    boolean completedZ = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (endX > startX) {
                        d0 = startX + 1;
                    } else if (endX < startX) {
                        d0 = startX;
                    } else {
                        completedX = false;
                    }
                    if (endY > startY) {
                        d1 = startY + 1;
                    } else if (endY < startY) {
                        d1 = startY;
                    } else {
                        completedY = false;
                    }
                    if (endZ > startZ) {
                        d2 = startZ + 1;
                    } else if (endZ < startZ) {
                        d2 = startZ;
                    } else {
                        completedZ = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = end.field_72450_a - start.field_72450_a;
                    double d7 = end.field_72448_b - start.field_72448_b;
                    double d8 = end.field_72449_c - start.field_72449_c;
                    if (completedX) {
                        d3 = (d0 - start.field_72450_a) / d6;
                    }
                    if (completedY) {
                        d4 = (d1 - start.field_72448_b) / d7;
                    }
                    if (completedZ) {
                        d5 = (d2 - start.field_72449_c) / d8;
                    }
                    if (d3 == 0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == 0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == 0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        direction = endX > startX ? Direction.WEST : Direction.EAST;
                        start = new Vector3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        direction = endY > startY ? Direction.DOWN : Direction.UP;
                        start = new Vector3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
                    } else {
                        direction = endZ > startZ ? Direction.NORTH : Direction.SOUTH;
                        start = new Vector3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
                    }
                    if ((state = world.func_180495_p(pos = new BlockPos(startX = MathHelper.func_76128_c((double)start.field_72450_a) - (direction == Direction.EAST ? 1 : 0), startY = MathHelper.func_76128_c((double)start.field_72448_b) - (direction == Direction.UP ? 1 : 0), startZ = MathHelper.func_76128_c((double)start.field_72449_c) - (direction == Direction.SOUTH ? 1 : 0)))).func_200016_a((IBlockReader)world, pos) == 0 || ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && state.func_196952_d((IBlockReader)world, pos) == VoxelShapes.func_197880_a()) continue;
                    return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, caster));
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

