/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.network.message;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.xjqsh.lesraisinsadd.common.data.IMetaHolder;
import me.xjqsh.lesraisinsadd.common.data.NetworkDataManager;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SCustomMeta {
    private Map<ResourceLocation, JsonElement> metaMap;

    public SCustomMeta(Map<ResourceLocation, JsonElement> metaMap) {
        this.metaMap = metaMap;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.metaMap.size());
        for (Map.Entry<ResourceLocation, JsonElement> e : this.metaMap.entrySet()) {
            buffer.func_192572_a(e.getKey());
            buffer.func_180714_a(e.getValue().toString());
        }
    }

    public static SCustomMeta decode(PacketBuffer buffer) {
        int length = buffer.readInt();
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        for (int i = 0; i < length; ++i) {
            ResourceLocation rl = buffer.func_192575_l();
            String str = buffer.func_218666_n();
            JsonObject element = JSONUtils.func_212745_a((String)str);
            map.put(rl, (JsonElement)element);
        }
        return new SCustomMeta(map);
    }

    public static void handle(SCustomMeta msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            for (Map.Entry<ResourceLocation, JsonElement> e : msg.metaMap.entrySet()) {
                ResourceLocation rl = e.getKey();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
                if (!(item instanceof IMetaHolder)) continue;
                ((IMetaHolder)item).loadFromJson(NetworkDataManager.GSON, e.getValue());
            }
        });
        context.setPacketHandled(true);
    }
}

